/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;

public class LayerManager {
    private int viewLeft;
    private int viewTop;
    private int viewWidth = Integer.MAX_VALUE;
    private int viewHeight = Integer.MAX_VALUE;
    private int count;
    private Layer[] layers = new Layer[7];
    private final Object monitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Layer layer, int index) {
        if (layer == null) {
            throw new NullPointerException("LayerManager.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 layer \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            Object[] list = this.layers;
            int len = this.count;
            int prevIndex = Array.findb((Object[])this.layers, (int)(len - 1), (Object)layer);
            if (index < 0 || index > (prevIndex >= 0 ? len - 1 : len)) {
                error = true;
            } else {
                int c;
                if (prevIndex >= 0) {
                    if ((c = --len - prevIndex) > 0) {
                        Array.copy((Object[])list, (int)(prevIndex + 1), (Object[])list, (int)prevIndex, (int)c);
                    }
                } else if (len == list.length) {
                    Object[] objectArray = list;
                    this.layers = new Layer[(len << 1) + 1];
                    list = this.layers;
                    Array.copy((Object[])objectArray, (int)0, (Object[])this.layers, (int)0, (int)len);
                }
                if ((c = len++ - index) > 0) {
                    Array.copy((Object[])list, (int)index, (Object[])list, (int)(index + 1), (int)c);
                }
                list[index] = layer;
                this.count = len;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("LayerManager.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Layer layer) {
        if (layer == null) {
            throw new NullPointerException("LayerManager.remove: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 layer \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.monitor;
        synchronized (object) {
            Object[] list = this.layers;
            int len = this.count - 1;
            int index = Array.findb((Object[])this.layers, (int)len, (Object)layer);
            if (index >= 0) {
                int c = len - index;
                if (c > 0) {
                    Array.copy((Object[])list, (int)(index + 1), (Object[])list, (int)index, (int)c);
                }
                this.count = len;
                list[this.count] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Layer layer) {
        if (layer == null) {
            throw new NullPointerException("LayerManager.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 layer \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.monitor;
        synchronized (object) {
            Object[] list = this.layers;
            int len = this.count;
            int prevIndex = Array.findb((Object[])this.layers, (int)(len - 1), (Object)layer);
            if (prevIndex >= 0) {
                int c;
                if ((c = --len - prevIndex) > 0) {
                    Array.copy((Object[])list, (int)(prevIndex + 1), (Object[])list, (int)prevIndex, (int)c);
                }
            } else if (len == list.length) {
                Object[] objectArray = list;
                this.layers = new Layer[(len << 1) + 1];
                list = this.layers;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.layers, (int)0, (int)len);
            }
            list[len++] = layer;
            this.count = len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics render, int left, int top) {
        if (render == null) {
            throw new NullPointerException("LayerManager.paint: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 render \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int clipLeft = render.getClipX();
        int clipTop = render.getClipY();
        int clipWidth = render.getClipWidth();
        int clipHeight = render.getClipHeight();
        Object object = this.monitor;
        synchronized (object) {
            int viewLeft = this.viewLeft;
            int viewWidth = this.viewWidth;
            int viewRight = viewLeft + viewWidth;
            int viewTop = this.viewTop;
            int viewHeight = this.viewHeight;
            int viewBottom = viewTop + viewHeight;
            render.translate(left - viewLeft, top - viewTop);
            render.clipRect(viewLeft, viewTop, viewWidth, viewHeight);
            try {
                Layer[] list = this.layers;
                int i = this.count;
                while (i-- > 0) {
                    int currTop;
                    int currLeft;
                    Layer c = list[i];
                    if (!c.visibility || (currLeft = c.left) >= viewRight || (currTop = c.top) >= viewBottom || currLeft + c.width <= viewLeft || currTop + c.height <= viewTop) continue;
                    c.paint(render);
                }
            }
            finally {
                render.translate(viewLeft - left, viewTop - top);
                render.setClip(clipLeft, clipTop, clipWidth, clipHeight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewWindow(int left, int top, int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("LayerManager.setViewWindow: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("LayerManager.setViewWindow: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        Object object = this.monitor;
        synchronized (object) {
            this.viewLeft = left;
            this.viewTop = top;
            this.viewWidth = width;
            this.viewHeight = height;
        }
    }

    public int getSize() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer getLayerAt(int index) {
        Layer result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (index < 0 || index >= this.count) {
                error = true;
                result = null;
            } else {
                result = this.layers[index];
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("LayerManager.getLayerAt: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }
}

