/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.lcdui;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.ScrollBar;
import malik.emulator.application.PointerEvent;
import malik.emulator.microedition.lcdui.ScrollBarStyle;

public final class SystemScrollBarStyle
extends ScrollBarStyle {
    private static final int ELEMENT_NONE = 0;
    private static final int ELEMENT_SLIDER = 1;
    private static final int ELEMENT_PAGE_BACK = 2;
    private static final int ELEMENT_PAGE_NEXT = 3;
    private static final int ELEMENT_SCROLL_BACK = 4;
    private static final int ELEMENT_SCROLL_NEXT = 5;
    private static final int SLIDER_MINIMUM_LENGTH = 7;
    private int focused;
    private int pressedHorz;
    private int pressedVert;

    private static int getHorizontalScrollBarFocusedElement(int page, int range, int position, int x, int y, int width, int height) {
        if (y >= 0 && y < height) {
            if (width <= 32) {
                int center = width >> 1;
                if (x >= 0 && x < center) {
                    return 4;
                }
                if (x >= center && x < width) {
                    return 5;
                }
            }
            if (x >= 0 && x < 16) {
                return 4;
            }
            if (x >= width - 16 && x < width) {
                return 5;
            }
            if (width >= 39 && page > 0 && range > page) {
                int sl = ScrollBarStyle.getSliderLength(page, range, width - 32, 7);
                int x1 = ScrollBarStyle.getSliderPosition(page, range, position, width - 32, sl) + 16;
                int x2 = sl + x1 - 1;
                if (x >= 16 && x < x1) {
                    return 2;
                }
                if (x >= x1 && x <= x2) {
                    return 1;
                }
                if (x > x2 && x < width - 16) {
                    return 3;
                }
            }
        }
        return 0;
    }

    private static int getVerticalScrollBarFocusedElement(int page, int range, int position, int x, int y, int width, int height) {
        if (x >= 0 && x < width) {
            if (height <= 32) {
                int center = height >> 1;
                if (y >= 0 && y < center) {
                    return 4;
                }
                if (y >= center && y < height) {
                    return 5;
                }
            }
            if (y >= 0 && y < 16) {
                return 4;
            }
            if (y >= height - 16 && y < height) {
                return 5;
            }
            if (height >= 39 && page > 0 && range > page) {
                int sl = ScrollBarStyle.getSliderLength(page, range, height - 32, 7);
                int y1 = ScrollBarStyle.getSliderPosition(page, range, position, height - 32, sl) + 16;
                int y2 = sl + y1 - 1;
                if (y >= 16 && y < y1) {
                    return 2;
                }
                if (y >= y1 && y <= y2) {
                    return 1;
                }
                if (y > y2 && y < height - 16) {
                    return 3;
                }
            }
        }
        return 0;
    }

    public SystemScrollBarStyle() {
        super(16);
    }

    public void horizontalScrollBarPointerEvent(ScrollBar scrollbar, PointerEvent event, int width, int height) {
        int page = scrollbar.getPage();
        int range = scrollbar.getRange();
        switch (event.getAction()) {
            case 10: {
                this.focused = this.pressedHorz = SystemScrollBarStyle.getHorizontalScrollBarFocusedElement(page, range, scrollbar.getPosition(), event.getX(), event.getY(), width, height);
                switch (this.pressedHorz) {
                    case 2: {
                        scrollbar.scroll(-page);
                        break;
                    }
                    case 3: {
                        scrollbar.scroll(page);
                        break;
                    }
                    case 4: {
                        scrollbar.scroll(-16);
                        break;
                    }
                    case 5: {
                        scrollbar.scroll(16);
                    }
                }
                scrollbar.repaint();
                break;
            }
            case 9: 
            case 14: 
            case 15: {
                int f = this.focused;
                if (page > 0 && range > page && f == 1) {
                    int x = event.getX();
                    int p = event.historicalX(1);
                    scrollbar.scroll((int)((double)(x - p) * (double)range / (double)(width - 32)));
                }
                if (this.pressedHorz == (this.pressedHorz = SystemScrollBarStyle.getHorizontalScrollBarFocusedElement(page, range, scrollbar.getPosition(), event.getX(), event.getY(), width, height) != f ? 0 : f)) break;
                scrollbar.repaint();
                break;
            }
            case 11: {
                if (page > 0 && range > page && this.focused == 1) {
                    int x = event.getX();
                    int p = event.historicalX(1);
                    scrollbar.scroll((int)((double)(x - p) * (double)range / (double)(width - 32)));
                }
                this.focused = 0;
                this.pressedHorz = 0;
                scrollbar.repaint();
            }
        }
    }

    public void horizontalScrollBarPaintEvent(ScrollBar scrollbar, Graphics render, int width, int height) {
        boolean enabled;
        int page = scrollbar.getPage();
        int range = scrollbar.getRange();
        int element = this.pressedHorz;
        boolean bl = enabled = page > 0 && range > page;
        if (width <= 32) {
            int center = width >> 1;
            render.drawElement(10, 2, enabled ? (element != 4 ? 0 : 1) : 2, 0, 0, center, height);
            render.drawElement(10, 3, enabled ? (element != 5 ? 0 : 1) : 2, center, 0, width - center, height);
            return;
        }
        render.drawElement(10, 2, enabled ? (element != 4 ? 0 : 1) : 2, 0, 0, 16, height);
        render.drawElement(10, 3, enabled ? (element != 5 ? 0 : 1) : 2, width - 16, 0, 16, height);
        if (width < 39 || !enabled) {
            render.drawElement(10, 6, enabled ? 0 : 2, 16, 0, width - 32, height);
            return;
        }
        int sl = ScrollBarStyle.getSliderLength(page, range, width - 32, 7);
        int x1 = ScrollBarStyle.getSliderPosition(page, range, scrollbar.getPosition(), width - 32, sl) + 16;
        int x2 = sl + x1;
        render.drawElement(10, 6, element != 2 ? 0 : 1, 16, 0, x1 - 16, height);
        render.drawElement(10, 7, element != 3 ? 0 : 1, x2, 0, width - x2 - 16, height);
        render.drawElement(10, 4, element != 1 ? 0 : 1, x1, 0, x2 - x1, height);
    }

    public void verticalScrollBarPointerEvent(ScrollBar scrollbar, PointerEvent event, int width, int height) {
        int page = scrollbar.getPage();
        int range = scrollbar.getRange();
        switch (event.getAction()) {
            case 10: {
                this.focused = this.pressedVert = SystemScrollBarStyle.getVerticalScrollBarFocusedElement(page, range, scrollbar.getPosition(), event.getX(), event.getY(), width, height);
                switch (this.pressedVert) {
                    case 2: {
                        scrollbar.scroll(-page);
                        break;
                    }
                    case 3: {
                        scrollbar.scroll(page);
                        break;
                    }
                    case 4: {
                        scrollbar.scroll(-16);
                        break;
                    }
                    case 5: {
                        scrollbar.scroll(16);
                    }
                }
                scrollbar.repaint();
                break;
            }
            case 9: 
            case 14: 
            case 15: {
                int f = this.focused;
                if (page > 0 && range > page && f == 1) {
                    int y = event.getY();
                    int p = event.historicalY(1);
                    scrollbar.scroll((int)((double)(y - p) * (double)range / (double)(height - 32)));
                }
                if (this.pressedVert == (this.pressedVert = SystemScrollBarStyle.getVerticalScrollBarFocusedElement(page, range, scrollbar.getPosition(), event.getX(), event.getY(), width, height) != f ? 0 : f)) break;
                scrollbar.repaint();
                break;
            }
            case 11: {
                if (page > 0 && range > page && this.focused == 1) {
                    int y = event.getY();
                    int p = event.historicalY(1);
                    scrollbar.scroll((int)((double)(y - p) * (double)range / (double)(height - 32)));
                }
                this.focused = 0;
                this.pressedVert = 0;
                scrollbar.repaint();
            }
        }
    }

    public void verticalScrollBarPaintEvent(ScrollBar scrollbar, Graphics render, int width, int height) {
        boolean enabled;
        int page = scrollbar.getPage();
        int range = scrollbar.getRange();
        int element = this.pressedVert;
        boolean bl = enabled = page > 0 && range > page;
        if (height <= 32) {
            int center = height >> 1;
            render.drawElement(10, 0, enabled ? (element != 4 ? 0 : 1) : 2, 0, 0, width, center);
            render.drawElement(10, 1, enabled ? (element != 5 ? 0 : 1) : 2, 0, center, width, height - center);
            return;
        }
        render.drawElement(10, 0, enabled ? (element != 4 ? 0 : 1) : 2, 0, 0, width, 16);
        render.drawElement(10, 1, enabled ? (element != 5 ? 0 : 1) : 2, 0, height - 16, width, 16);
        if (height < 39 || !enabled) {
            render.drawElement(10, 8, enabled ? 0 : 2, 0, 16, width, height - 32);
            return;
        }
        int sl = ScrollBarStyle.getSliderLength(page, range, height - 32, 7);
        int y1 = ScrollBarStyle.getSliderPosition(page, range, scrollbar.getPosition(), height - 32, sl) + 16;
        int y2 = sl + y1;
        render.drawElement(10, 8, element != 2 ? 0 : 1, 0, 16, width, y1 - 16);
        render.drawElement(10, 9, element != 3 ? 0 : 1, 0, y2, width, height - y2 - 16);
        render.drawElement(10, 5, element != 1 ? 0 : 1, 0, y1, width, y2 - y1);
    }

    public void sizeGripPaintEvent(boolean sizeChangeAllowed, Graphics render, int width, int height) {
        render.drawElement(10, sizeChangeAllowed ? 11 : 12, 0, 0, 0, width, height);
    }
}

