/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import java.io.IOException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.microedition.io.Connection;

public class RemoteDevice {
    private static final int ADDRESS_LENGTH = 12;
    private String address;

    public static RemoteDevice getRemoteDevice(Connection connection) throws IOException {
        throw new IllegalArgumentException("RemoteDevice.getRemoteDevice: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 connection.");
    }

    protected RemoteDevice(String address) {
        if (address == null) {
            throw new NullPointerException("RemoteDevice: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 address \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (address.length() != 12) {
            throw new IllegalArgumentException("RemoteDevice: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 address \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0443\u044e \u0434\u043b\u0438\u043d\u0443 (\u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e 12 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432).");
        }
        int i = 12;
        while (i-- > 0) {
            char c = address.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
            throw new IllegalArgumentException("RemoteDevice: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 address.");
        }
        try {
            if (address.equalsIgnoreCase(LocalDevice.getLocalDevice().getBluetoothAddress())) {
                throw new IllegalArgumentException("RemoteDevice: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 address \u0440\u0430\u0432\u0435\u043d \u0430\u0434\u0440\u0435\u0441\u0443 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430.");
            }
        }
        catch (BluetoothStateException bluetoothStateException) {
            throw new RuntimeException("RemoteDevice: \u0441\u0438\u0441\u0442\u0435\u043c\u0430 Bluetooth-\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0439 \u043d\u0435 \u043f\u0440\u043e\u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u0430.");
        }
        this.address = address;
    }

    public boolean equals(Object ref) {
        return ref == this || ref instanceof RemoteDevice && this.address.equals(((RemoteDevice)ref).address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean authenticate() throws IOException {
        return false;
    }

    public boolean authorize(Connection connection) throws IOException {
        throw new IllegalArgumentException("RemoteDevice.authorize: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 connection.");
    }

    public boolean encrypt(Connection connection, boolean on) throws IOException {
        throw new IllegalArgumentException("RemoteDevice.encrypt: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 connection.");
    }

    public boolean isAuthenticated() {
        return false;
    }

    public boolean isAuthorized(Connection connection) throws IOException {
        throw new IllegalArgumentException("RemoteDevice.isAuthorized: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 connection.");
    }

    public boolean isEncrypted() {
        return false;
    }

    public boolean isTrustedDevice() {
        return false;
    }

    public String getFriendlyName(boolean ask) throws IOException {
        throw new IOException("RemoteDevice.getFriendlyName: \u0443\u0434\u0430\u043b\u0451\u043d\u043d\u043e\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e.");
    }

    public final String getBluetoothAddress() {
        return this.address;
    }
}

