/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.CustomScrollBar;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ScreenGraphics;
import javax.microedition.lcdui.SurfaceScreen;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.DeviceSettings;
import malik.emulator.microedition.lcdui.FastMultilinedStringBuilder;
import malik.emulator.microedition.lcdui.MultilinedStringBuilder;
import malik.emulator.microedition.lcdui.ScrollBarStyle;
import malik.emulator.util.StringBuilder;

public class Alert
extends SurfaceScreen {
    static final int ICON_WIDTH = 48;
    static final int ICON_HEIGHT = 48;
    public static final int FOREVER = -2;
    private static final Font FONT = Font.getFont(0, 1, 8);
    public static final Command DISMISS_COMMAND = Displayable.createDefaultCommand("\u0417\u0430\u043a\u0440\u044b\u0442\u044c", 4, Integer.MIN_VALUE);
    private static final CommandListener DEFAULT_LISTENER = new CommandListener(){

        public void commandAction(Command command, Displayable screen) {
            Display parent;
            if (command == DISMISS_COMMAND && (parent = screen.getParentDisplay()) != null) {
                parent.hideSurfaceScreen();
            }
        }
    };
    private boolean placeItemsNeeded;
    private char[] buffer;
    private AlertType type;
    private Image icon;
    private Gauge indicator;
    private String textAsString;
    private final MultilinedStringBuilder textAsBuilder;

    public Alert(String title) {
        this(title, null, null, null, null, null);
    }

    public Alert(String title, String text, Image icon, AlertType type) {
        this(title, null, text, icon, null, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Alert(String title, ScrollBarStyle style, String text, Image icon, Gauge indicator, AlertType type) {
        super(title, 0, true, style);
        if (indicator != null) {
            Command.Owner commands = indicator.getCommands();
            if (commands.size() > 0 || commands.defaultCommand() != null) {
                throw new IllegalArgumentException("Alert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 indicator \u0438\u043c\u0435\u0435\u0442 \u043a\u043e\u043c\u0430\u043d\u0434\u044b.");
            }
            if (indicator.getListener() != null) {
                throw new IllegalArgumentException("Alert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 indicator \u0438\u043c\u0435\u0435\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u043a\u043e\u043c\u0430\u043d\u0434.");
            }
            if (indicator.hasLabel()) {
                throw new IllegalArgumentException("Alert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 indicator \u0438\u043c\u0435\u0435\u0442 \u043c\u0435\u0442\u043a\u0443.");
            }
            if (indicator.suppliedLayout() != 0) {
                throw new IllegalArgumentException("Alert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 indicator \u0438\u043c\u0435\u0435\u0442 \u043a\u043e\u043c\u043f\u043e\u043d\u043e\u0432\u043a\u0443, \u043e\u0442\u043b\u0438\u0447\u043d\u0443\u044e \u043e\u0442 Item.LAYOUT_DEFAULT.");
            }
            if (indicator.suppliedPreferredWidth() > -1 || indicator.suppliedPreferredHeight() > -1) {
                throw new IllegalArgumentException("Alert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 indicator \u0438\u043c\u0435\u0435\u0442 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u0435\u0434\u043f\u043e\u0447\u0438\u0442\u0430\u0435\u043c\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440.");
            }
            if (indicator.interactive) {
                throw new IllegalArgumentException("Alert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 indicator \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0438\u043d\u0442\u0435\u0440\u0430\u043a\u0442\u0438\u0432\u043d\u044b\u043c.");
            }
            boolean error = false;
            Object object = Item.OWNER_MONITOR;
            synchronized (object) {
                if (indicator.owner != null) {
                    error = true;
                } else {
                    indicator.owner = this;
                }
            }
            if (error) {
                throw new IllegalArgumentException("Alert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 indicator \u0443\u0436\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u044d\u043a\u0440\u0430\u043d\u0443.");
            }
        }
        this.type = type;
        this.icon = icon == null ? null : Image.createImage(icon);
        this.indicator = indicator;
        this.textAsString = text;
        FastMultilinedStringBuilder builder = new FastMultilinedStringBuilder();
        this.textAsBuilder = builder;
        super.setCommandListener(DEFAULT_LISTENER);
        this.helper.setDefaultCommand(DISMISS_COMMAND);
        builder.append(text);
        this.placeCommands();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(Command command) {
        if (command == null) {
            throw new NullPointerException("Alert.addCommand: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 command \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (command != DISMISS_COMMAND) {
            Displayable.Helper commands = this.helper;
            Object object = Command.MONITOR;
            synchronized (object) {
                commands.setDefaultCommand(null);
                commands.addCommand(command);
            }
            this.placeCommands();
            this.requestPaintAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(Command command) {
        if (command != null && command != DISMISS_COMMAND) {
            Displayable.Helper commands = this.helper;
            Object object = Command.MONITOR;
            synchronized (object) {
                commands.removeCommand(command);
                if (commands.size() <= 0) {
                    commands.setDefaultCommand(DISMISS_COMMAND);
                }
            }
            this.placeCommands();
            this.requestPaintAll();
        }
    }

    public void setCommandListener(CommandListener listener) {
        super.setCommandListener(listener == null ? DEFAULT_LISTENER : listener);
    }

    public void setTimeout(int timeout) {
        if (timeout != -2 && timeout <= 0) {
            throw new IllegalArgumentException("Alert.setTimeout: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 timeout \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String text) {
        MultilinedStringBuilder builder;
        MultilinedStringBuilder multilinedStringBuilder = builder = this.textAsBuilder;
        synchronized (builder) {
            this.placeItemsNeeded = true;
            this.textAsString = text;
            builder.clear();
            builder.append(text);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.scroll.setPosition(0);
            this.requestPaint((byte)2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(Image icon) {
        MultilinedStringBuilder multilinedStringBuilder = this.textAsBuilder;
        synchronized (multilinedStringBuilder) {
            this.placeItemsNeeded = true;
            this.icon = icon == null ? null : Image.createImage(icon);
        }
        this.requestPaint((byte)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndicator(Gauge indicator) {
        if (indicator != null) {
            Command.Owner commands = indicator.getCommands();
            if (commands.size() > 0 || commands.defaultCommand() != null) {
                throw new IllegalArgumentException("Alert.setIndicator: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 indicator \u0438\u043c\u0435\u0435\u0442 \u043a\u043e\u043c\u0430\u043d\u0434\u044b.");
            }
            if (indicator.getListener() != null) {
                throw new IllegalArgumentException("Alert.setIndicator: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 indicator \u0438\u043c\u0435\u0435\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u043a\u043e\u043c\u0430\u043d\u0434.");
            }
            if (indicator.hasLabel()) {
                throw new IllegalArgumentException("Alert.setIndicator: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 indicator \u0438\u043c\u0435\u0435\u0442 \u043c\u0435\u0442\u043a\u0443.");
            }
            if (indicator.suppliedLayout() != 0) {
                throw new IllegalArgumentException("Alert.setIndicator: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 indicator \u0438\u043c\u0435\u0435\u0442 \u043a\u043e\u043c\u043f\u043e\u043d\u043e\u0432\u043a\u0443, \u043e\u0442\u043b\u0438\u0447\u043d\u0443\u044e \u043e\u0442 Item.LAYOUT_DEFAULT.");
            }
            if (indicator.suppliedPreferredWidth() > -1 || indicator.suppliedPreferredHeight() > -1) {
                throw new IllegalArgumentException("Alert.setIndicator: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 indicator \u0438\u043c\u0435\u0435\u0442 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u0435\u0434\u043f\u043e\u0447\u0438\u0442\u0430\u0435\u043c\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440.");
            }
            if (indicator.interactive) {
                throw new IllegalArgumentException("Alert.setIndicator: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 indicator \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0438\u043d\u0442\u0435\u0440\u0430\u043a\u0442\u0438\u0432\u043d\u044b\u043c.");
            }
            boolean error = false;
            Object object = Item.OWNER_MONITOR;
            synchronized (object) {
                if (indicator.owner != null) {
                    error = true;
                } else {
                    indicator.owner = this;
                }
            }
            if (error) {
                throw new IllegalArgumentException("Alert.setIndicator: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 indicator \u0443\u0436\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u044d\u043a\u0440\u0430\u043d\u0443.");
            }
        }
        MultilinedStringBuilder multilinedStringBuilder = this.textAsBuilder;
        synchronized (multilinedStringBuilder) {
            Gauge previous = this.indicator;
            if (previous != null) {
                previous.owner = null;
            }
            this.placeItemsNeeded = true;
            this.indicator = indicator;
        }
        this.requestPaint((byte)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(AlertType type) {
        MultilinedStringBuilder multilinedStringBuilder = this.textAsBuilder;
        synchronized (multilinedStringBuilder) {
            this.placeItemsNeeded = true;
            this.type = type;
        }
        this.requestPaint((byte)2);
    }

    public int getDefaultTimeout() {
        return -2;
    }

    public int getTimeout() {
        return -2;
    }

    public String getString() {
        return this.textAsString;
    }

    public Image getImage() {
        return this.icon;
    }

    public Gauge getIndicator() {
        return this.indicator;
    }

    public AlertType getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(ScreenGraphics render) {
        MultilinedStringBuilder builder;
        int rectHeight;
        int clipTop = render.getClipY();
        int clipWidth = render.getClipWidth();
        int clipHeight = render.getClipHeight();
        int indicatorWidth = 0;
        int indicatorHeight = 0;
        Gauge indicator = this.indicator;
        Font font = FONT;
        Image icon = this.getUsedIcon();
        if (indicator != null) {
            indicator.visible = true;
            indicatorWidth = ((Item)indicator).width;
            indicatorHeight = ((Item)indicator).height;
        }
        int rectLeft = 0;
        int rectTop = clipTop;
        int rectWidth = clipWidth;
        int n = rectHeight = indicatorHeight > 0 ? clipHeight - indicatorHeight - 2 : clipHeight;
        if (icon != null) {
            render.drawStretch(icon, 0, rectTop + (rectHeight >> 1), 48, 48, 6);
            rectLeft += 50;
            rectWidth -= 50;
        }
        int line = font.getHeight();
        int srow = rectTop / line;
        int frow = (rectTop + rectHeight - 1) / line;
        render.setFont(font);
        render.setColor(RasterCanvas.getSystemColor((int)40));
        render.setClip(0, clipTop, clipWidth, rectHeight);
        MultilinedStringBuilder multilinedStringBuilder = builder = this.textAsBuilder;
        synchronized (builder) {
            char[] lbuf = this.buffer;
            int len = builder.lines();
            int lhei = font.getHeight() * len;
            int top = rectHeight < lhei ? srow * line : rectHeight - lhei >> 1;
            int index = srow;
            while (index <= frow && index < len) {
                int lofs = builder.lineOffset(index);
                int llen = builder.lineLength(index);
                if (lbuf == null || lbuf.length < llen) {
                    lbuf = this.buffer = new char[StringBuilder.optimalCapacity((int)llen)];
                }
                builder.copy(lofs, lofs + llen, lbuf, 0);
                render.drawChars(lbuf, 0, llen, rectLeft, top, 20);
                top += line;
                ++index;
            }
            // ** MonitorExit[var18_18] (shouldn't be in output)
            if (indicator != null) {
                rectLeft = 0;
                rectTop += rectHeight + 2;
                rectWidth = clipWidth;
                rectHeight = indicatorHeight;
                int translateX = render.getTranslateX() + render.getStartPointX();
                int translateY = render.getTranslateY() + render.getStartPointY();
                render.reset();
                render.translate(translateX, translateY);
                render.clipRect(rectLeft, rectTop, indicatorWidth, indicatorHeight);
                render.clipRect(rectLeft, rectTop, rectWidth, rectHeight);
                render.translate(rectLeft, rectTop);
                indicator.onPaint(render);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSizeChanged(int width, int height) {
        MultilinedStringBuilder multilinedStringBuilder = this.textAsBuilder;
        synchronized (multilinedStringBuilder) {
            this.placeItemsNeeded = true;
        }
        super.onSizeChanged(width, height);
    }

    void onClientKeyboardEvent(KeyboardEvent event) {
        if (event.getAction() != 7) {
            int key = event.getKey();
            CustomScrollBar scrollbar = this.scroll;
            DeviceSettings settings = DeviceManager.getInstance().getSettings();
            if (key == settings.getKeyUsedAs(38)) {
                scrollbar.scroll(-FONT.getHeight());
            } else if (key == settings.getKeyUsedAs(36)) {
                scrollbar.scroll(FONT.getHeight());
            }
        }
    }

    Displayable.Helper createHelper() {
        return new Helper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void placeItems() {
        MultilinedStringBuilder builder;
        MultilinedStringBuilder multilinedStringBuilder = builder = this.textAsBuilder;
        synchronized (builder) {
            int textHeight;
            int indicatorHeight;
            boolean needed = this.placeItemsNeeded;
            if (needed) {
                this.placeItemsNeeded = false;
            }
            Gauge indicator = this.indicator;
            // ** MonitorExit[var7_2] (shouldn't be in output)
            if (!needed) {
                return;
            }
            int clientWidth = this.getApplicationWidth();
            if (indicator != null) {
                int minWidth;
                indicator.resetContentSize();
                indicator.minimumWidth = minWidth = indicator.computeMinimumWidth();
                indicator.minimumHeight = indicatorHeight = indicator.computeMinimumHeight();
                ((Item)indicator).width = clientWidth < minWidth ? minWidth : clientWidth;
                ((Item)indicator).height = indicatorHeight;
                indicator.onSizeChanged();
                indicatorHeight += 2;
            } else {
                indicatorHeight = 0;
            }
            if (this.getUsedIcon() != null) {
                clientWidth -= 50;
            }
            MultilinedStringBuilder multilinedStringBuilder2 = builder;
            synchronized (multilinedStringBuilder2) {
                Font font = FONT;
                builder.split(font, clientWidth);
                textHeight = font.getHeight() * builder.lines();
            }
            this.scroll.setRange(textHeight + indicatorHeight);
            return;
        }
    }

    private Image getUsedIcon() {
        AlertType type;
        Image result = this.icon;
        if (result == null && (type = this.type) != null) {
            result = type.getIcon();
        }
        return result;
    }

    class Helper
    extends SurfaceScreen.Helper {
        protected void execute() {
            this.serviceSizeChanged();
            this.servicePlaceItems();
            this.serviceScroll();
            this.servicePaint();
        }

        protected final void servicePlaceItems() {
            Alert.this.placeItems();
        }
    }
}

