/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.io.InputStream;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import malik.emulator.io.cloud.CloudFileSystem;

final class AlertData
extends AlertType {
    private Image icon;
    private final String iconFileName;
    private Player sound;
    private final String soundFileName;
    private final String soundContentType;

    public AlertData(String iconFileName, String soundFileName, String soundContentType) {
        this.iconFileName = iconFileName;
        this.soundFileName = soundFileName;
        this.soundContentType = soundContentType;
    }

    public boolean playSound(Display display) {
        boolean result = super.playSound(display);
        if (result) {
            Player sound = this.sound;
            if (sound == null) {
                try {
                    InputStream soundFileStream = CloudFileSystem.instance.openFileForRead(this.soundFileName);
                    try {
                        sound = this.sound = Manager.createPlayer(soundFileStream, this.soundContentType);
                        this.sound.realize();
                    }
                    finally {
                        soundFileStream.close();
                    }
                    sound.prefetch();
                }
                catch (Exception e) {
                    e.printRealStackTrace();
                    return true;
                }
            }
            try {
                sound.start();
            }
            catch (MediaException e) {
                e.printRealStackTrace();
            }
        }
        return result;
    }

    Image getIcon() {
        Image result = this.icon;
        if (result == null) {
            try {
                InputStream iconFileStream = CloudFileSystem.instance.openFileForRead(this.iconFileName);
                try {
                    result = this.icon = Image.createImage(iconFileStream);
                }
                finally {
                    iconFileStream.close();
                }
            }
            catch (Exception e) {
                e.printRealStackTrace();
            }
        }
        return result;
    }
}

