/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.nokia.mid.ui.DirectGraphics;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import malik.emulator.media.graphics.Clip;
import malik.emulator.media.graphics.Drawable;
import malik.emulator.media.graphics.Paint;
import malik.emulator.media.graphics.PrimitiveRender;
import malik.emulator.media.graphics.RasterBuffer;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.media.graphics.SystemFont;
import malik.emulator.media.graphics.TextPaint;

public class Graphics
implements DirectGraphics {
    public static final int SOLID = 0;
    public static final int DOTTED = 1;
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int BASELINE = 64;
    private static final short[] XTABLE;
    private static final short[] YTABLE;
    final int width;
    final int height;
    private int stroke;
    private Font font;
    private final TextPaint paint;
    private final RasterBuffer buffer;
    private final RasterCanvas canvas;

    static {
        short[] x = new short[360];
        short[] y = new short[360];
        Graphics.init(x, y);
        XTABLE = x;
        YTABLE = y;
    }

    static void drawLine(PrimitiveRender render, int x1, int y1, int x2, int y2, boolean inclusive) {
        int d;
        int y;
        int x;
        int xerr = 0;
        int yerr = 0;
        int prevx = x = x1;
        int prevy = y = y1;
        int dx = x2 - x1;
        int incx = dx == 0 ? 0 : (dx < 0 ? -1 : 1);
        int dy = y2 - y1;
        int incy = dy == 0 ? 0 : (dy < 0 ? -1 : 1);
        dx = dx < 0 ? -dx : dx;
        dy = dy < 0 ? -dy : dy;
        int n = d = dx >= dy ? dx : dy;
        if (inclusive) {
            ++dx;
            ++dy;
            ++d;
        }
        int i = 0;
        while (i <= d) {
            yerr += dy;
            if ((xerr += dx) > d) {
                xerr -= d;
                x += incx;
            }
            if (yerr > d) {
                yerr -= d;
                y += incy;
            }
            if (dx >= dy) {
                if (y != prevy || i == d) {
                    if (prevx <= x) {
                        render.drawHorizontalLine(prevx, prevy, x - prevx);
                    } else {
                        render.drawHorizontalLine(x + 1, prevy, prevx - x);
                    }
                    prevx = x;
                    prevy = y;
                }
            } else if (x != prevx || i == d) {
                if (prevy <= y) {
                    render.drawVerticalLine(prevx, prevy, y - prevy);
                } else {
                    render.drawVerticalLine(prevx, y + 1, prevy - y);
                }
                prevx = x;
                prevy = y;
            }
            ++i;
        }
    }

    private static void init(short[] x, short[] y) {
        short[] sArray = new short[91];
        sArray[1] = 286;
        sArray[2] = 572;
        sArray[3] = 857;
        sArray[4] = 1143;
        sArray[5] = 1428;
        sArray[6] = 1713;
        sArray[7] = 1997;
        sArray[8] = 2280;
        sArray[9] = 2563;
        sArray[10] = 2845;
        sArray[11] = 3126;
        sArray[12] = 3406;
        sArray[13] = 3686;
        sArray[14] = 3964;
        sArray[15] = 4240;
        sArray[16] = 4516;
        sArray[17] = 4790;
        sArray[18] = 5063;
        sArray[19] = 5334;
        sArray[20] = 5604;
        sArray[21] = 5872;
        sArray[22] = 6137;
        sArray[23] = 6402;
        sArray[24] = 6664;
        sArray[25] = 6924;
        sArray[26] = 7182;
        sArray[27] = 7438;
        sArray[28] = 7692;
        sArray[29] = 7943;
        sArray[30] = 8192;
        sArray[31] = 8438;
        sArray[32] = 8682;
        sArray[33] = 8923;
        sArray[34] = 9162;
        sArray[35] = 9397;
        sArray[36] = 9630;
        sArray[37] = 9860;
        sArray[38] = 10087;
        sArray[39] = 10311;
        sArray[40] = 10531;
        sArray[41] = 10749;
        sArray[42] = 10963;
        sArray[43] = 11174;
        sArray[44] = 11381;
        sArray[45] = 11585;
        sArray[46] = 11786;
        sArray[47] = 11982;
        sArray[48] = 12176;
        sArray[49] = 12365;
        sArray[50] = 12551;
        sArray[51] = 12733;
        sArray[52] = 12911;
        sArray[53] = 13085;
        sArray[54] = 13255;
        sArray[55] = 13421;
        sArray[56] = 13583;
        sArray[57] = 13741;
        sArray[58] = 13894;
        sArray[59] = 14044;
        sArray[60] = 14189;
        sArray[61] = 14330;
        sArray[62] = 14466;
        sArray[63] = 14598;
        sArray[64] = 14726;
        sArray[65] = 14849;
        sArray[66] = 14968;
        sArray[67] = 15082;
        sArray[68] = 15191;
        sArray[69] = 15296;
        sArray[70] = 15396;
        sArray[71] = 15491;
        sArray[72] = 15582;
        sArray[73] = 15668;
        sArray[74] = 15749;
        sArray[75] = 15826;
        sArray[76] = 15897;
        sArray[77] = 15964;
        sArray[78] = 16026;
        sArray[79] = 16083;
        sArray[80] = 16135;
        sArray[81] = 16182;
        sArray[82] = 16225;
        sArray[83] = 16262;
        sArray[84] = 16294;
        sArray[85] = 16322;
        sArray[86] = 16344;
        sArray[87] = 16362;
        sArray[88] = 16374;
        sArray[89] = 16382;
        sArray[90] = 16384;
        short[] sin = sArray;
        int a = 90;
        while (a-- > 0) {
            x[a] = sin[90 - a];
            x[a + 90] = -sin[a];
            x[a + 180] = -sin[90 - a];
            x[a + 270] = sin[a];
            y[a] = -sin[a];
            y[a + 90] = -sin[90 - a];
            y[a + 180] = sin[a];
            y[a + 270] = sin[90 - a];
        }
    }

    private static int directGraphicsToRasterCanvasTransform(int transform) {
        switch (transform) {
            case 0: 
            case 24756: {
                return 0;
            }
            case 270: 
            case 24666: {
                return 1;
            }
            case 180: 
            case 24576: {
                return 2;
            }
            case 90: 
            case 24846: {
                return 3;
            }
            case 8192: 
            case 16564: {
                return 4;
            }
            case 8282: 
            case 16654: {
                return 5;
            }
            case 8372: 
            case 16384: {
                return 6;
            }
            case 8462: 
            case 16474: {
                return 7;
            }
        }
        return -1;
    }

    private static int spriteToRasterCanvasTransform(int transform) {
        switch (transform) {
            case 0: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 1: {
                return 6;
            }
            case 4: {
                return 7;
            }
        }
        return -1;
    }

    Graphics(RasterBuffer buffer) {
        Font font;
        int height;
        int width;
        this.width = width = buffer.getWidth();
        this.height = height = buffer.getHeight();
        this.font = font = Font.getDefaultFont();
        this.paint = new TextPaint(width, height, -16777216, true, font.getSystemFont(), font.isUnderlined(), false);
        this.buffer = buffer;
        this.canvas = new RasterCanvas(buffer);
    }

    public void drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int colorARGB) {
        TextPaint p = this.paint;
        if (p.getColor() != colorARGB) {
            int tx = p.getTranslateX();
            int ty = p.getTranslateY();
            p = new Paint(tx, ty, p.getLeft() - tx, p.getTop() - ty, p.getWidth(), p.getHeight(), colorARGB, true);
        }
        this.canvas.drawCustom((Drawable)new OutlinedTriangle(x1, y1, x2, y2, x3, y3), 0, 0, (Paint)p);
    }

    public void drawPolygon(int[] xCoords, int xOffset, int[] yCoords, int yOffset, int length, int colorARGB) {
        if (xCoords == null) {
            throw new NullPointerException("DirectGraphics.drawPolygon: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 xCoords \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (yCoords == null) {
            throw new NullPointerException("DirectGraphics.drawPolygon: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 yCoords \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound((String)"DirectGraphics.drawPolygon", (int)xCoords.length, (int)xOffset, (int)length);
        Array.checkBound((String)"DirectGraphics.drawPolygon", (int)yCoords.length, (int)yOffset, (int)length);
        if (length > 0) {
            TextPaint p = this.paint;
            if (p.getColor() != colorARGB) {
                int tx = p.getTranslateX();
                int ty = p.getTranslateY();
                p = new Paint(tx, ty, p.getLeft() - tx, p.getTop() - ty, p.getWidth(), p.getHeight(), colorARGB, true);
            }
            this.canvas.drawCustom((Drawable)new ClosedPolygon(xCoords, xOffset, yCoords, yOffset, length), 0, 0, (Paint)p);
        }
    }

    public void drawPixels(byte[] pixels, byte[] mask, int offset, int scanlength, int left, int top, int width, int height, int transform, int format) {
        int pixelsLength;
        int pixelsOffset;
        switch (format) {
            case 8: 
            case 332: {
                if (scanlength >= 0) {
                    pixelsOffset = offset;
                    pixelsLength = width + (height - 1) * scanlength;
                    break;
                }
                pixelsOffset = offset + (height - 1) * scanlength;
                pixelsLength = width + offset - pixelsOffset;
                break;
            }
            case -1: 
            case 1: 
            case 2: 
            case 4: {
                throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0444\u043e\u0440\u043c\u0430\u0442\u044b, \u0443 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043c\u0435\u043d\u044c\u0448\u0435 8 \u0431\u0438\u0442 \u043d\u0430 \u043f\u0438\u043a\u0441\u0435\u043b, \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f.");
            }
            default: {
                throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 format \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        transform = Graphics.directGraphicsToRasterCanvasTransform(transform);
        if (transform < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (width < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (width == 0 || height == 0) {
            return;
        }
        if (pixels == null) {
            throw new NullPointerException("DirectGraphics.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 pixels \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound((String)"DirectGraphics.drawPixels", (int)pixels.length, (int)pixelsOffset, (int)pixelsLength);
        if (mask != null) {
            Array.checkBound((String)"DirectGraphics.drawPixels", (int)mask.length, (int)pixelsOffset, (int)pixelsLength);
        }
        int[] pixelsNative = new int[width * height];
        RasterBuffer buffer = RasterBuffer.create((int[])pixelsNative, (int)0, (int)width, (int)width, (int)height, (boolean)false);
        switch (format) {
            case 8: {
                int i = 0;
                int j = offset;
                int dj = scanlength - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        int y = pixels[j] & 0xFF;
                        int a = mask != null ? mask[j] & 0xFF : 255;
                        pixelsNative[i] = a << 24 | y << 16 | y << 8 | y;
                        ++i;
                        ++j;
                    }
                    j += dj;
                }
                break;
            }
            case 332: {
                int i = 0;
                int j = offset;
                int dj = scanlength - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        byte p = pixels[j];
                        int a = mask != null ? mask[j] & 0xFF : 255;
                        int r = 0xE0 & p;
                        int g = 0x1C & p;
                        int b = 3 & p;
                        pixelsNative[i] = a << 24 | r << 16 | r << 13 | (r & 0xC0) << 10 | g << 11 | g << 8 | (g & 0x18) << 5 | b << 6 | b << 4 | b << 2 | b;
                        ++i;
                        ++j;
                    }
                    j += dj;
                }
                break;
            }
        }
        if ((transform & 1) != 0) {
            this.canvas.drawPixels(buffer, transform, left, top, height, width, (Clip)this.paint);
            return;
        }
        this.canvas.drawPixels(buffer, transform, left, top, width, height, (Clip)this.paint);
    }

    public void drawPixels(short[] pixels, boolean transparency, int offset, int scanlength, int left, int top, int width, int height, int transform, int format) {
        int pixelsLength;
        int pixelsOffset;
        switch (format) {
            case 444: 
            case 555: 
            case 565: 
            case 1555: 
            case 4444: {
                if (scanlength >= 0) {
                    pixelsOffset = offset;
                    pixelsLength = width + (height - 1) * scanlength;
                    break;
                }
                pixelsOffset = offset + (height - 1) * scanlength;
                pixelsLength = width + offset - pixelsOffset;
                break;
            }
            default: {
                throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 format \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        transform = Graphics.directGraphicsToRasterCanvasTransform(transform);
        if (transform < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (width < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (width == 0 || height == 0) {
            return;
        }
        if (pixels == null) {
            throw new NullPointerException("DirectGraphics.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 pixels \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound((String)"DirectGraphics.drawPixels", (int)pixels.length, (int)pixelsOffset, (int)pixelsLength);
        int[] pixelsNative = new int[width * height];
        RasterBuffer buffer = RasterBuffer.create((int[])pixelsNative, (int)0, (int)width, (int)width, (int)height, (boolean)false);
        switch (format) {
            case 444: {
                int i = 0;
                int j = offset;
                int dj = scanlength - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        short p = pixels[j];
                        int r = 0xF00 & p;
                        int g = 0xF0 & p;
                        int b = 0xF & p;
                        pixelsNative[i] = 0xFF000000 | r << 12 | r << 8 | g << 8 | g << 4 | b << 4 | b;
                        ++i;
                        ++j;
                    }
                    j += dj;
                }
                break;
            }
            case 555: {
                int i = 0;
                int j = offset;
                int dj = scanlength - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        short p = pixels[j];
                        int r = 0x7C00 & p;
                        int g = 0x3E0 & p;
                        int b = 0x1F & p;
                        pixelsNative[i] = 0xFF000000 | r << 9 | (r & 0x7000) << 4 | g << 6 | (g & 0x380) << 1 | b << 3 | (b & 0x1C) >> 2;
                        ++i;
                        ++j;
                    }
                    j += dj;
                }
                break;
            }
            case 565: {
                int i = 0;
                int j = offset;
                int dj = scanlength - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        short p = pixels[j];
                        int r = 0xF800 & p;
                        int g = 0x7E0 & p;
                        int b = 0x1F & p;
                        pixelsNative[i] = 0xFF000000 | r << 8 | (r & 0xE000) << 3 | g << 5 | (g & 0x600) >> 1 | b << 3 | (b & 0x1C) >> 2;
                        ++i;
                        ++j;
                    }
                    j += dj;
                }
                break;
            }
            case 1555: {
                int i = 0;
                int j = offset;
                int dj = scanlength - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        short p = pixels[j];
                        int a = 0x8000 & p;
                        int r = 0x7C00 & p;
                        int g = 0x3E0 & p;
                        int b = 0x1F & p;
                        pixelsNative[i] = a << 16 >> 7 | r << 9 | (r & 0x7000) << 4 | g << 6 | (g & 0x380) << 1 | b << 3 | (b & 0x1C) >> 2;
                        ++i;
                        ++j;
                    }
                    j += dj;
                }
                break;
            }
            case 4444: {
                int i = 0;
                int j = offset;
                int dj = scanlength - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        short p = pixels[j];
                        int a = 0xF000 & p;
                        int r = 0xF00 & p;
                        int g = 0xF0 & p;
                        int b = 0xF & p;
                        pixelsNative[i] = a << 16 | a << 12 | r << 12 | r << 8 | g << 8 | g << 4 | b << 4 | b;
                        ++i;
                        ++j;
                    }
                    j += dj;
                }
                break;
            }
        }
        if ((transform & 1) != 0) {
            if (transparency) {
                this.canvas.drawPixels(buffer, transform, left, top, height, width, (Clip)this.paint);
                return;
            }
            this.canvas.copyPixels(buffer, transform, left, top, height, width, (Clip)this.paint);
            return;
        }
        if (transparency) {
            this.canvas.drawPixels(buffer, transform, left, top, width, height, (Clip)this.paint);
            return;
        }
        this.canvas.copyPixels(buffer, transform, left, top, width, height, (Clip)this.paint);
    }

    public void drawPixels(int[] pixels, boolean transparency, int offset, int scanlength, int left, int top, int width, int height, int transform, int format) {
        int pixelsLength;
        int pixelsOffset;
        switch (format) {
            case 888: 
            case 8888: {
                if (scanlength >= 0) {
                    pixelsOffset = offset;
                    pixelsLength = width + (height - 1) * scanlength;
                    break;
                }
                pixelsOffset = offset + (height - 1) * scanlength;
                pixelsLength = width + offset - pixelsOffset;
                break;
            }
            default: {
                throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 format \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        transform = Graphics.directGraphicsToRasterCanvasTransform(transform);
        if (transform < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (width < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (width == 0 || height == 0) {
            return;
        }
        if (pixels == null) {
            throw new NullPointerException("DirectGraphics.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 pixels \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound((String)"DirectGraphics.drawPixels", (int)pixels.length, (int)pixelsOffset, (int)pixelsLength);
        RasterBuffer buffer = RasterBuffer.create((int[])pixels, (int)offset, (int)scanlength, (int)width, (int)height, (format == 888 ? 1 : 0) != 0);
        if ((transform & 1) != 0) {
            if (transparency) {
                this.canvas.drawPixels(buffer, transform, left, top, height, width, (Clip)this.paint);
                return;
            }
            this.canvas.copyPixels(buffer, transform, left, top, height, width, (Clip)this.paint);
            return;
        }
        if (transparency) {
            this.canvas.drawPixels(buffer, transform, left, top, width, height, (Clip)this.paint);
            return;
        }
        this.canvas.copyPixels(buffer, transform, left, top, width, height, (Clip)this.paint);
    }

    public void drawImage(Image image, int x, int y, int anchor, int transform) {
        int height;
        int width;
        if (image == null) {
            throw new NullPointerException("DirectGraphics.drawImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 image \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if ((transform = Graphics.directGraphicsToRasterCanvasTransform(transform)) < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if ((transform & 1) != 0) {
            width = image.height;
            height = image.width;
        } else {
            width = image.width;
            height = image.height;
        }
        switch (anchor) {
            case 0: 
            case 20: {
                break;
            }
            case 17: {
                x -= width >> 1;
                break;
            }
            case 24: {
                x -= width;
                break;
            }
            case 6: {
                y -= height >> 1;
                break;
            }
            case 3: {
                x -= width >> 1;
                y -= height >> 1;
                break;
            }
            case 10: {
                x -= width;
                y -= height >> 1;
                break;
            }
            case 36: {
                y -= height;
                break;
            }
            case 33: {
                x -= width >> 1;
                y -= height;
                break;
            }
            case 40: {
                x -= width;
                y -= height;
                break;
            }
            default: {
                throw new IllegalArgumentException("DirectGraphics.drawImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 anchor \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        this.canvas.drawPixels(image.buffer, transform, x, y, width, height, (Clip)this.paint);
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int colorARGB) {
        TextPaint p = this.paint;
        if (p.getColor() != colorARGB) {
            int tx = p.getTranslateX();
            int ty = p.getTranslateY();
            p = new Paint(tx, ty, p.getLeft() - tx, p.getTop() - ty, p.getWidth(), p.getHeight(), colorARGB, true);
        }
        this.canvas.drawCustom((Drawable)new FilledTriangle(x1, y1, x2, y2, x3, y3), 0, 0, (Paint)p);
    }

    public void fillPolygon(int[] xCoords, int xOffset, int[] yCoords, int yOffset, int length, int colorARGB) {
        if (xCoords == null) {
            throw new NullPointerException("DirectGraphics.fillPolygon: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 xCoords \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (yCoords == null) {
            throw new NullPointerException("DirectGraphics.fillPolygon: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 yCoords \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound((String)"DirectGraphics.fillPolygon", (int)xCoords.length, (int)xOffset, (int)length);
        Array.checkBound((String)"DirectGraphics.fillPolygon", (int)yCoords.length, (int)yOffset, (int)length);
        if (length > 0) {
            TextPaint p = this.paint;
            if (p.getColor() != colorARGB) {
                int tx = p.getTranslateX();
                int ty = p.getTranslateY();
                p = new Paint(tx, ty, p.getLeft() - tx, p.getTop() - ty, p.getWidth(), p.getHeight(), colorARGB, true);
            }
            this.canvas.drawCustom((Drawable)new FilledPolygon(xCoords, xOffset, yCoords, yOffset, length), 0, 0, (Paint)p);
        }
    }

    public void setARGBColor(int colorARGB) {
        this.paint.setColor(colorARGB);
    }

    public void getPixels(byte[] pixels, byte[] mask, int offset, int scanlength, int left, int top, int width, int height, int format) {
        int pixelsLength;
        int pixelsOffset;
        switch (format) {
            case 8: 
            case 332: {
                if (scanlength >= 0) {
                    pixelsOffset = offset;
                    pixelsLength = width + (height - 1) * scanlength;
                    break;
                }
                pixelsOffset = offset + (height - 1) * scanlength;
                pixelsLength = width + offset - pixelsOffset;
                break;
            }
            case -1: 
            case 1: 
            case 2: 
            case 4: {
                throw new IllegalArgumentException("DirectGraphics.getPixels: \u0444\u043e\u0440\u043c\u0430\u0442\u044b, \u0443 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043c\u0435\u043d\u044c\u0448\u0435 8 \u0431\u0438\u0442 \u043d\u0430 \u043f\u0438\u043a\u0441\u0435\u043b, \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f.");
            }
            default: {
                throw new IllegalArgumentException("DirectGraphics.getPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 format \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        if (width < 0) {
            throw new IllegalArgumentException("DirectGraphics.getPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("DirectGraphics.getPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (width == 0 || height == 0) {
            return;
        }
        if (pixels == null) {
            throw new NullPointerException("DirectGraphics.getPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 pixels \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound((String)"DirectGraphics.getPixels", (int)pixels.length, (int)pixelsOffset, (int)pixelsLength);
        if (mask != null) {
            Array.checkBound((String)"DirectGraphics.getPixels", (int)mask.length, (int)pixelsOffset, (int)pixelsLength);
        }
        TextPaint clip = this.paint;
        this.check("DirectGraphics.getPixels", left += clip.getTranslateX(), top += clip.getTranslateY(), width, height);
        RasterBuffer srcBuffer = this.buffer;
        boolean srcOpaque = srcBuffer.isOpaque();
        int[] srcPixels = srcBuffer.getPixels();
        int srcOffset = srcBuffer.getOffset();
        int srcScanln = srcBuffer.getScanlength();
        switch (format) {
            case 8: {
                int i = offset;
                int di = scanlength - width;
                int j = srcOffset + left + top * srcScanln;
                int dj = srcScanln - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        int p = srcPixels[j];
                        pixels[i] = (byte)(76 * (p >> 16 & 0xFF) + 152 * (p >> 8 & 0xFF) + 28 * (p & 0xFF) >> 8);
                        if (mask != null) {
                            mask[i] = (byte)(srcOpaque ? -1 : (byte)(p >> 24));
                        }
                        ++i;
                        ++j;
                    }
                    i += di;
                    j += dj;
                }
                break;
            }
            case 332: {
                int i = offset;
                int di = scanlength - width;
                int j = srcOffset + left + top * srcScanln;
                int dj = srcScanln - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        int p = srcPixels[j];
                        pixels[i] = (byte)(p >> 16 & 0xE0 | p >> 11 & 0x1C | p >> 6 & 3);
                        if (mask != null) {
                            mask[i] = (byte)(srcOpaque ? -1 : (byte)(p >> 24));
                        }
                        ++i;
                        ++j;
                    }
                    i += di;
                    j += dj;
                }
                break;
            }
        }
    }

    public void getPixels(short[] pixels, int offset, int scanlength, int left, int top, int width, int height, int format) {
        int pixelsLength;
        int pixelsOffset;
        switch (format) {
            case 444: 
            case 555: 
            case 565: 
            case 1555: 
            case 4444: {
                if (scanlength >= 0) {
                    pixelsOffset = offset;
                    pixelsLength = width + (height - 1) * scanlength;
                    break;
                }
                pixelsOffset = offset + (height - 1) * scanlength;
                pixelsLength = width + offset - pixelsOffset;
                break;
            }
            default: {
                throw new IllegalArgumentException("DirectGraphics.getPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 format \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        if (width < 0) {
            throw new IllegalArgumentException("DirectGraphics.getPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("DirectGraphics.getPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (width == 0 || height == 0) {
            return;
        }
        if (pixels == null) {
            throw new NullPointerException("DirectGraphics.getPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 pixels \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound((String)"DirectGraphics.getPixels", (int)pixels.length, (int)pixelsOffset, (int)pixelsLength);
        TextPaint clip = this.paint;
        this.check("DirectGraphics.getPixels", left += clip.getTranslateX(), top += clip.getTranslateY(), width, height);
        RasterBuffer srcBuffer = this.buffer;
        boolean srcOpaque = srcBuffer.isOpaque();
        int[] srcPixels = srcBuffer.getPixels();
        int srcOffset = srcBuffer.getOffset();
        int srcScanln = srcBuffer.getScanlength();
        switch (format) {
            case 444: {
                int i = offset;
                int di = scanlength - width;
                int j = srcOffset + left + top * srcScanln;
                int dj = srcScanln - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        int p = srcPixels[j];
                        pixels[i] = (short)(p >> 12 & 0xF00 | p >> 8 & 0xF0 | p >> 4 & 0xF);
                        ++i;
                        ++j;
                    }
                    i += di;
                    j += dj;
                }
                break;
            }
            case 555: {
                int i = offset;
                int di = scanlength - width;
                int j = srcOffset + left + top * srcScanln;
                int dj = srcScanln - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        int p = srcPixels[j];
                        pixels[i] = (short)(p >> 9 & 0x7C00 | p >> 6 & 0x3E0 | p >> 3 & 0x1F);
                        ++i;
                        ++j;
                    }
                    i += di;
                    j += dj;
                }
                break;
            }
            case 565: {
                int i = offset;
                int di = scanlength - width;
                int j = srcOffset + left + top * srcScanln;
                int dj = srcScanln - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        int p = srcPixels[j];
                        pixels[i] = (short)(p >> 8 & 0xF800 | p >> 5 & 0x7E0 | p >> 3 & 0x1F);
                        ++i;
                        ++j;
                    }
                    i += di;
                    j += dj;
                }
                break;
            }
            case 1555: {
                int i = offset;
                int di = scanlength - width;
                int j = srcOffset + left + top * srcScanln;
                int dj = srcScanln - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        int p = srcPixels[j];
                        pixels[i] = (short)((srcOpaque ? 32768 : p >> 16 & 0x8000) | p >> 9 & 0x7C00 | p >> 6 & 0x3E0 | p >> 3 & 0x1F);
                        ++i;
                        ++j;
                    }
                    i += di;
                    j += dj;
                }
                break;
            }
            case 4444: {
                int i = offset;
                int di = scanlength - width;
                int j = srcOffset + left + top * srcScanln;
                int dj = srcScanln - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        int p = srcPixels[j];
                        pixels[i] = (short)((srcOpaque ? 61440 : p >> 16 & 0xF000) | p >> 12 & 0xF00 | p >> 8 & 0xF0 | p >> 4 & 0xF);
                        ++i;
                        ++j;
                    }
                    i += di;
                    j += dj;
                }
                break;
            }
        }
    }

    public void getPixels(int[] pixels, int offset, int scanlength, int left, int top, int width, int height, int format) {
        int pixelsLength;
        int pixelsOffset;
        switch (format) {
            case 888: 
            case 8888: {
                if (scanlength >= 0) {
                    pixelsOffset = offset;
                    pixelsLength = width + (height - 1) * scanlength;
                    break;
                }
                pixelsOffset = offset + (height - 1) * scanlength;
                pixelsLength = width + offset - pixelsOffset;
                break;
            }
            default: {
                throw new IllegalArgumentException("DirectGraphics.getPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 format \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        if (width < 0) {
            throw new IllegalArgumentException("DirectGraphics.getPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("DirectGraphics.getPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (width == 0 || height == 0) {
            return;
        }
        if (pixels == null) {
            throw new NullPointerException("DirectGraphics.getPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 pixels \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound((String)"DirectGraphics.getPixels", (int)pixels.length, (int)pixelsOffset, (int)pixelsLength);
        TextPaint clip = this.paint;
        this.check("DirectGraphics.getPixels", left += clip.getTranslateX(), top += clip.getTranslateY(), width, height);
        RasterBuffer srcBuffer = this.buffer;
        boolean srcOpaque = srcBuffer.isOpaque();
        int[] srcPixels = srcBuffer.getPixels();
        int srcOffset = srcBuffer.getOffset();
        int srcScanln = srcBuffer.getScanlength();
        switch (format) {
            case 888: {
                int i = offset;
                int di = scanlength - width;
                int j = srcOffset + left + top * srcScanln;
                int dj = srcScanln - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        int p = srcPixels[j];
                        pixels[i] = p & 0xFFFFFF;
                        ++i;
                        ++j;
                    }
                    i += di;
                    j += dj;
                }
                break;
            }
            case 8888: {
                int i = offset;
                int di = scanlength - width;
                int j = srcOffset + left + top * srcScanln;
                int dj = srcScanln - width;
                int cy = height;
                while (cy-- > 0) {
                    int cx = width;
                    while (cx-- > 0) {
                        int p = srcPixels[j];
                        pixels[i] = srcOpaque ? p | 0xFF000000 : p;
                        ++i;
                        ++j;
                    }
                    i += di;
                    j += dj;
                }
                break;
            }
        }
    }

    public int getAlphaComponent() {
        return this.paint.getAlphaComponent();
    }

    public int getNativePixelFormat() {
        return this.buffer.isOpaque() ? 888 : 8888;
    }

    public void copyArea(int left, int top, int width, int height, int x, int y, int anchor) {
        TextPaint clip = this.paint;
        this.check("Graphics.copyArea", left += clip.getTranslateX(), top += clip.getTranslateY(), width, height);
        switch (anchor) {
            case 0: 
            case 20: {
                break;
            }
            case 17: {
                x -= width >> 1;
                break;
            }
            case 24: {
                x -= width;
                break;
            }
            case 6: {
                y -= height >> 1;
                break;
            }
            case 3: {
                x -= width >> 1;
                y -= height >> 1;
                break;
            }
            case 10: {
                x -= width;
                y -= height >> 1;
                break;
            }
            case 36: {
                y -= height;
                break;
            }
            case 33: {
                x -= width >> 1;
                y -= height;
                break;
            }
            case 40: {
                x -= width;
                y -= height;
                break;
            }
            default: {
                throw new IllegalArgumentException("Graphics.copyArea: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 anchor \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        this.canvas.copyPixels(RasterBuffer.create((RasterBuffer)this.buffer, (int)left, (int)top, (int)width, (int)height), 0, x, y, width, height, (Clip)clip);
    }

    public void drawElement(int type, int subtype, int state, int left, int top, int width, int height) {
        this.canvas.drawGUIElement(type, subtype, state, left, top, width, height, (Clip)this.paint);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (x1 == x2 && y1 == y2) {
            this.canvas.drawPixel(x1, y1, (Paint)this.paint);
            return;
        }
        this.canvas.drawCustom((Drawable)new Line(x1, y1, x2, y2), 0, 0, (Paint)this.paint);
    }

    public void drawArc(int left, int top, int width, int height, int startAngle, int arcAngle) {
        if (width < 0 || height < 0) {
            return;
        }
        if (startAngle < 0) {
            startAngle += 360 * (startAngle / -360 + 1);
        }
        startAngle %= 360;
        if (arcAngle > 360) {
            arcAngle = 360;
        }
        if (arcAngle < -360) {
            arcAngle = -360;
        }
        if (arcAngle < 0) {
            startAngle = (startAngle + arcAngle + 360) % 360;
            arcAngle = -arcAngle;
        }
        int angle = startAngle;
        int stepAngle = width < height ? height + 1 : width + 1;
        stepAngle = stepAngle >= 180 || stepAngle == Integer.MIN_VALUE ? 1 : 180 / stepAngle;
        int length = arcAngle / stepAngle + 1;
        long xnSize = width;
        long ynSize = height;
        long xmSize = xnSize << 14;
        long ymSize = ynSize << 14;
        int yStart = length + 1;
        int[] coords = new int[yStart << 1];
        int x = 0;
        int y = yStart;
        while (x < length) {
            coords[x] = (int)(xmSize + xnSize * (long)XTABLE[angle % 360] + 16384L >> 15);
            coords[y] = (int)(ymSize + ynSize * (long)YTABLE[angle % 360] + 16384L >> 15);
            angle += stepAngle;
            ++x;
            ++y;
        }
        if (angle - stepAngle < (angle = startAngle + arcAngle)) {
            coords[length] = (int)(xmSize + xnSize * (long)XTABLE[angle % 360] + 16384L >> 15);
            coords[length++ + yStart] = (int)(ymSize + ynSize * (long)YTABLE[angle % 360] + 16384L >> 15);
        }
        this.canvas.drawCustom((Drawable)new OpenedPolygon(coords, 0, coords, yStart, length), left, top, (Paint)this.paint);
    }

    public void drawRect(int left, int top, int width, int height) {
        if (width >= 0 && height >= 0) {
            this.canvas.drawCustom((Drawable)new OutlinedRectangle(width, height), left, top, (Paint)this.paint);
        }
    }

    public void drawRoundRect(int left, int top, int width, int height, int arcWidth, int arcHeight) {
        if (width >= 0 && height >= 0) {
            this.canvas.drawCustom((Drawable)new OutlinedRoundRect(width, height, arcWidth, arcHeight), left, top, (Paint)this.paint);
        }
    }

    public void drawRGB(int[] pixels, int offset, int scanlength, int left, int top, int width, int height, boolean alpha) {
        int pixelsLength;
        int pixelsOffset;
        if (scanlength >= 0) {
            pixelsOffset = offset;
            pixelsLength = width + (height - 1) * scanlength;
        } else {
            pixelsOffset = offset + (height - 1) * scanlength;
            pixelsLength = width + offset - pixelsOffset;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        if (pixels == null) {
            throw new NullPointerException("Graphics.drawRGB: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 pixels \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound((String)"Graphics.drawRGB", (int)pixels.length, (int)pixelsOffset, (int)pixelsLength);
        RasterBuffer buffer = RasterBuffer.create((int[])pixels, (int)offset, (int)scanlength, (int)width, (int)height, (!alpha ? 1 : 0) != 0);
        this.canvas.drawPixels(buffer, 0, left, top, width, height, (Clip)this.paint);
    }

    public void drawImage(Image image, int x, int y, int anchor) {
        if (image == null) {
            throw new NullPointerException("Graphics.drawImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 image \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int width = image.width;
        int height = image.height;
        switch (anchor) {
            case 0: 
            case 20: {
                break;
            }
            case 17: {
                x -= width >> 1;
                break;
            }
            case 24: {
                x -= width;
                break;
            }
            case 6: {
                y -= height >> 1;
                break;
            }
            case 3: {
                x -= width >> 1;
                y -= height >> 1;
                break;
            }
            case 10: {
                x -= width;
                y -= height >> 1;
                break;
            }
            case 36: {
                y -= height;
                break;
            }
            case 33: {
                x -= width >> 1;
                y -= height;
                break;
            }
            case 40: {
                x -= width;
                y -= height;
                break;
            }
            default: {
                throw new IllegalArgumentException("Graphics.drawImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 anchor \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        this.canvas.drawPixels(image.buffer, 0, x, y, width, height, (Clip)this.paint);
    }

    public void drawStretch(Image image, int x, int y, int width, int height, int anchor) {
        if (image == null) {
            throw new NullPointerException("Graphics.drawStretch: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 image \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        switch (anchor) {
            case 0: 
            case 20: {
                break;
            }
            case 17: {
                x -= width >> 1;
                break;
            }
            case 24: {
                x -= width;
                break;
            }
            case 6: {
                y -= height >> 1;
                break;
            }
            case 3: {
                x -= width >> 1;
                y -= height >> 1;
                break;
            }
            case 10: {
                x -= width;
                y -= height >> 1;
                break;
            }
            case 36: {
                y -= height;
                break;
            }
            case 33: {
                x -= width >> 1;
                y -= height;
                break;
            }
            case 40: {
                x -= width;
                y -= height;
                break;
            }
            default: {
                throw new IllegalArgumentException("Graphics.drawStretch: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 anchor \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        this.canvas.drawPixels(image.buffer, 0, x, y, width, height, (Clip)this.paint);
    }

    public void drawRegion(Image image, int left, int top, int width, int height, int transform, int x, int y, int anchor) {
        int h;
        int w;
        if (image == null) {
            throw new NullPointerException("Graphics.drawRegion: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 image \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = left + width;
        int len = image.width;
        if (lim > len || lim < left || left > len || left < 0 || (lim = top + height) > (len = image.height) || lim < top || top > len || top < 0) {
            throw new IllegalArgumentException("Graphics.drawRegion: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
        }
        if ((transform = Graphics.spriteToRasterCanvasTransform(transform)) < 0) {
            throw new IllegalArgumentException("Graphics.drawRegion: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if ((transform & 1) != 0) {
            w = height;
            h = width;
        } else {
            w = width;
            h = height;
        }
        switch (anchor) {
            case 0: 
            case 20: {
                break;
            }
            case 17: {
                x -= w >> 1;
                break;
            }
            case 24: {
                x -= w;
                break;
            }
            case 6: {
                y -= h >> 1;
                break;
            }
            case 3: {
                x -= w >> 1;
                y -= h >> 1;
                break;
            }
            case 10: {
                x -= w;
                y -= h >> 1;
                break;
            }
            case 36: {
                y -= h;
                break;
            }
            case 33: {
                x -= w >> 1;
                y -= h;
                break;
            }
            case 40: {
                x -= w;
                y -= h;
                break;
            }
            default: {
                throw new IllegalArgumentException("Graphics.drawRegion: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 anchor \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        if (w > 0 && h > 0) {
            this.canvas.drawPixels(image.buffer, left, top, width, height, transform, x, y, w, h, (Clip)this.paint);
        }
    }

    public void drawChar(char character, int x, int y, int anchor) {
        TextPaint p = this.paint;
        SystemFont font = p.getFont();
        int width = font.characterWidth((int)character);
        switch (anchor) {
            case 68: {
                break;
            }
            case 65: {
                x -= width >> 1;
                break;
            }
            case 72: {
                x -= width;
                break;
            }
            case 0: 
            case 20: {
                y += font.getBaselinePosition();
                break;
            }
            case 17: {
                x -= width >> 1;
                y += font.getBaselinePosition();
                break;
            }
            case 24: {
                x -= width;
                y += font.getBaselinePosition();
                break;
            }
            case 36: {
                y -= font.getBaselineHeight();
                break;
            }
            case 33: {
                x -= width >> 1;
                y -= font.getBaselineHeight();
                break;
            }
            case 40: {
                x -= width;
                y -= font.getBaselineHeight();
                break;
            }
            default: {
                throw new IllegalArgumentException("Graphics.drawChar: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 anchor \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        this.canvas.drawCharacter((int)character, x, y, (Paint)p);
    }

    public void drawChars(char[] src, int offset, int length, int x, int y, int anchor) {
        TextPaint p = this.paint;
        SystemFont font = p.getFont();
        int width = font.charactersWidth(src, offset, length);
        switch (anchor) {
            case 68: {
                break;
            }
            case 65: {
                x -= width >> 1;
                break;
            }
            case 72: {
                x -= width;
                break;
            }
            case 0: 
            case 20: {
                y += font.getBaselinePosition();
                break;
            }
            case 17: {
                x -= width >> 1;
                y += font.getBaselinePosition();
                break;
            }
            case 24: {
                x -= width;
                y += font.getBaselinePosition();
                break;
            }
            case 36: {
                y -= font.getBaselineHeight();
                break;
            }
            case 33: {
                x -= width >> 1;
                y -= font.getBaselineHeight();
                break;
            }
            case 40: {
                x -= width;
                y -= font.getBaselineHeight();
                break;
            }
            default: {
                throw new IllegalArgumentException("Graphics.drawChars: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 anchor \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        this.canvas.drawCharacters(src, offset, length, x, y, (Paint)p);
    }

    public void drawString(String string, int x, int y, int anchor) {
        TextPaint p = this.paint;
        SystemFont font = p.getFont();
        int width = font.stringWidth(string);
        switch (anchor) {
            case 68: {
                break;
            }
            case 65: {
                x -= width >> 1;
                break;
            }
            case 72: {
                x -= width;
                break;
            }
            case 0: 
            case 20: {
                y += font.getBaselinePosition();
                break;
            }
            case 17: {
                x -= width >> 1;
                y += font.getBaselinePosition();
                break;
            }
            case 24: {
                x -= width;
                y += font.getBaselinePosition();
                break;
            }
            case 36: {
                y -= font.getBaselineHeight();
                break;
            }
            case 33: {
                x -= width >> 1;
                y -= font.getBaselineHeight();
                break;
            }
            case 40: {
                x -= width;
                y -= font.getBaselineHeight();
                break;
            }
            default: {
                throw new IllegalArgumentException("Graphics.drawString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 anchor \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        this.canvas.drawString(string, x, y, (Paint)p);
    }

    public void drawSubstring(String string, int offset, int length, int x, int y, int anchor) {
        TextPaint p = this.paint;
        SystemFont font = p.getFont();
        int width = font.substringWidth(string, offset, length);
        switch (anchor) {
            case 68: {
                break;
            }
            case 65: {
                x -= width >> 1;
                break;
            }
            case 72: {
                x -= width;
                break;
            }
            case 0: 
            case 20: {
                y += font.getBaselinePosition();
                break;
            }
            case 17: {
                x -= width >> 1;
                y += font.getBaselinePosition();
                break;
            }
            case 24: {
                x -= width;
                y += font.getBaselinePosition();
                break;
            }
            case 36: {
                y -= font.getBaselineHeight();
                break;
            }
            case 33: {
                x -= width >> 1;
                y -= font.getBaselineHeight();
                break;
            }
            case 40: {
                x -= width;
                y -= font.getBaselineHeight();
                break;
            }
            default: {
                throw new IllegalArgumentException("Graphics.drawSubstring: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 anchor \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        this.canvas.drawSubstring(string, offset, length, x, y, (Paint)p);
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.canvas.drawCustom((Drawable)new FilledTriangle(x1, y1, x2, y2, x3, y3), 0, 0, (Paint)this.paint);
    }

    public void fillArc(int left, int top, int width, int height, int startAngle, int arcAngle) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (startAngle < 0) {
            startAngle += 360 * (startAngle / -360 + 1);
        }
        startAngle %= 360;
        if (arcAngle > 360) {
            arcAngle = 360;
        }
        if (arcAngle < -360) {
            arcAngle = -360;
        }
        if (arcAngle < 0) {
            startAngle = (startAngle + arcAngle + 360) % 360;
            arcAngle = -arcAngle;
        }
        int stepAngle = width < height ? height : width;
        stepAngle = stepAngle >= 180 ? 1 : 180 / stepAngle;
        int length = arcAngle / stepAngle + 2;
        long xnSize = width;
        long ynSize = height;
        long xmSize = xnSize << 14;
        long ymSize = ynSize << 14;
        int[] coords = new int[length << 1];
        int a = startAngle;
        int x = 0;
        int yStart = length--;
        int y = yStart;
        while (x < length) {
            coords[x] = (int)(xmSize + xnSize * (long)XTABLE[a] + 16384L >> 15);
            coords[y] = (int)(ymSize + ynSize * (long)YTABLE[a] + 16384L >> 15);
            a = (a + stepAngle) % 360;
            ++x;
            ++y;
        }
        if (arcAngle < 360) {
            coords[length] = (int)(xmSize + 16384L >> 15);
            coords[length++ + yStart] = (int)(ymSize + 16384L >> 15);
        }
        this.canvas.drawCustom((Drawable)new FilledPolygon(coords, 0, coords, yStart, length), left, top, (Paint)this.paint);
    }

    public void fillRect(int left, int top, int width, int height) {
        if (width > 0 && height > 0) {
            this.canvas.fillRectangle(left, top, width, height, (Paint)this.paint);
        }
    }

    public void fillRoundRect(int left, int top, int width, int height, int arcWidth, int arcHeight) {
        if (width > 0 && height > 0) {
            this.canvas.drawCustom((Drawable)new FilledRoundRect(width, height, arcWidth, arcHeight), left, top, (Paint)this.paint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate(int deltaX, int deltaY) {
        TextPaint c;
        TextPaint textPaint = c = this.paint;
        synchronized (c) {
            c.translate(deltaX, deltaY);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clipRect(int left, int top, int width, int height) {
        TextPaint c;
        TextPaint textPaint = c = this.paint;
        synchronized (c) {
            c.clipRect(left, top, width, height);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClip(int left, int top, int width, int height) {
        TextPaint c;
        TextPaint textPaint = c = this.paint;
        synchronized (c) {
            c.setClip(left, top, width, height);
            this.bound((Clip)c);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public void setColor(int colorRGB) {
        this.paint.setColor(colorRGB | 0xFF000000);
    }

    public void setColor(int red, int green, int blue) {
        if ((red & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("Graphics.setColor: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 red \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if ((green & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("Graphics.setColor: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 green \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if ((blue & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("Graphics.setColor: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 blue \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        this.paint.setColor(red << 16 | green << 8 | blue | 0xFF000000);
    }

    public void setGrayScale(int gray) {
        if ((gray & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("Graphics.setGrayScale: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 gray \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        this.paint.setColor(gray << 16 | gray << 8 | gray | 0xFF000000);
    }

    public void setStrokeStyle(int stroke) {
        if (stroke < 0 || stroke > 1) {
            throw new IllegalArgumentException("Graphics.setStrokeStyle: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 stroke \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        this.stroke = stroke;
    }

    public void setFont(Font font) {
        if (font == null) {
            font = Font.getDefaultFont();
        }
        this.font = font;
        this.paint.setFont(font.getSystemFont(), font.isUnderlined(), false);
    }

    public int getTranslateX() {
        return this.paint.getTranslateX();
    }

    public int getTranslateY() {
        return this.paint.getTranslateY();
    }

    public int getClipX() {
        return this.paint.getClipLeft();
    }

    public int getClipY() {
        return this.paint.getClipTop();
    }

    public int getClipWidth() {
        return this.paint.getClipWidth();
    }

    public int getClipHeight() {
        return this.paint.getClipHeight();
    }

    public int getColor() {
        return this.paint.getColor() & 0xFFFFFF;
    }

    public int getDisplayColor(int colorRGB) {
        return colorRGB & 0xFFFFFF;
    }

    public int getRedComponent() {
        return this.paint.getRedComponent();
    }

    public int getGreenComponent() {
        return this.paint.getGreenComponent();
    }

    public int getBlueComponent() {
        return this.paint.getBlueComponent();
    }

    public int getGrayScale() {
        int c = this.paint.getColor();
        return 76 * (c >> 16 & 0xFF) + 152 * (c >> 8 & 0xFF) + 28 * (c & 0xFF) >> 8;
    }

    public int getStrokeStyle() {
        return this.stroke;
    }

    public Font getFont() {
        return this.font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Font f;
        TextPaint p = this.paint;
        this.stroke = 0;
        this.font = f = Font.getDefaultFont();
        p.setFont(f.getSystemFont(), f.isUnderlined(), false);
        p.setColor(-16777216);
        TextPaint textPaint = p;
        synchronized (textPaint) {
            p.translateReset();
            p.setClip(0, 0, this.width, this.height);
        }
    }

    void bound(Clip clip) {
        clip.clipRect(-clip.getTranslateX(), -clip.getTranslateY(), this.width, this.height);
    }

    void check(String method, int left, int top, int width, int height) throws IllegalArgumentException {
        int lim = left + width;
        int len = this.width;
        if (lim > len || lim < left || left > len || left < 0 || (lim = top + height) > (len = this.height) || lim < top || top > len || top < 0) {
            throw new IllegalArgumentException(method.concat(": \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u043a\u0430\u043d\u0432\u044b."));
        }
    }

    private static class ClosedPolygon
    extends Polygon {
        public ClosedPolygon(int[] xCoords, int xOffset, int[] yCoords, int yOffset, int length) {
            super(xCoords, xOffset, yCoords, yOffset, length);
        }

        public void draw(PrimitiveRender render) {
            int length = this.length;
            int xStart = this.xOffset;
            int yStart = this.yOffset;
            int[] cx = this.xCoords;
            int[] cy = this.yCoords;
            int x1 = cx[xStart];
            int y1 = cy[yStart];
            int i = length;
            while (i-- > 0) {
                int x2 = x1;
                int y2 = y1;
                x1 = cx[xStart + i];
                y1 = cy[yStart + i];
                Graphics.drawLine(render, x1, y1, x2, y2, true);
            }
        }
    }

    private static class FilledPolygon
    extends Polygon {
        public FilledPolygon(int[] xCoords, int xOffset, int[] yCoords, int yOffset, int length) {
            super(xCoords, xOffset, yCoords, yOffset, length);
        }

        public void draw(PrimitiveRender render) {
            int ymax;
            int length = this.length;
            int xStart = length & 0xFFFFFFFE;
            int yStart = xStart + length;
            int[] coords = new int[yStart + length];
            Array.copy((int[])this.xCoords, (int)this.xOffset, (int[])coords, (int)xStart, (int)length);
            Array.copy((int[])this.yCoords, (int)this.yOffset, (int[])coords, (int)yStart, (int)length);
            int ymin = ymax = coords[yStart];
            int i = length;
            while (i-- > 1) {
                int yi = coords[yStart + i];
                if (ymin > yi) {
                    ymin = yi;
                }
                if (ymax >= yi) continue;
                ymax = yi;
            }
            int y = ymin;
            while (y < ymax) {
                int ixsize = 0;
                int x1 = coords[xStart];
                int y1 = coords[yStart];
                int i2 = length;
                block6: while (i2-- > 0) {
                    int x2 = x1;
                    int y2 = y1;
                    x1 = coords[xStart + i2];
                    y1 = coords[yStart + i2];
                    if (y < (y1 <= y2 ? y1 : y2) || y >= (y1 >= y2 ? y1 : y2)) continue;
                    int x = x1 + (x2 - x1) * (y - y1) / (y2 - y1);
                    block0 : switch (ixsize) {
                        default: {
                            if (x >= coords[ixsize - 1]) {
                                coords[ixsize++] = x;
                                break;
                            }
                            int j = 0;
                            while (j < ixsize) {
                                if (x <= coords[j]) {
                                    Array.copy((int[])coords, (int)j, (int[])coords, (int)(j + 1), (int)(ixsize++ - j));
                                    coords[j] = x;
                                    break block0;
                                }
                                ++j;
                            }
                            continue block6;
                        }
                        case 1: {
                            int x0 = coords[0];
                            if (x < x0) {
                                coords[ixsize++] = x0;
                                coords[0] = x;
                                break;
                            }
                        }
                        case 0: {
                            coords[ixsize++] = x;
                        }
                    }
                }
                int j = ixsize;
                while ((j -= 2) >= 0) {
                    x1 = coords[j];
                    int x2 = coords[j + 1];
                    if (x1 >= x2) continue;
                    render.drawHorizontalLine(x1, y, x2 - x1);
                }
                ++y;
            }
        }
    }

    private static class FilledRoundRect
    extends RoundRect {
        public FilledRoundRect(int width, int height, int arcWidth, int arcHeight) {
            super(width, height, arcWidth, arcHeight);
        }

        public strictfp void draw(PrimitiveRender render) {
            int w = this.width;
            int h = this.height;
            int aw = this.arcWidth;
            int ah = this.arcHeight;
            if (aw <= 0 || ah <= 0) {
                render.fillRectangle(0, 0, w, h);
                return;
            }
            render.fillRectangle(0, ah, w, --h - (ah << 1) + 1);
            double ratio = (double)aw / (double)ah;
            long square = (long)ah * (long)ah;
            int y = ah;
            int i = 0;
            while (i < ah) {
                int j = (int)Math.round((double)aw - ratio * Math.sqrt(square - (long)y * (long)y)) + (i != 0 ? 1 : 0);
                int tmp1 = w - (j << 1);
                render.drawHorizontalLine(j, i, tmp1);
                render.drawHorizontalLine(j, h, tmp1);
                --h;
                --y;
                ++i;
            }
        }
    }

    private static class FilledTriangle
    extends Triangle {
        public FilledTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
            super(x1, y1, x2, y2, x3, y3);
        }

        /*
         * Unable to fully structure code
         */
        public void draw(PrimitiveRender render) {
            x1 = this.x1;
            x2 = this.x2;
            x3 = this.x3;
            y1 = this.y1;
            y2 = this.y2;
            y3 = this.y3;
            if (y1 > y3) {
                tmp = y1;
                y1 = y3;
                y3 = tmp;
                tmp = x1;
                x1 = x3;
                x3 = tmp;
            }
            if (y1 > y2) {
                tmp = y1;
                y1 = y2;
                y2 = tmp;
                tmp = x1;
                x1 = x2;
                x2 = tmp;
            }
            if (y2 > y3) {
                tmp = y2;
                y2 = y3;
                y3 = tmp;
                tmp = x2;
                x2 = x3;
                x3 = tmp;
            }
            ix = x1;
            ixerr = 0;
            iyerr = 0;
            idx = x2 - x1;
            iincx = idx == 0 ? 0 : (idx < 0 ? -1 : 1);
            idy = y2 - y1;
            iincy = idy == 0 ? 0 : (idy < 0 ? -1 : 1);
            idx = idx < 0 ? -idx : idx;
            idy = idy < 0 ? -idy : idy;
            id = idx >= idy ? idx : idy;
            jx = x1;
            jxerr = 0;
            jyerr = 0;
            jdx = x3 - x1;
            jincx = jdx == 0 ? 0 : (jdx < 0 ? -1 : 1);
            jdy = y3 - y1;
            jincy = jdy == 0 ? 0 : (jdy < 0 ? -1 : 1);
            jdx = jdx < 0 ? -jdx : jdx;
            jdy = jdy < 0 ? -jdy : jdy;
            jd = jdx >= jdy ? jdx : jdy;
            y = y1;
            block0: while (true) {
                if (y == y2) {
                    ix = x2;
                    ixerr = 0;
                    iyerr = 0;
                    idx = x3 - x2;
                    iincx = idx == 0 ? 0 : (idx < 0 ? -1 : 1);
                    idy = y3 - y2;
                    iincy = idy == 0 ? 0 : (idy < 0 ? -1 : 1);
                    idx = idx < 0 ? -idx : idx;
                    idy = idy < 0 ? -idy : idy;
                    v0 = id = idx >= idy ? idx : idy;
                }
                if (ix <= jx) {
                    render.drawHorizontalLine(ix, y, jx - ix + 1);
                } else {
                    render.drawHorizontalLine(jx, y, ix - jx + 1);
                }
                if (++y <= y3) ** GOTO lbl74
                break;
lbl-1000:
                // 1 sources

                {
                    iyerr += idy;
                    if ((ixerr += idx) > id) {
                        ixerr -= id;
                        ix += iincx;
                    }
                    if (iyerr <= id) continue;
                    iyerr -= id;
                    break;
lbl74:
                    // 2 sources

                    ** while (iincy > 0)
                }
lbl75:
                // 2 sources

                do {
                    if (jincy <= 0) continue block0;
                    jyerr += jdy;
                    if ((jxerr += jdx) <= jd) continue;
                    jxerr -= jd;
                    jx += jincx;
                } while (jyerr <= jd);
                jyerr -= jd;
            }
        }
    }

    private static class Line
    implements Drawable {
        public final int x1;
        public final int y1;
        public final int x2;
        public final int y2;

        public Line(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public void draw(PrimitiveRender render) {
            Graphics.drawLine(render, this.x1, this.y1, this.x2, this.y2, true);
        }
    }

    private static class OpenedPolygon
    extends Polygon {
        public OpenedPolygon(int[] xCoords, int xOffset, int[] yCoords, int yOffset, int length) {
            super(xCoords, xOffset, yCoords, yOffset, length);
        }

        public void draw(PrimitiveRender render) {
            int length = this.length;
            int xStart = this.xOffset;
            int yStart = this.yOffset;
            int[] cx = this.xCoords;
            int[] cy = this.yCoords;
            int x2 = cx[xStart];
            int y2 = cy[yStart];
            int i = 1;
            while (i < length) {
                int x1 = x2;
                int y1 = y2;
                x2 = cx[xStart + i];
                y2 = cy[yStart + i];
                Graphics.drawLine(render, x1, y1, x2, y2, false);
                ++i;
            }
        }
    }

    private static class OutlinedRectangle
    extends Rectangle {
        public OutlinedRectangle(int width, int height) {
            super(width, height);
        }

        public void draw(PrimitiveRender render) {
            int w = this.width;
            int h = this.height;
            render.drawHorizontalLine(0, 0, w + 1);
            if (h > 0) {
                render.drawHorizontalLine(0, h, w + 1);
            }
            if (h > 1) {
                render.drawVerticalLine(0, 1, h - 1);
                if (w > 0) {
                    render.drawVerticalLine(w, 1, h - 1);
                }
            }
        }
    }

    private static class OutlinedRoundRect
    extends RoundRect {
        public OutlinedRoundRect(int width, int height, int arcWidth, int arcHeight) {
            super(width, height, arcWidth, arcHeight);
        }

        public strictfp void draw(PrimitiveRender render) {
            int w = this.width;
            int h = this.height;
            int aw = this.arcWidth;
            int ah = this.arcHeight;
            if (aw <= 0 || ah <= 0) {
                render.drawHorizontalLine(0, 0, w + 1);
                if (h > 0) {
                    render.drawHorizontalLine(0, h, w + 1);
                }
                if (h > 1) {
                    render.drawVerticalLine(0, 1, h - 1);
                    if (w > 0) {
                        render.drawVerticalLine(w, 1, h - 1);
                    }
                }
                return;
            }
            int tmp1 = w - (aw << 1) + 1;
            int tmp2 = h - (ah << 1) + 1;
            render.drawHorizontalLine(aw, 0, tmp1);
            render.drawHorizontalLine(aw, h, tmp1);
            render.drawVerticalLine(0, ah, tmp2);
            render.drawVerticalLine(w, ah, tmp2);
            double ratio = (double)aw / (double)ah;
            long square = (long)ah * (long)ah;
            int x = aw;
            int y = ah;
            int i = 1;
            while (i < ah) {
                int j;
                tmp1 = x == (j = (int)Math.intPart((double)((double)aw - ratio * Math.sqrt(square - (long)(--y) * (long)y))) + 1) ? 1 : x - j;
                int k = h - i;
                int l = w - j - tmp1 + 1;
                render.drawHorizontalLine(j, i, tmp1);
                render.drawHorizontalLine(j, k, tmp1);
                render.drawHorizontalLine(l, i, tmp1);
                render.drawHorizontalLine(l, k, tmp1);
                x = j;
                ++i;
            }
        }
    }

    private static class OutlinedTriangle
    extends Triangle {
        public OutlinedTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
            super(x1, y1, x2, y2, x3, y3);
        }

        public void draw(PrimitiveRender render) {
            int x1 = this.x1;
            int y1 = this.y1;
            int x2 = this.x2;
            int y2 = this.y2;
            int x3 = this.x3;
            int y3 = this.y3;
            Graphics.drawLine(render, x1, y1, x2, y2, true);
            Graphics.drawLine(render, x2, y2, x3, y3, true);
            Graphics.drawLine(render, x3, y3, x1, y1, true);
        }
    }

    private static abstract class Polygon
    implements Drawable {
        public final int length;
        public final int xOffset;
        public final int yOffset;
        public final int[] xCoords;
        public final int[] yCoords;

        public Polygon(int[] xCoords, int xOffset, int[] yCoords, int yOffset, int length) {
            this.length = length;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.xCoords = xCoords;
            this.yCoords = yCoords;
        }

        public abstract void draw(PrimitiveRender var1);
    }

    private static abstract class Rectangle
    implements Drawable {
        public final int width;
        public final int height;

        public Rectangle(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public abstract void draw(PrimitiveRender var1);
    }

    private static abstract class RoundRect
    extends Rectangle {
        public final int arcWidth;
        public final int arcHeight;

        public RoundRect(int width, int height, int arcWidth, int arcHeight) {
            super(width, height);
            int n = arcWidth < 0 ? 0 : (this.arcWidth = arcWidth > width ? (width >>= 1) : arcWidth);
            this.arcHeight = arcHeight < 0 ? 0 : (arcHeight > height ? (height >>= 1) : arcHeight);
        }

        public abstract void draw(PrimitiveRender var1);
    }

    private static abstract class Triangle
    extends Line {
        public final int x3;
        public final int y3;

        public Triangle(int x1, int y1, int x2, int y2, int x3, int y3) {
            super(x1, y1, x2, y2);
            this.x3 = x3;
            this.y3 = y3;
        }

        public abstract void draw(PrimitiveRender var1);
    }
}

