/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.CustomScrollBar;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.ScreenGraphics;
import javax.microedition.lcdui.ScrollBar;
import javax.microedition.lcdui.Ticker;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.microedition.lcdui.ScreenScrollBarStyle;
import malik.emulator.microedition.lcdui.ScrollBarStyle;

public abstract class ScrollingScreen
extends Screen {
    static final byte SCROLL_NONE = 0;
    static final byte SCROLL_HORZ = 16;
    static final byte SCROLL_VERT = 32;
    static final byte SCROLL_BOTH = 48;
    private static final int WHEEL_SCROLL = 16;
    private boolean shift;
    private int focused;
    private final int size;
    private final int[] rect;
    final CustomScrollBar vert;
    final CustomScrollBar horz;
    private final ScrollBarStyle style;

    ScrollingScreen(String title, Ticker ticker, boolean fullScreen, byte scrollbars, ScrollBarStyle style) {
        this(title, ticker, fullScreen, 0, 0, scrollbars, style);
    }

    ScrollingScreen(String title, Ticker ticker, boolean fullScreen, int horizontalRange, int verticalRange, byte scrollbars, ScrollBarStyle style) {
        super(title, ticker, fullScreen);
        Object monitor = new Object();
        if (style == null) {
            style = new ScreenScrollBarStyle();
        }
        this.size = style.size();
        this.rect = new int[4];
        this.vert = new VertScrollBar((scrollbars & 0x20) != 0, verticalRange, monitor);
        this.horz = new HorzScrollBar((scrollbars & 0x10) != 0, horizontalRange, monitor);
        this.style = style;
    }

    public final void setFullScreenMode(boolean fullScreen) {
        super.setFullScreenMode(fullScreen);
    }

    public final boolean isFullScreenMode() {
        return super.isFullScreenMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scroll(int deltaHorizontal, int deltaVertical) {
        boolean exec = false;
        int hpage = this.getApplicationWidth();
        int vpage = this.getApplicationHeight();
        CustomScrollBar horz = this.horz;
        CustomScrollBar vert = this.vert;
        Object object = horz.monitor;
        synchronized (object) {
            int oldPosition = horz.position;
            int newPosition = deltaHorizontal + oldPosition;
            int maximum = horz.range - hpage;
            if (newPosition > maximum) {
                newPosition = maximum;
            }
            if (newPosition < 0) {
                newPosition = 0;
            }
            if (oldPosition != newPosition) {
                horz.position = newPosition;
                exec = true;
            }
            if ((newPosition = deltaVertical + (oldPosition = vert.position)) > (maximum = vert.range - vpage)) {
                newPosition = maximum;
            }
            if (newPosition < 0) {
                newPosition = 0;
            }
            if (oldPosition != newPosition) {
                vert.position = newPosition;
                exec = true;
            }
        }
        if (exec) {
            this.requestPaint((byte)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scrollTo(int positionHorizontal, int positionVertical) {
        boolean exec = false;
        int hpage = this.getApplicationWidth();
        int vpage = this.getApplicationHeight();
        CustomScrollBar horz = this.horz;
        CustomScrollBar vert = this.vert;
        Object object = horz.monitor;
        synchronized (object) {
            int oldPosition = horz.position;
            int newPosition = positionHorizontal;
            int maximum = horz.range - hpage;
            if (newPosition > maximum) {
                newPosition = maximum;
            }
            if (newPosition < 0) {
                newPosition = 0;
            }
            if (oldPosition != newPosition) {
                horz.position = newPosition;
                exec = true;
            }
            oldPosition = vert.position;
            newPosition = positionVertical;
            maximum = vert.range - vpage;
            if (newPosition > maximum) {
                newPosition = maximum;
            }
            if (newPosition < 0) {
                newPosition = 0;
            }
            if (oldPosition != newPosition) {
                vert.position = newPosition;
                exec = true;
            }
        }
        if (exec) {
            this.requestPaint((byte)2);
        }
    }

    public final ScrollBar getVerticalScrollBar() {
        return this.vert;
    }

    public final ScrollBar getHorizontalScrollBar() {
        return this.horz;
    }

    abstract void paint(ScreenGraphics var1);

    void paintClient(ScreenGraphics render, int width, int height, int clipLeft, int clipTop, int clipWidth, int clipHeight, Image clipBuffer) {
        int size = this.size;
        int left = super.getMarginLeft();
        int top = super.getMarginTop();
        int right = super.getMarginRight();
        int bottom = super.getMarginBottom();
        int tx = left + render.getTranslateX();
        int ty = top + render.getTranslateY();
        CustomScrollBar horz = this.horz;
        CustomScrollBar vert = this.vert;
        ScrollBarStyle style = this.style;
        boolean hvisible = horz.visibility;
        boolean vvisible = vert.visibility;
        int hpos = horz.position;
        int vpos = vert.position;
        width -= left + right + (vvisible ? size : 0);
        height -= top + bottom + (hvisible ? size : 0);
        if (hvisible) {
            render.reset();
            render.translate(tx, ty + height);
            style.horizontalScrollBarPaintEvent(horz, render, width, size);
        }
        if (vvisible) {
            render.reset();
            render.translate(tx + width, ty);
            style.verticalScrollBarPaintEvent(vert, render, size, height);
            if (hvisible) {
                render.reset();
                render.translate(tx + width, ty + height);
                style.sizeGripPaintEvent(false, render, size, size);
            }
        }
        render.reset();
        render.restricts(tx, ty, width, height);
        render.setStartPoint(tx - hpos, ty - vpos);
        render.setClip(tx, ty, width, height);
        render.clipRect(tx + clipLeft, ty + clipTop, clipWidth, clipHeight);
        render.translate(tx - hpos, ty - vpos);
        this.paint(render);
    }

    boolean onKeyboardEvent(KeyboardEvent event) {
        if (super.onKeyboardEvent(event)) {
            return true;
        }
        this.shift = event.isKeyPressed(16) || event.isKeyPressed(160) || event.isKeyPressed(161);
        this.onClientKeyboardEvent(event);
        return true;
    }

    boolean onPointerEvent(PointerEvent event) {
        if (super.onPointerEvent(event)) {
            return true;
        }
        switch (event.getAction()) {
            case 10: {
                int b = event.getButton();
                boolean down = b == 15;
                if (down || b == 14) {
                    (this.shift ? this.horz : this.vert).scroll(down ? 16 : -16);
                    return true;
                }
                this.focused = this.getFocusedElement(event.getX(), event.getY(), b);
                return this.handlePointerEvent(this.focused, event);
            }
            case 14: {
                int b = event.getButton();
                boolean down = b == 15;
                if (down || b == 14) {
                    (this.shift ? this.horz : this.vert).scroll(down ? 16 : -16);
                    return true;
                }
            }
            case 9: {
                return this.handlePointerEvent(this.focused, event);
            }
            case 15: {
                int b = event.getButton();
                return b == 15 || b == 14 || this.handlePointerEvent(this.focused, event);
            }
            case 11: {
                int f = this.focused;
                this.focused = 0;
                int b = event.getButton();
                return b == 15 || b == 14 || this.handlePointerEvent(f, event);
            }
        }
        return false;
    }

    Displayable.Helper createHelper() {
        return new Helper();
    }

    void onClientScroll(int positionHorizontal, int positionVertical, int clientWidth, int clientHeight) {
    }

    final int getMarginLeft() {
        return super.getMarginLeft();
    }

    final int getMarginTop() {
        return super.getMarginTop();
    }

    final int getMarginRight() {
        return super.getMarginRight() + (this.vert.visibility ? this.size : 0);
    }

    final int getMarginBottom() {
        return super.getMarginBottom() + (this.horz.visibility ? this.size : 0);
    }

    private boolean handlePointerEvent(int focused, PointerEvent event) {
        int[] r = this.rect;
        switch (focused) {
            case 1: {
                event.translate(r[0], r[1]);
                this.style.horizontalScrollBarPointerEvent(this.horz, event, r[2], r[3]);
                return true;
            }
            case 2: {
                event.translate(r[0], r[1]);
                this.style.verticalScrollBarPointerEvent(this.vert, event, r[2], r[3]);
                return true;
            }
            case 3: {
                event.translate(r[0] - this.horz.position, r[1] - this.vert.position);
                this.onClientPointerEvent(event);
                return true;
            }
            case 4: {
                int a = event.getAction();
                if (a == 9 || a == 15 || a == 11) {
                    event.translate(r[0], r[1]);
                    this.scroll(event.historicalX(1) - event.getX(), event.historicalY(1) - event.getY());
                }
                return true;
            }
        }
        return false;
    }

    private int getFocusedElement(int x, int y, int button) {
        boolean hvisible = this.horz.visibility;
        boolean vvisible = this.vert.visibility;
        byte e = this.getElements();
        int l = super.getMarginLeft();
        int t = super.getMarginTop() + ((e & 8) != 0 ? this.getTickerHeight() : 0) + ((e & 4) != 0 ? this.getTitleHeight() : 0);
        int w = this.getTotalWidth() - super.getMarginRight() - l;
        int h = this.getTotalHeight() - super.getMarginBottom() - t - ((e & 1) != 0 ? this.getPanelHeight() : 0);
        int s = this.size;
        int[] r = this.rect;
        if (hvisible) {
            int sw;
            int st = t + h - s;
            int n = sw = vvisible ? w - s : w;
            if (x >= l && x < l + sw && y >= st && y < st + s) {
                r[0] = l;
                r[1] = st;
                r[2] = sw;
                r[3] = s;
                return 1;
            }
        }
        if (vvisible) {
            int sh;
            int sl = l + w - s;
            int n = sh = hvisible ? h - s : h;
            if (x >= sl && x < sl + s && y >= t && y < t + sh) {
                r[0] = sl;
                r[1] = t;
                r[2] = s;
                r[3] = sh;
                return 2;
            }
        }
        if (hvisible) {
            h -= s;
        }
        if (vvisible) {
            w -= s;
        }
        if (x >= l && x < l + w && y >= t && y < t + h) {
            r[0] = l;
            r[1] = t;
            r[2] = w;
            r[3] = h;
            return button == 13 ? 4 : 3;
        }
        return 0;
    }

    private abstract class BasicScrollBar
    extends CustomScrollBar {
        protected BasicScrollBar(boolean visibility, int range, Object monitor) {
            super(visibility, range, monitor);
        }

        public abstract int getPage();

        public void repaint() {
            ScrollingScreen.this.requestPaint((byte)2);
        }

        protected void notifyFieldsChanged(int fields) {
            ScrollingScreen.this.requestPaint((byte)2);
        }
    }

    class Helper
    extends Displayable.Helper {
        private int scrollHorz = -1;
        private int scrollVert = -1;

        protected void execute() {
            this.serviceSizeChanged();
            this.serviceScroll();
            this.servicePaint();
        }

        protected final void serviceScroll() {
            ScrollingScreen owner = ScrollingScreen.this;
            if (owner.getParentDisplay() == null) {
                return;
            }
            int hpos = owner.horz.invalidatePosition();
            int vpos = owner.vert.invalidatePosition();
            if (this.scrollHorz == hpos && this.scrollVert == vpos) {
                return;
            }
            try {
                this.scrollHorz = hpos;
                this.scrollVert = vpos;
                owner.onClientScroll(this.scrollHorz, this.scrollVert, this.availableWidth(), this.availableHeight());
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }

        protected final int positionHorizontal() {
            return this.scrollHorz;
        }

        protected final int positionVertical() {
            return this.scrollVert;
        }
    }

    private final class HorzScrollBar
    extends BasicScrollBar {
        public HorzScrollBar(boolean visibility, int range, Object monitor) {
            super(visibility, range, monitor);
        }

        public int getPage() {
            return ScrollingScreen.this.getApplicationWidth();
        }
    }

    private final class VertScrollBar
    extends BasicScrollBar {
        public VertScrollBar(boolean visibility, int range, Object monitor) {
            super(visibility, range, monitor);
        }

        public int getPage() {
            return ScrollingScreen.this.getApplicationHeight();
        }
    }
}

