/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CustomScrollBar;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Input;
import javax.microedition.lcdui.ScreenGraphics;
import javax.microedition.lcdui.ScrollBar;
import javax.microedition.lcdui.ScrollingScreen;
import javax.microedition.lcdui.Ticker;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.DeviceSettings;
import malik.emulator.microedition.lcdui.CommandOwner;
import malik.emulator.microedition.lcdui.InputStringBuilder;
import malik.emulator.microedition.lcdui.SystemScrollBarStyle;
import malik.emulator.util.StringBuilder;

public class TextBox
extends ScrollingScreen
implements Input {
    private static final Font EDITOR_FONT = Font.getFont(1);
    private char[] buffer;
    private final CommandOwner box;
    private final Input alternative;
    final InputStringBuilder builder;
    final Object monitor;

    public TextBox(String title, String inputText, int maximumLength, int constraints) {
        this(title, null, false, inputText, maximumLength, constraints);
    }

    public TextBox(String title, Ticker ticker, boolean fullScreen, String inputText, int maximumLength, int constraints) {
        super(title, ticker, fullScreen, (byte)32, new SystemScrollBarStyle());
        InputStringBuilder builder;
        InputStringBuilder monitor = builder = new InputStringBuilder(inputText, maximumLength, constraints);
        InputStringBuilder inputStringBuilder = builder;
        inputStringBuilder.getClass();
        InputStringBuilder.AdditionalCapabilities box = new InputStringBuilder.AdditionalCapabilities(inputStringBuilder, true, monitor){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void commandAction(Command command, Displayable screen) {
                super.commandAction(command, screen);
                Object object = this.monitor;
                synchronized (object) {
                    if (this.parentBuilder().isModified()) {
                        TextBox.this.correctScrollBar(true);
                    }
                }
            }
        };
        this.box = box;
        this.alternative = builder.newInput();
        this.builder = builder;
        this.monitor = monitor;
        Command[] commands = box.getMyOwnedCommands();
        int len = commands == null ? 0 : commands.length;
        int i = 0;
        while (i < len) {
            Command command = commands[i];
            if (command != null) {
                super.addCommand(command);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(char[] src, int offset, int length, int position) {
        if (src == null) {
            throw new NullPointerException("TextBox.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound((String)"TextBox.insert", (int)src.length, (int)offset, (int)length);
        if (length <= 0) {
            return;
        }
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            InputStringBuilder builder = this.builder;
            int currentLength = builder.length();
            if (length + currentLength > builder.getMaximumLength()) {
                error = 1;
            } else {
                this.alternative.insert(src, offset, length, position);
                if (currentLength == builder.length()) {
                    error = 2;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalArgumentException("TextBox.insert: \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u0442\u044c \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
            }
            case 2: {
                throw new IllegalArgumentException("TextBox.insert: \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
            }
        }
        this.requestPaint((byte)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String text, int position) {
        if (text == null) {
            throw new NullPointerException("TextBox.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int length = text.length();
        if (length <= 0) {
            return;
        }
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            InputStringBuilder builder = this.builder;
            int currentLength = builder.length();
            if (length + currentLength > builder.getMaximumLength()) {
                error = 1;
            } else {
                this.alternative.insert(text, position);
                if (currentLength == builder.length()) {
                    error = 2;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalArgumentException("TextBox.insert: \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u0442\u044c \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
            }
            case 2: {
                throw new IllegalArgumentException("TextBox.insert: \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
            }
        }
        this.requestPaint((byte)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int offset, int length) {
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            InputStringBuilder builder = this.builder;
            int currentLength = builder.length();
            if (!Array.isBoundValid((int)currentLength, (int)offset, (int)length)) {
                error = 1;
            } else {
                this.alternative.delete(offset, length);
                if (length > 0 && currentLength == builder.length()) {
                    error = 2;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new StringIndexOutOfBoundsException("TextBox.delete: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            case 2: {
                throw new IllegalArgumentException("TextBox.delete: \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
            }
        }
        this.requestPaint((byte)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConstraints(int constraints) {
        if (!InputStringBuilder.isConstraintsValid(constraints)) {
            throw new IllegalArgumentException("TextBox.setConstraints: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 constraints \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        Object object = this.monitor;
        synchronized (object) {
            CommandOwner box = this.box;
            Command[] commands = box.getMyOwnedCommands();
            int i = commands == null ? 0 : commands.length;
            while (i-- > 0) {
                super.removeCommand(commands[i]);
            }
            this.alternative.setConstraints(constraints);
            commands = box.getMyOwnedCommands();
            int len = commands == null ? 0 : commands.length;
            int i2 = 0;
            while (i2 < len) {
                Command command = commands[i2];
                if (command != null) {
                    super.addCommand(command);
                }
                ++i2;
            }
        }
        this.requestPaint((byte)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChars(char[] src, int offset, int length) {
        if (src != null) {
            Array.checkBound((String)"TextBox.setChars", (int)src.length, (int)offset, (int)length);
            char[] cArray = src;
            int n = offset;
            src = new char[length];
            offset = 0;
            Array.copy((char[])cArray, (int)n, (char[])src, (int)0, (int)length);
        } else {
            length = 0;
            offset = 0;
        }
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            InputStringBuilder builder = this.builder;
            if (length > builder.getMaximumLength()) {
                error = 1;
            } else if (!InputStringBuilder.isConstraintsMatch(builder.getConstraints(), src, offset, length)) {
                error = 2;
            } else {
                this.alternative.setChars(src, offset, length);
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalArgumentException("TextBox.setChars: \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u0442\u044c \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
            }
            case 2: {
                throw new IllegalArgumentException("TextBox.setChars: \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
            }
        }
        this.requestPaint((byte)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String inputText) {
        int error = 0;
        int length = inputText == null ? 0 : inputText.length();
        Object object = this.monitor;
        synchronized (object) {
            InputStringBuilder builder = this.builder;
            if (length > builder.getMaximumLength()) {
                error = 1;
            } else if (!InputStringBuilder.isConstraintsMatch(builder.getConstraints(), inputText)) {
                error = 2;
            } else {
                this.alternative.setString(inputText);
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalArgumentException("TextBox.setString: \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u0442\u044c \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
            }
            case 2: {
                throw new IllegalArgumentException("TextBox.setString: \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
            }
        }
        this.requestPaint((byte)2);
    }

    public void setInitialInputMode(String characterSubset) {
        this.alternative.setInitialInputMode(characterSubset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setMaxSize(int maximumSize) {
        int result;
        if (maximumSize <= 0) {
            throw new IllegalArgumentException("TextBox.setMaxSize: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 maximumSize \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        Object object = this.monitor;
        synchronized (object) {
            result = this.alternative.setMaxSize(maximumSize);
        }
        this.requestPaint((byte)2);
        return result;
    }

    public int size() {
        return this.alternative.size();
    }

    public int getConstraints() {
        return this.alternative.getConstraints();
    }

    public int getCaretPosition() {
        return this.alternative.getCaretPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChars(char[] dst) {
        int result;
        if (dst == null) {
            throw new NullPointerException("TextBox.getChars: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (dst.length < this.builder.length()) {
                error = true;
                result = 0;
            } else {
                result = this.alternative.getChars(dst);
            }
        }
        if (error) {
            throw new ArrayIndexOutOfBoundsException("TextBox.getChars: \u0438\u043d\u0434\u0435\u043a\u0441 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    public int getMaxSize() {
        return this.alternative.getMaxSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        String result;
        Object object = this.monitor;
        synchronized (object) {
            result = this.alternative.getString();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(ScreenGraphics render) {
        Font font = EDITOR_FONT;
        int temp = render.getClipY();
        int line = font.getHeight();
        int srow = temp / line;
        int frow = (temp + render.getClipHeight() - 1) / line;
        render.setFont(font);
        Object object = this.monitor;
        synchronized (object) {
            char[] buffer = this.buffer;
            InputStringBuilder builder = this.builder;
            render.setColor(RasterCanvas.getSystemColor((int)((builder.getConstraints() & 0x20000) == 0 ? 33 : 35)));
            int caretPosition = builder.getCaretPosition();
            int caretLine = builder.lineAt(caretPosition);
            int length = builder.lines();
            int top = srow * line;
            int index = srow;
            while (index <= frow && index < length) {
                int lofs = builder.lineOffset(index);
                int llen = builder.lineLength(index);
                if (buffer == null || buffer.length < llen) {
                    buffer = this.buffer = new char[StringBuilder.optimalCapacity((int)llen)];
                }
                builder.copy(lofs, lofs + llen, buffer, 0);
                render.drawChars(buffer, 0, llen, 2, top, 20);
                if (caretLine == index) {
                    int caretLeft = font.charsWidth(buffer, 0, caretPosition - lofs) + 1;
                    render.drawLine(caretLeft, top, caretLeft, top + line - 1);
                }
                top += line;
                ++index;
            }
        }
    }

    void paintBackground(ScreenGraphics render, int width, int height, byte visibleElements, byte drawingElements) {
        int elementHeight;
        int elementTop = 0;
        if ((visibleElements & 8) != 0) {
            elementHeight = this.getTickerHeight();
            if ((drawingElements & 8) != 0) {
                render.drawElement(13, 0, 0, 0, elementTop, width, elementHeight);
            }
            elementTop += elementHeight;
        }
        if ((visibleElements & 4) != 0) {
            elementHeight = this.getTitleHeight();
            if ((drawingElements & 4) != 0) {
                render.drawElement(6, 1, 0, 0, elementTop, width, elementHeight);
            }
            elementTop += elementHeight;
        }
        elementHeight = height - elementTop;
        if ((visibleElements & 1) != 0) {
            int panelHeight = this.getPanelHeight();
            if ((drawingElements & 1) != 0) {
                render.setClip(0, height - panelHeight, width, panelHeight);
                render.drawElement(6, 5, 0, 0, elementTop, width, elementHeight);
                render.setClip(0, 0, width, height);
            }
            elementHeight -= panelHeight;
        }
        if ((visibleElements & drawingElements & 2) != 0) {
            render.drawElement(8, (this.builder.getConstraints() & 0x20000) != 0 ? 3 : 1, 0, -2, elementTop, width + 4, elementHeight);
        }
    }

    void onSizeChanged(int width, int height) {
        this.builder.setModified(true);
        super.onSizeChanged(width, height);
    }

    void onCommandAction(Command command) {
        CommandOwner box = this.box;
        if (box.isMyOwnedCommand(command)) {
            box.commandAction(command, this);
            return;
        }
        super.onCommandAction(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientKeyboardEvent(KeyboardEvent event) {
        int key = event.getKey();
        int action = event.getAction();
        DeviceSettings settings = DeviceManager.getInstance().getSettings();
        if (key == settings.getKeyUsedAs(40)) {
            if (action == 6 || action == 5) {
                Object object = this.monitor;
                synchronized (object) {
                    InputStringBuilder builder = this.builder;
                    builder.setCaretPosition(builder.getCaretPosition() - 1);
                    if (builder.isModified()) {
                        this.correctScrollBar(false);
                    }
                }
            }
            return;
        }
        if (key == settings.getKeyUsedAs(41)) {
            if (action == 6 || action == 5) {
                Object object = this.monitor;
                synchronized (object) {
                    InputStringBuilder builder = this.builder;
                    builder.setCaretPosition(builder.getCaretPosition() + 1);
                    if (builder.isModified()) {
                        this.correctScrollBar(false);
                    }
                }
            }
            return;
        }
        if (key == settings.getKeyUsedAs(38)) {
            if (action == 6 || action == 5) {
                Object object = this.monitor;
                synchronized (object) {
                    InputStringBuilder builder = this.builder;
                    int caretPosition = builder.getCaretPosition();
                    int caretRow = builder.lineAt(caretPosition);
                    if (caretRow > 0) {
                        this.moveCaret(builder, caretRow--, caretPosition, caretRow);
                    }
                }
            }
            return;
        }
        if (key == settings.getKeyUsedAs(36)) {
            if (action == 6 || action == 5) {
                Object object = this.monitor;
                synchronized (object) {
                    InputStringBuilder builder = this.builder;
                    int caretPosition = builder.getCaretPosition();
                    int caretRow = builder.lineAt(caretPosition);
                    if (caretRow < builder.lines() - 1) {
                        this.moveCaret(builder, caretRow++, caretPosition, caretRow);
                    }
                }
            }
            return;
        }
        Object object = this.monitor;
        synchronized (object) {
            InputStringBuilder builder = this.builder;
            builder.keyboardEvent(event);
            if (builder.isModified()) {
                this.correctScrollBar(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientPointerEvent(PointerEvent event) {
        int action = event.getAction();
        if (event.isButtonPressed(0) || (action == 15 || action == 11) && event.getButton() == 0) {
            Object object = this.monitor;
            synchronized (object) {
                int caretRow = event.getY() / EDITOR_FONT.getHeight();
                InputStringBuilder builder = this.builder;
                int limit = builder.lines() - 1;
                if (caretRow > limit) {
                    caretRow = limit;
                }
                if (caretRow < 0) {
                    caretRow = 0;
                }
                this.moveCaret(builder, event.getX() - 2, caretRow);
            }
        }
    }

    Displayable.Helper createHelper() {
        return new Helper();
    }

    final void correctScrollBar(boolean splitNeeded) {
        Font font = EDITOR_FONT;
        InputStringBuilder builder = this.builder;
        if (splitNeeded) {
            builder.split(font, this.getApplicationWidth() - 4);
        }
        int line = builder.lineAt(builder.getCaretPosition());
        int step = font.getHeight();
        int top1 = step * line;
        int top2 = step + top1;
        CustomScrollBar scroll = this.vert;
        scroll.setRange(builder.lines() * step);
        int pos = scroll.getPosition();
        if (top1 < pos) {
            scroll.setPosition(top1);
        } else {
            int page = ((ScrollBar)scroll).getPage();
            if (top2 > pos + page) {
                scroll.setPosition(top2 - page);
            } else {
                this.requestPaint((byte)2);
            }
        }
    }

    private void moveCaret(InputStringBuilder builder, int caretRow, int caretPosition, int newCaretRow) {
        int caretCol;
        int lofs;
        block5: {
            lofs = builder.lineOffset(caretRow);
            caretCol = caretPosition - lofs;
            char[] buffer = this.buffer;
            if (this.buffer == null || buffer.length < caretCol) {
                buffer = this.buffer = new char[StringBuilder.optimalCapacity((int)caretCol)];
            }
            builder.copy(lofs, caretPosition, buffer, 0);
            Font font = EDITOR_FONT;
            int charsWidth = font.charsWidth(buffer, 0, caretCol);
            lofs = builder.lineOffset(newCaretRow);
            int llen = builder.lineLength(newCaretRow);
            if (buffer.length < llen) {
                buffer = this.buffer = new char[StringBuilder.optimalCapacity((int)llen)];
            }
            builder.copy(lofs, lofs + llen, buffer, 0);
            int w1 = 0;
            int i = 1;
            while (i <= llen) {
                int w2 = font.charsWidth(buffer, 0, i);
                if (charsWidth >= w1 && charsWidth < w2) {
                    caretCol = charsWidth - w1 <= w2 - charsWidth ? i - 1 : i;
                    break block5;
                }
                w1 = w2;
                ++i;
            }
            caretCol = llen;
        }
        builder.setCaretPosition(lofs + caretCol);
        if (builder.isModified()) {
            this.correctScrollBar(false);
        }
    }

    private void moveCaret(InputStringBuilder builder, int charsWidth, int newCaretRow) {
        int caretCol;
        int lofs;
        block5: {
            lofs = builder.lineOffset(newCaretRow);
            int llen = builder.lineLength(newCaretRow);
            Font font = EDITOR_FONT;
            if (charsWidth < 0) {
                charsWidth = 0;
            }
            char[] lbuf = this.buffer;
            if (this.buffer == null || lbuf.length < llen) {
                lbuf = this.buffer = new char[StringBuilder.optimalCapacity((int)(llen - 1)) + 1];
            }
            builder.copy(lofs, lofs + llen, lbuf, 0);
            int w1 = 0;
            int i = 1;
            while (i <= llen) {
                int w2 = font.charsWidth(lbuf, 0, i);
                if (charsWidth >= w1 && charsWidth < w2) {
                    caretCol = charsWidth - w1 <= w2 - charsWidth ? i - 1 : i;
                    break block5;
                }
                w1 = w2;
                ++i;
            }
            caretCol = llen;
        }
        builder.setCaretPosition(lofs + caretCol);
        if (builder.isModified()) {
            this.correctScrollBar(false);
        }
    }

    class Helper
    extends ScrollingScreen.Helper {
        public Helper() {
            super(TextBox.this);
        }

        protected void execute() {
            this.serviceSizeChanged();
            this.serviceSplitText();
            this.serviceScroll();
            this.servicePaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void serviceSplitText() {
            TextBox owner = TextBox.this;
            Object object = owner.monitor;
            synchronized (object) {
                if (owner.builder.isModified()) {
                    owner.correctScrollBar(true);
                }
            }
        }
    }
}

