/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.rms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.Record;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;
import malik.emulator.io.cloud.CloudFileSystem;
import malik.emulator.io.cloud.FileInputStream;
import malik.emulator.io.cloud.FileOutputStream;
import malik.emulator.io.vfs.FileEnumeration;
import malik.emulator.util.StringBuilder;

public class RecordStore {
    private static final char HEX_PREFIX = '$';
    public static final int AUTHMODE_PRIVATE = 0;
    public static final int AUTHMODE_ANY = 1;
    public static final int STATE_ERROR = -1;
    public static final int STATE_RESERV = 0;
    public static final int STATE_OPENED = 1;
    public static final int STATE_CLOSED = 2;
    private static final int NAME_MAXIMUM_LENGTH = 32;
    private static final long RMS_SIGNATURE = 7883943055650352499L;
    private static final String RMS_DIR_NAME = "/rms";
    private static final String RMS_DIR_PATH = "/rms/";
    private static final String RMS_EXTENSION = ".rms";
    private static RecordStore[] OPENED;
    private static final RecordFilter DEFAULT_FILTER;
    private static final RecordComparator DEFAULT_COMPARATOR;
    static final Object MONITOR;
    int openedCount;
    private int version;
    private int nextID;
    int count;
    private long lastModified;
    Record[] records;
    private RecordListener[] listeners;
    final String name;

    static {
        DefaultFilterComparator ref = new DefaultFilterComparator();
        OPENED = new RecordStore[2];
        DEFAULT_FILTER = ref;
        DEFAULT_COMPARATOR = ref;
        MONITOR = ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllRecordStores() {
        Object object = MONITOR;
        synchronized (object) {
            int i = OPENED.length;
            while (i-- > 0) {
                RecordStore store = OPENED[i];
                if (store == null || store.openedCount == 0) continue;
                if (store.saveData()) {
                    store.openedCount = 0;
                    store.close();
                    continue;
                }
                System.out.println(new StringBuilder().append("/!\\ RecordStore.closeAllRecordStores: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(store.name).append(".").toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRecordStore(String name) throws RecordStoreException {
        RecordStore.checkName("deleteRecordStore", name);
        boolean error = false;
        Object object = MONITOR;
        synchronized (object) {
            int i = RecordStore.indexOfRecordStore(name);
            if (i >= 0) {
                if (RecordStore.OPENED[i].openedCount != 0) {
                    error = true;
                } else {
                    RecordStore.OPENED[i] = null;
                }
            }
        }
        if (error) {
            throw new RecordStoreException(new StringBuilder().append("RecordStore.deleteRecordStore: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u043e\u0435 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(name).append(".").toString());
        }
        try {
            CloudFileSystem.instance.deleteFile(RecordStore.toFileName(name));
        }
        catch (IOException iOException) {
            throw new RecordStoreNotFoundException(new StringBuilder().append("RecordStore.deleteRecordStore: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(name).append(".").toString());
        }
    }

    public static int getState(String name) {
        RecordStore store;
        int i;
        return name == null || (i = name.length()) < 1 || i > 32 ? -1 : ((store = RecordStore.getRecordStore(name)) == null ? 0 : (store.openedCount != 0 ? 1 : 2));
    }

    public static String[] listRecordStores() {
        Vector<String> list;
        block7: {
            int extlen = RMS_EXTENSION.length();
            int i = OPENED.length;
            list = new Vector<String>(i);
            while (i-- > 0) {
                RecordStore store = OPENED[i];
                if (store == null) continue;
                list.addElement(store.name);
            }
            try {
                FileEnumeration e = CloudFileSystem.instance.findFirst(RMS_DIR_PATH);
                if (e == null) break block7;
                try {
                    do {
                        int len;
                        String n;
                        if (e.isDirectory() || (n = e.getName()) == null || !n.regionMatches(true, len = n.length() - extlen, RMS_EXTENSION, 0, extlen) || !RecordStore.isStoreName(n = n.substring(0, len)) || list.contains(n = RecordStore.toStoreName(n))) continue;
                        list.addElement(n);
                    } while (e.findNext());
                }
                finally {
                    e.close();
                }
            }
            catch (IOException e) {
                e.printRealStackTrace();
            }
        }
        Object[] result = new String[list.size()];
        list.copyInto(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordStore openRecordStore(String name, boolean createIfNecessary) throws RecordStoreException {
        RecordStore result;
        RecordStore.checkName("openRecordStore", name);
        int error = 0;
        Object object = MONITOR;
        synchronized (object) {
            int i = RecordStore.indexOfRecordStore(name);
            if (i >= 0) {
                result = OPENED[i];
                i = result.openedCount;
                if (i == 0 && !result.loadData() && !createIfNecessary) {
                    error = 1;
                } else {
                    result.openedCount = i + 1;
                }
            } else {
                result = new RecordStore(name);
                if (!result.loadData() && !createIfNecessary) {
                    error = 2;
                } else {
                    RecordStore.register(result);
                    result.openedCount = 1;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new RecordStoreException(new StringBuilder().append("RecordStore.openRecordStore: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(name).append(".").toString());
            }
            case 2: {
                throw new RecordStoreNotFoundException(new StringBuilder().append("RecordStore.openRecordStore: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(name).append(".").toString());
            }
        }
        return result;
    }

    public static RecordStore openRecordStore(String name, boolean createIfNecessary, int authmode, boolean writable) throws RecordStoreException {
        return RecordStore.openRecordStore(name, createIfNecessary);
    }

    public static RecordStore openRecordStore(String name, String vendorName, String suiteName) throws RecordStoreException {
        return RecordStore.openRecordStore(name, false);
    }

    private static void checkName(String method, String name) {
        int len;
        if (name == null || (len = name.length()) < 1 || len > 32) {
            throw new IllegalArgumentException(new StringBuilder().append("RecordStore.").append(method).append(": \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0438\u043c\u044f \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430 \u0437\u0430\u043f\u0438\u0441\u0435\u0439.").toString());
        }
    }

    private static void register(RecordStore store) {
        int len = OPENED.length;
        int i = Array.findb((Object[])OPENED, (int)(len - 1), null);
        if (i >= 0) {
            RecordStore.OPENED[i] = store;
            return;
        }
        Object[] objectArray = OPENED;
        OPENED = new RecordStore[len << 1];
        Array.copy((Object[])objectArray, (int)0, (Object[])OPENED, (int)0, (int)len);
        RecordStore.OPENED[len] = store;
    }

    private static boolean isStoreName(String name) {
        int len = name.length();
        char[] chars = new char[len + 1];
        name.getChars(0, len, chars, 0);
        int i = 0;
        while (i < len) {
            char c;
            if ((c = chars[i++]) != '$') {
                if (c == '_' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z') continue;
                return false;
            }
            char code = '\u0000';
            int j = 4;
            while (j-- > 0) {
                if ((c = chars[i++]) >= '0' && c <= '9') {
                    code = (char)(code << 4 | c - 48);
                    continue;
                }
                if (c >= 'A' && c <= 'F') {
                    code = (char)(code << 4 | c - 55);
                    continue;
                }
                return false;
            }
            c = code;
            if (c != '_' && (c < '0' || c > '9') && (c < 'a' || c > 'z')) continue;
            return false;
        }
        return true;
    }

    private static char getDigitRepresentation(int digit) {
        if (digit >= 0 && digit < 10) {
            return (char)(digit + 48);
        }
        if (digit >= 10 && digit < 16) {
            return (char)(digit + 55);
        }
        throw new ArrayIndexOutOfBoundsException(digit);
    }

    private static int indexOfRecordStore(String name) {
        int i = OPENED.length;
        while (i-- > 0) {
            RecordStore store = OPENED[i];
            if (store == null || !name.equals(store.name)) continue;
            return i;
        }
        return -1;
    }

    private static RecordStore getRecordStore(String name) {
        int i = OPENED.length;
        while (i-- > 0) {
            RecordStore store = OPENED[i];
            if (store == null || !name.equals(store.name)) continue;
            return store;
        }
        return null;
    }

    private static String toStoreName(String fileName) {
        int length = 0;
        char[] result = new char[32];
        int len = fileName.length();
        int i = 0;
        while (i < len && length < 32) {
            char c;
            if ((c = fileName.charAt(i++)) == '$') {
                int j = 0;
                c = '\u0000';
                while (i < len) {
                    char d;
                    if ((d = fileName.charAt(i++)) >= '0' && d <= '9') {
                        c = (char)(c << 4 | d - 48);
                    } else {
                        if (d < 'A' || d > 'F') break;
                        c = (char)(c << 4 | d - 55);
                    }
                    if (++j < 4) continue;
                }
            }
            result[length++] = c;
        }
        return new String(result, 0, length);
    }

    private static String toFileName(String name) {
        int length = 0;
        char[] result = new char[160];
        int len = name.length();
        int i = 0;
        while (i < len) {
            char c;
            if ((c = name.charAt(i++)) == '_' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z') {
                result[length++] = c;
                continue;
            }
            result[length++] = 36;
            result[length++] = RecordStore.getDigitRepresentation(c >> 12 & 0xF);
            result[length++] = RecordStore.getDigitRepresentation(c >> 8 & 0xF);
            result[length++] = RecordStore.getDigitRepresentation(c >> 4 & 0xF);
            result[length++] = RecordStore.getDigitRepresentation(c & 0xF);
        }
        return new StringBuilder().append(RMS_DIR_PATH).append(result, 0, length).append(RMS_EXTENSION).toString();
    }

    private RecordStore(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecordListener(RecordListener listener) {
        if (listener == null) {
            return;
        }
        Object object = MONITOR;
        synchronized (object) {
            Object[] listeners = this.listeners;
            if (this.listeners == null) {
                this.listeners = new RecordListener[3];
                listeners = this.listeners;
            }
            int len = listeners.length;
            if (Array.findf((Object[])listeners, (int)0, (Object)listener) >= len) {
                int index = Array.findf((Object[])listeners, (int)0, null);
                if (index >= len) {
                    Object[] objectArray = listeners;
                    listeners = new RecordListener[(len << 1) + 1];
                    Array.copy((Object[])objectArray, (int)0, (Object[])listeners, (int)0, (int)len);
                    this.listeners = listeners;
                }
                listeners[index] = listener;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecordListener(RecordListener listener) {
        if (listener == null) {
            return;
        }
        Object object = MONITOR;
        synchronized (object) {
            int index;
            Object[] listeners = this.listeners;
            if (this.listeners != null && (index = Array.findf((Object[])listeners, (int)0, (Object)listener)) < listeners.length) {
                listeners[index] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRecordStore() throws RecordStoreException {
        int error = 0;
        Object object = MONITOR;
        synchronized (object) {
            int i = this.openedCount;
            if (i == 0) {
                error = 1;
            } else {
                this.openedCount = i - 1;
                if (this.openedCount == 0) {
                    if (!this.saveData()) {
                        error = 2;
                    } else {
                        this.close();
                    }
                }
            }
        }
        switch (error) {
            case 1: {
                throw new RecordStoreNotOpenException(new StringBuilder().append("RecordStore.closeRecordStore: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0443\u0436\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0435 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.name).append(".").toString());
            }
            case 2: {
                throw new RecordStoreException(new StringBuilder().append("RecordStore.closeRecordStore: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.name).append(".").toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord(int recordID) throws RecordStoreException {
        int error = 0;
        Object object = MONITOR;
        synchronized (object) {
            if (this.openedCount == 0) {
                error = 1;
            } else {
                int index = this.indexOfRecord(recordID);
                if (index < 0) {
                    error = 2;
                } else {
                    Object[] recs = this.records;
                    int len = this.count - 1;
                    if (len > index) {
                        Array.copy((Object[])recs, (int)(index + 1), (Object[])recs, (int)index, (int)(len - index));
                    }
                    this.count = len;
                    recs[this.count] = null;
                    ++this.version;
                    this.lastModified = System.currentTimeMillis();
                }
            }
        }
        switch (error) {
            case 1: {
                throw new RecordStoreNotOpenException(new StringBuilder().append("RecordStore.deleteRecord: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.name).append(" \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.").toString());
            }
            case 2: {
                throw new InvalidRecordIDException(new StringBuilder().append("RecordStore.deleteRecord: \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0438\u0441\u0438 (").append(recordID).append(").").toString());
            }
        }
        this.notifyListenersDeleted(recordID);
    }

    public void setMode(int authmode, boolean writable) throws RecordStoreException {
        if (authmode != 1 && authmode != 0) {
            throw new IllegalArgumentException("RecordStore.setMode: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 authmode \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecord(int recordID, byte[] src, int offset, int length) throws RecordStoreException {
        if (src != null) {
            Array.checkBound((String)"RecordStore.setRecord", (int)src.length, (int)offset, (int)length);
        }
        int error = 0;
        Object object = MONITOR;
        synchronized (object) {
            if (this.openedCount == 0) {
                error = 1;
            } else {
                int index = this.indexOfRecord(recordID);
                if (index < 0) {
                    error = 2;
                } else {
                    if (src != null) {
                        byte[] byArray = src;
                        src = new byte[length];
                        Array.copy((byte[])byArray, (int)offset, (byte[])src, (int)0, (int)length);
                    } else {
                        src = new byte[]{};
                    }
                    this.records[index].setData(src);
                    ++this.version;
                    this.lastModified = System.currentTimeMillis();
                }
            }
        }
        switch (error) {
            case 1: {
                throw new RecordStoreNotOpenException(new StringBuilder().append("RecordStore.setRecord: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.name).append(" \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.").toString());
            }
            case 2: {
                throw new InvalidRecordIDException(new StringBuilder().append("RecordStore.setRecord: \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0438\u0441\u0438 (").append(recordID).append(").").toString());
            }
        }
        this.notifyListenersChanged(recordID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRecord(byte[] src, int offset, int length) throws RecordStoreException {
        int result;
        if (src != null) {
            Array.checkBound((String)"RecordStore.addRecord", (int)src.length, (int)offset, (int)length);
        }
        boolean error = false;
        Object object = MONITOR;
        synchronized (object) {
            if (this.openedCount == 0) {
                error = true;
                result = 0;
            } else {
                int len;
                Object[] recs = this.records;
                if (this.records == null || recs.length <= 0) {
                    this.records = new Record[3];
                    recs = this.records;
                }
                if ((len = this.count) == recs.length) {
                    Object[] objectArray = recs;
                    this.records = new Record[(len << 1) + 1];
                    recs = this.records;
                    Array.copy((Object[])objectArray, (int)0, (Object[])this.records, (int)0, (int)len);
                }
                if (src != null) {
                    byte[] byArray = src;
                    src = new byte[length];
                    Array.copy((byte[])byArray, (int)offset, (byte[])src, (int)0, (int)length);
                } else {
                    src = new byte[]{};
                }
                result = this.nextID++;
                recs[len] = new Record(result, src);
                this.count = len + 1;
                ++this.version;
                this.lastModified = System.currentTimeMillis();
            }
        }
        if (error) {
            throw new RecordStoreNotOpenException(new StringBuilder().append("RecordStore.addRecord: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.name).append(" \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.").toString());
        }
        this.notifyListenersAdded(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecord(int recordID, byte[] dst, int offset) throws RecordStoreException {
        int result;
        if (dst == null) {
            throw new NullPointerException("RecordStore.getRecord: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int error = 0;
        Object object = MONITOR;
        synchronized (object) {
            if (this.openedCount == 0) {
                error = 1;
                result = 0;
            } else {
                int index = this.indexOfRecord(recordID);
                if (index < 0) {
                    error = 2;
                    result = 0;
                } else {
                    byte[] data = this.records[index].getData();
                    result = data.length;
                    if (!Array.isBoundValid((int)dst.length, (int)offset, (int)result)) {
                        error = 3;
                        result = 0;
                    } else {
                        Array.copy((byte[])data, (int)0, (byte[])dst, (int)offset, (int)result);
                    }
                }
            }
        }
        switch (error) {
            case 1: {
                throw new RecordStoreNotOpenException(new StringBuilder().append("RecordStore.getRecord: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.name).append(" \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.").toString());
            }
            case 2: {
                throw new InvalidRecordIDException(new StringBuilder().append("RecordStore.getRecord: \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0438\u0441\u0438 (").append(recordID).append(").").toString());
            }
            case 3: {
                throw new ArrayIndexOutOfBoundsException("RecordStore.getRecord: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordSize(int recordID) throws RecordStoreException {
        int result;
        int error = 0;
        Object object = MONITOR;
        synchronized (object) {
            if (this.openedCount == 0) {
                error = 1;
                result = 0;
            } else {
                int index = this.indexOfRecord(recordID);
                if (index < 0) {
                    error = 2;
                    result = 0;
                } else {
                    result = this.records[index].getSize();
                }
            }
        }
        switch (error) {
            case 1: {
                throw new RecordStoreNotOpenException(new StringBuilder().append("RecordStore.getRecordSize: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.name).append(" \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.").toString());
            }
            case 2: {
                throw new InvalidRecordIDException(new StringBuilder().append("RecordStore.getRecordSize: \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0438\u0441\u0438 (").append(recordID).append(").").toString());
            }
        }
        return result;
    }

    public int getNextRecordID() throws RecordStoreException {
        if (this.openedCount == 0) {
            throw new RecordStoreNotOpenException(new StringBuilder().append("RecordStore.getNextRecordID: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.name).append(" \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.").toString());
        }
        return this.nextID;
    }

    public int getNumRecords() throws RecordStoreNotOpenException {
        if (this.openedCount == 0) {
            throw new RecordStoreNotOpenException(new StringBuilder().append("RecordStore.getNumRecords: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.name).append(" \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.").toString());
        }
        return this.count;
    }

    public int getVersion() throws RecordStoreNotOpenException {
        if (this.openedCount == 0) {
            throw new RecordStoreNotOpenException(new StringBuilder().append("RecordStore.getVersion: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.name).append(" \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.").toString());
        }
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() throws RecordStoreNotOpenException {
        int result;
        boolean error = false;
        Object object = MONITOR;
        synchronized (object) {
            if (this.openedCount == 0) {
                error = true;
                result = 0;
            } else {
                result = 32;
                Record[] recs = this.records;
                int i = this.count;
                while (i-- > 0) {
                    result += recs[i].getSize() + 8;
                    result += -result & 3;
                }
            }
        }
        if (error) {
            throw new RecordStoreNotOpenException(new StringBuilder().append("RecordStore.getSize: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.name).append(" \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.").toString());
        }
        return result;
    }

    public int getSizeAvailable() throws RecordStoreNotOpenException {
        if (this.openedCount == 0) {
            throw new RecordStoreNotOpenException(new StringBuilder().append("RecordStore.getSizeAvailable: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.name).append(" \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.").toString());
        }
        return Memory.getFree();
    }

    public long getLastModified() throws RecordStoreNotOpenException {
        if (this.openedCount == 0) {
            throw new RecordStoreNotOpenException(new StringBuilder().append("RecordStore.getLastModified: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.name).append(" \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.").toString());
        }
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRecord(int recordID) throws RecordStoreException {
        byte[] result;
        int error = 0;
        Object object = MONITOR;
        synchronized (object) {
            if (this.openedCount == 0) {
                error = 1;
                result = null;
            } else {
                int index = this.indexOfRecord(recordID);
                if (index < 0) {
                    error = 2;
                    result = null;
                } else {
                    byte[] data = this.records[index].getData();
                    int len = data.length;
                    result = new byte[len];
                    Array.copy((byte[])data, (int)0, (byte[])result, (int)0, (int)len);
                }
            }
        }
        switch (error) {
            case 1: {
                throw new RecordStoreNotOpenException(new StringBuilder().append("RecordStore.getRecord: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.name).append(" \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.").toString());
            }
            case 2: {
                throw new InvalidRecordIDException(new StringBuilder().append("RecordStore.getRecord: \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0438\u0441\u0438 (").append(recordID).append(").").toString());
            }
        }
        return result;
    }

    public String getName() throws RecordStoreNotOpenException {
        return this.name;
    }

    public RecordEnumeration enumerateRecords(RecordFilter filter, RecordComparator comparator, boolean autoRebuild) throws RecordStoreNotOpenException {
        if (this.openedCount == 0) {
            throw new RecordStoreNotOpenException(new StringBuilder().append("RecordStore.enumerateRecords: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.name).append(" \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.").toString());
        }
        RecordStore recordStore = this;
        recordStore.getClass();
        return recordStore.new Enumerator(filter == null ? DEFAULT_FILTER : filter, comparator == null ? DEFAULT_COMPARATOR : comparator, autoRebuild);
    }

    private void notifyListenersAdded(int recordID) {
        RecordListener[] listeners = this.listeners;
        int i = this.listeners == null ? 0 : listeners.length;
        while (i-- > 0) {
            RecordListener listener = listeners[i];
            if (listener == null) continue;
            try {
                listener.recordAdded(this, recordID);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
    }

    private void notifyListenersChanged(int recordID) {
        RecordListener[] listeners = this.listeners;
        int i = this.listeners == null ? 0 : listeners.length;
        while (i-- > 0) {
            RecordListener listener = listeners[i];
            if (listener == null) continue;
            try {
                listener.recordChanged(this, recordID);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
    }

    private void notifyListenersDeleted(int recordID) {
        RecordListener[] listeners = this.listeners;
        int i = this.listeners == null ? 0 : listeners.length;
        while (i-- > 0) {
            RecordListener listener = listeners[i];
            if (listener == null) continue;
            try {
                listener.recordDeleted(this, recordID);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
    }

    private void close() {
        this.count = 0;
        this.records = null;
        this.listeners = null;
        System.out.println(new StringBuilder().append("RecordStore: \u0432\u043d\u0435\u0441\u0435\u043d\u044b \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432 \u0437\u0430\u043f\u0438\u0441\u044c ").append(this.name).append(".").toString());
    }

    private boolean saveData() {
        boolean result;
        try {
            try {
                CloudFileSystem.instance.readAttributes(RMS_DIR_NAME, null);
            }
            catch (IOException iOException) {
                CloudFileSystem.instance.createDirectory(RMS_DIR_NAME);
            }
        }
        catch (IOException iOException) {}
        FileOutputStream file = new FileOutputStream(RecordStore.toFileName(this.name));
        if (file.hasOpenError()) {
            return false;
        }
        try {
            try {
                int len = this.count;
                Record[] recs = this.records;
                DataOutputStream stream = new DataOutputStream((OutputStream)file);
                stream.writeLong(7883943055650352499L);
                stream.writeInt(len);
                stream.writeInt(this.version);
                stream.writeLong(this.lastModified);
                stream.writeInt(this.nextID);
                stream.writeInt(0);
                int i = 0;
                while (i < len) {
                    Record rec = recs[i];
                    stream.writeInt(rec.getID());
                    int size = rec.getSize();
                    stream.writeInt(size);
                    ((OutputStream)stream).write(rec.getData());
                    switch (size & 3) {
                        case 1: {
                            stream.writeByte(0);
                        }
                        case 2: {
                            stream.writeByte(0);
                        }
                        case 3: {
                            stream.writeByte(0);
                        }
                    }
                    ++i;
                }
            }
            finally {
                file.close();
            }
            result = true;
        }
        catch (IOException e) {
            e.printRealStackTrace();
            result = false;
        }
        return result;
    }

    private boolean loadData() {
        boolean result;
        FileInputStream file = new FileInputStream(RecordStore.toFileName(this.name));
        if (file.hasOpenError()) {
            this.version = 1;
            this.nextID = 1;
            this.count = 0;
            this.lastModified = System.currentTimeMillis();
            this.records = null;
            return false;
        }
        try {
            try {
                DataInputStream stream = new DataInputStream((InputStream)file);
                if (stream.readLong() != 7883943055650352499L) {
                    this.version = 1;
                    this.nextID = 1;
                    this.count = 0;
                    this.lastModified = System.currentTimeMillis();
                    this.records = null;
                    result = false;
                } else {
                    int len;
                    this.count = len = stream.readInt();
                    this.version = stream.readInt();
                    this.lastModified = stream.readLong();
                    this.nextID = stream.readInt();
                    Record[] recs = new Record[len];
                    this.records = recs;
                    stream.skipBytes(4);
                    int i = 0;
                    while (i < len) {
                        int id = stream.readInt();
                        int size = stream.readInt();
                        byte[] data = new byte[size];
                        stream.read(data);
                        if ((size &= 3) != 0) {
                            stream.skipBytes(4 - size);
                        }
                        recs[i] = new Record(id, data);
                        ++i;
                    }
                    result = true;
                }
            }
            finally {
                file.close();
            }
        }
        catch (IOException e) {
            e.printRealStackTrace();
            result = false;
        }
        return result;
    }

    private int indexOfRecord(int recordID) {
        Record[] recs = this.records;
        int i = this.count;
        while (i-- > 0) {
            if (recs[i].getID() != recordID) continue;
            return i;
        }
        return -1;
    }

    private static final class DefaultFilterComparator
    implements RecordFilter,
    RecordComparator {
        public boolean matches(byte[] recordData) {
            return true;
        }

        public int compare(byte[] recordData1, byte[] recordData2) {
            return 0;
        }
    }

    private final class Enumerator
    implements RecordListener,
    RecordEnumeration {
        private boolean nowCreated = true;
        private boolean autoRebuild;
        private int current;
        private int count;
        private Record[] records;
        private final RecordComparator comparator;
        private final RecordFilter filter;
        private final Object monitor;

        public Enumerator(RecordFilter filter, RecordComparator comparator, boolean autoRebuild) {
            this.autoRebuild = autoRebuild;
            this.comparator = comparator;
            this.filter = filter;
            this.monitor = new Object();
            this.rebuild();
            if (autoRebuild) {
                RecordStore.this.addRecordListener(this);
            }
        }

        public void recordAdded(RecordStore store, int recordID) {
            if (store == RecordStore.this) {
                this.rebuild();
            }
        }

        public void recordChanged(RecordStore store, int recordID) {
            if (store == RecordStore.this) {
                this.rebuild();
            }
        }

        public void recordDeleted(RecordStore store, int recordID) {
            if (store == RecordStore.this) {
                this.rebuild();
            }
        }

        public void destroy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rebuild() {
            Record[] sourceRecs;
            int sourceCount;
            boolean opened;
            RecordComparator comparator = this.comparator;
            RecordFilter filter = this.filter;
            RecordStore store = RecordStore.this;
            Object object = MONITOR;
            synchronized (object) {
                opened = store.openedCount != 0;
                if (opened) {
                    sourceCount = store.count;
                    sourceRecs = store.records;
                } else {
                    sourceCount = 0;
                    sourceRecs = null;
                }
            }
            if (sourceRecs == null || !opened) {
                return;
            }
            int rebuildedCount = 0;
            Record[] rebuildedRecs = new Record[sourceCount];
            try {
                int i = 0;
                while (i < sourceCount) {
                    Record rec = sourceRecs[i];
                    if (rec != null && filter.matches(rec.getData())) {
                        rebuildedRecs[rebuildedCount++] = rec;
                    }
                    ++i;
                }
                int lim = rebuildedCount - 1;
                int i2 = 0;
                while (i2 < lim) {
                    Record rec1 = rebuildedRecs[i2];
                    int j = i2 + 1;
                    while (j < rebuildedCount) {
                        Record rec2 = rebuildedRecs[j];
                        if (comparator.compare(rec2.getData(), rec1.getData()) < 0) {
                            rebuildedRecs[i2] = rec2;
                            rebuildedRecs[j] = rec1;
                            rec1 = rec2;
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
                return;
            }
            Object object2 = this.monitor;
            synchronized (object2) {
                this.nowCreated = true;
                this.count = rebuildedCount;
                this.records = rebuildedRecs;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = this.monitor;
            synchronized (object) {
                this.nowCreated = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keepUpdated(boolean autoRebuild) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.autoRebuild != autoRebuild) {
                    this.autoRebuild = autoRebuild;
                    if (this.autoRebuild) {
                        RecordStore.this.addRecordListener(this);
                    } else {
                        RecordStore.this.removeRecordListener(this);
                    }
                }
            }
            if (autoRebuild) {
                this.rebuild();
            }
        }

        public boolean isKeptUpdated() {
            return this.autoRebuild;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNextElement() {
            boolean result;
            Object object = this.monitor;
            synchronized (object) {
                result = this.nowCreated ? this.count > 0 : this.current < this.count - 1;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasPreviousElement() {
            boolean result;
            Object object = this.monitor;
            synchronized (object) {
                result = this.nowCreated ? this.count > 0 : this.current > 0;
            }
            return result;
        }

        public int numRecords() {
            return this.count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int nextRecordId() throws InvalidRecordIDException {
            int result;
            boolean error = false;
            Object object = this.monitor;
            synchronized (object) {
                int index = this.toNextRecord();
                if (index < 0) {
                    error = true;
                    result = 0;
                } else {
                    result = this.records[index].getID();
                }
            }
            if (error) {
                throw new InvalidRecordIDException("RecordEnumeration.nextRecordId: \u0432 \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0438\u0441\u0435\u0439.");
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int previousRecordId() throws InvalidRecordIDException {
            int result;
            boolean error = false;
            Object object = this.monitor;
            synchronized (object) {
                int index = this.toPrevRecord();
                if (index < 0) {
                    error = true;
                    result = 0;
                } else {
                    result = this.records[index].getID();
                }
            }
            if (error) {
                throw new InvalidRecordIDException("RecordEnumeration.previousRecordId: \u0432 \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0438\u0441\u0435\u0439.");
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] nextRecord() throws RecordStoreException {
            byte[] result;
            RecordStore store;
            int error = 0;
            Object object = this.monitor;
            synchronized (object) {
                store = RecordStore.this;
                if (store.openedCount == 0) {
                    error = 1;
                    result = null;
                } else {
                    int index = this.toNextRecord();
                    if (index < 0) {
                        error = 2;
                        result = null;
                    } else {
                        byte[] byArray = this.records[index].getData();
                        result = byArray;
                        int len = result.length;
                        result = new byte[len];
                        Array.copy((byte[])byArray, (int)0, (byte[])result, (int)0, (int)len);
                    }
                }
            }
            switch (error) {
                case 1: {
                    throw new RecordStoreNotOpenException(new StringBuilder().append("RecordEnumeration.nextRecord: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(store.name).append(" \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.").toString());
                }
                case 2: {
                    throw new InvalidRecordIDException("RecordEnumeration.nextRecord: \u0432 \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0438\u0441\u0435\u0439.");
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] previousRecord() throws RecordStoreException {
            byte[] result;
            RecordStore store;
            int error = 0;
            Object object = this.monitor;
            synchronized (object) {
                store = RecordStore.this;
                if (store.openedCount == 0) {
                    error = 1;
                    result = null;
                } else {
                    int index = this.toPrevRecord();
                    if (index < 0) {
                        error = 2;
                        result = null;
                    } else {
                        byte[] byArray = this.records[index].getData();
                        result = byArray;
                        int len = result.length;
                        result = new byte[len];
                        Array.copy((byte[])byArray, (int)0, (byte[])result, (int)0, (int)len);
                    }
                }
            }
            switch (error) {
                case 1: {
                    throw new RecordStoreNotOpenException(new StringBuilder().append("RecordEnumeration.previousRecord: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(store.name).append(" \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.").toString());
                }
                case 2: {
                    throw new InvalidRecordIDException("RecordEnumeration.previousRecord: \u0432 \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0438\u0441\u0435\u0439.");
                }
            }
            return result;
        }

        private int toNextRecord() {
            if (this.nowCreated) {
                if (this.count <= 0) {
                    return -1;
                }
                this.nowCreated = false;
                this.current = 0;
                return 0;
            }
            int cur = this.current;
            return cur >= this.count - 1 ? -1 : (this.current = cur + 1);
        }

        private int toPrevRecord() {
            if (this.nowCreated) {
                int cnt = this.count;
                if (cnt <= 0) {
                    return -1;
                }
                this.nowCreated = false;
                this.current = cnt - 1;
                return this.current;
            }
            int cur = this.current;
            return cur <= 0 ? -1 : (this.current = cur - 1);
        }
    }
}

