/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system;

import java.io.IOException;
import malik.emulator.io.cloud.FileOutputStream;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.system.Console;
import malik.emulator.microedition.system.SystemManager;

public class ConsoleOutputStream
extends FileOutputStream {
    private static boolean DOUBLE_OUTPUT = true;
    private int textColor;
    private Console console;

    public static void setDoubleOutput(boolean doubleOutput) {
        DOUBLE_OUTPUT = doubleOutput;
    }

    public static boolean isDoubleOutput() {
        return DOUBLE_OUTPUT;
    }

    public ConsoleOutputStream(String fileName, int textColor) {
        this(fileName, false, textColor);
    }

    public ConsoleOutputStream(String fileName, boolean appending, int textColor) {
        super(fileName, appending);
        this.textColor = textColor & 0xFFFFFF;
    }

    public void write(int byteData) throws IOException {
        Console console;
        if (DOUBLE_OUTPUT && (console = this.getConsole()) != null) {
            console.print(new String(new byte[]{(byte)byteData}), this.textColor);
        }
        super.write(byteData);
    }

    public void write(byte[] src, int offset, int length) throws IOException {
        Console console;
        if (DOUBLE_OUTPUT && (console = this.getConsole()) != null) {
            console.print(new String(src, offset, length), this.textColor);
        }
        super.write(src, offset, length);
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor & 0xFFFFFF;
    }

    public int getTextColor() {
        return this.textColor;
    }

    private Console getConsole() {
        DeviceManager manager;
        Console result = this.console;
        if (result == null && (manager = DeviceManager.getInstance()) instanceof SystemManager) {
            result = this.console = ((SystemManager)manager).console;
        }
        return result;
    }
}

