/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system;

import com.nokia.mid.ui.DirectUtils;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import malik.emulator.fileformats.sound.sampled.wave.WaveEncoder;
import malik.emulator.fileformats.sound.synthetic.SyntheticSoundDecoder;
import malik.emulator.fileformats.sound.synthetic.midi.MIDIEncoder;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.media.CustomPlayer;
import malik.emulator.microedition.system.Console;
import malik.emulator.microedition.system.SearchConsoleCommand;
import malik.emulator.microedition.system.SystemManager;
import malik.emulator.microedition.system.player.SampledPlayer;
import malik.emulator.microedition.system.player.SyntheticPlayer;
import malik.emulator.util.StringBuilder;

final class SoundsSearchConsoleCommand
extends SearchConsoleCommand
implements PlayerListener,
CommandListener,
ItemCommandListener,
ItemStateListener {
    private static final int GLYPH_COLOR = RasterCanvas.getSystemColor((int)36);
    private boolean delay;
    private int current;
    private CustomPlayer[] sounds;
    private Image imagePrev;
    private Image imageNext;
    private Image imagePlay;
    private Image imagePause;
    private Command commandSaveAction;
    private Command commandCancel;
    private Command commandSelect;
    private Command commandSave;
    private Command commandBack;
    private Gauge itemVolumeBar;
    private Gauge itemProgressBar;
    private StringItem itemSoundNum;
    private ImageItem itemSoundPrev;
    private ImageItem itemSoundNext;
    private ImageItem itemSoundPlay;
    private TextField itemFileName;
    private Alert screenProgress;
    private Form screenSounds;
    private Form screenEmpty;
    private Form screenSave;

    public SoundsSearchConsoleCommand(SystemManager manager) {
        super("\u0437\u0432\u0443\u043a\u0438", manager);
    }

    public void playerUpdate(Player player, String event, Object data) {
        Object[] found = this.sounds;
        if (this.sounds != null && this.current == Array.findf((Object[])found, (int)0, (Object)player)) {
            this.updateScreenSounds();
        }
    }

    public void commandAction(Command command, Displayable screen) {
        if (screen == this.screenSounds) {
            if (command == this.commandSave) {
                int index;
                CustomPlayer[] found = this.sounds;
                if (this.sounds != null && (index = this.current) >= 0 && index < found.length) {
                    CustomPlayer player = found[index];
                    if (player instanceof SyntheticPlayer) {
                        this.getItemFileName().setString("/\u0438\u043c\u044f.mid");
                    } else if (player instanceof SampledPlayer) {
                        this.getItemFileName().setString("/\u0438\u043c\u044f.wav");
                    } else {
                        this.getItemFileName().setString("/\u0438\u043c\u044f");
                    }
                }
                DeviceManager.getInstance().getMainDisplay().setCurrent((Displayable)this.getScreenSave());
                return;
            }
            if (command == this.commandBack) {
                CustomPlayer[] found = this.sounds;
                int i = this.sounds == null ? 0 : found.length;
                while (i-- > 0) {
                    CustomPlayer player = found[i];
                    if (player.getState() == 0) continue;
                    try {
                        player.removePlayerListener((PlayerListener)this);
                    }
                    catch (IllegalStateException e) {
                        e.printRealStackTrace();
                    }
                }
                this.sounds = null;
                this.returnToSystem();
            }
            return;
        }
        if (screen == this.screenSave) {
            if (command == this.commandSaveAction) {
                int index;
                CustomPlayer[] found = this.sounds;
                if (this.sounds != null && (index = this.current) >= 0 && index < found.length) {
                    final String fileName = this.getItemFileName().getString();
                    final CustomPlayer player = found[index];
                    new Thread("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0437\u0432\u0443\u043a\u0430"){

                        public void run() {
                            String destFileName = fileName;
                            CustomPlayer destPlayer = player;
                            System.out.println(new StringBuilder().append("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0437\u0432\u0443\u043a\u0430 \u0432 ").append(destFileName).append(" \u2026").toString());
                            try {
                                MIDIEncoder adapter;
                                MIDIEncoder encoder;
                                SyntheticSoundDecoder decoder;
                                if (destPlayer instanceof SyntheticPlayer) {
                                    decoder = ((SyntheticPlayer)destPlayer).getDecoder();
                                    encoder = new MIDIEncoder();
                                    encoder.setMessages(decoder.getMessages());
                                    adapter = encoder;
                                } else if (destPlayer instanceof SampledPlayer) {
                                    decoder = ((SampledPlayer)destPlayer).getDecoder();
                                    encoder = new WaveEncoder();
                                    encoder.setSamples(decoder.getChannels(), decoder.getSamplesPerSecond(), decoder.getSamples());
                                    adapter = encoder;
                                } else {
                                    adapter = null;
                                }
                                FileConnection connection = (FileConnection)Connector.open((String)"file://".concat(destFileName));
                                try {
                                    if (connection.exists()) {
                                        connection.delete();
                                    }
                                    connection.create();
                                    OutputStream stream = connection.openOutputStream();
                                    try {
                                        adapter.saveToOutputStream(stream);
                                    }
                                    finally {
                                        stream.close();
                                    }
                                }
                                finally {
                                    connection.close();
                                }
                                System.out.println(new StringBuilder().append("\u0417\u0432\u0443\u043a \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d \u0432 ").append(destFileName).append('.').toString());
                            }
                            catch (Exception e) {
                                System.out.println(new StringBuilder().append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0437\u0432\u0443\u043a\u0430 \u0432 ").append(destFileName).append('.').toString());
                                e.printRealStackTrace();
                            }
                        }
                    }.start();
                }
            }
            DeviceManager.getInstance().getMainDisplay().setCurrent((Displayable)this.getScreenSounds());
            return;
        }
        if (screen == this.screenProgress && command == this.commandCancel) {
            this.cancelSearchProcess();
            return;
        }
        if (screen == this.screenEmpty && command == this.commandBack) {
            this.returnToSystem();
        }
    }

    public void commandAction(Command command, Item item) {
        int len;
        CustomPlayer[] found = this.sounds;
        if (this.sounds == null || (len = found.length) <= 0) {
            return;
        }
        if (item == this.itemSoundPrev) {
            this.current = this.current == 0 ? len - 1 : this.current - 1;
            this.updateScreenSounds();
            return;
        }
        if (item == this.itemSoundNext) {
            this.current = this.current == len - 1 ? 0 : this.current + 1;
            this.updateScreenSounds();
            return;
        }
        if (item == this.itemSoundPlay) {
            try {
                CustomPlayer player = found[this.current];
                if (player.getState() == 400) {
                    player.stop();
                } else {
                    player.start();
                }
            }
            catch (MediaException e) {
                e.printRealStackTrace();
            }
            this.updateScreenSounds();
        }
    }

    public void itemStateChanged(Item item) {
        Gauge itemGauge = this.itemVolumeBar;
        if (item == itemGauge) {
            int index;
            CustomPlayer[] found = this.sounds;
            if (this.sounds != null && (index = this.current) >= 0 && index < found.length) {
                VolumeControl volume = (VolumeControl)found[index].getControl("VolumeControl");
                volume.setMute(false);
                volume.setLevel(itemGauge.getValue() * 10);
            }
        }
    }

    protected void searchProcess() {
        Object[] memory = Memory.getAllObjects();
        Gauge progress = this.getItemProgressBar();
        Vector<CustomPlayer> players = new Vector<CustomPlayer>();
        int len = memory != null ? memory.length : 0;
        if (len >= 100) {
            progress.setMaxValue(len / 100);
        }
        int i = 0;
        while (i < len) {
            CustomPlayer player;
            int state;
            Object curr;
            if (i % 100 == 0) {
                progress.setValue(i / 100);
                if (this.delay) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printRealStackTrace();
                    }
                }
            }
            if ((curr = memory[i]) != null && (curr instanceof SyntheticPlayer || curr instanceof SampledPlayer) && ((state = (player = (CustomPlayer)curr).getState()) == 400 || state == 300)) {
                players.addElement(player);
            }
            ++i;
        }
        int count = players.size();
        if (count > 0) {
            this.sounds = new CustomPlayer[count];
            players.copyInto(this.sounds);
        }
        progress.setValue(len / 100);
        if (this.delay) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printRealStackTrace();
            }
        }
    }

    protected void showProgressScreen(Display display) {
        Form screen = this.getScreenEmpty();
        screen.setTitle("\u041b\u044e\u0431\u0438\u0442\u0435 \u043a\u0440\u0430\u0441\u0438\u0442\u044c \u043f\u0430\u0441\u0445\u0430\u043b\u044c\u043d\u044b\u0435 \u044f\u0439\u0446\u0430?");
        display.setCurrent(this.getScreenProgress(), (Displayable)screen);
    }

    protected void showFoundScreen(Display display) {
        Form screen;
        int count;
        this.current = 0;
        CustomPlayer[] found = this.sounds;
        if (this.sounds == null || (count = found.length) <= 0) {
            screen = this.getScreenEmpty();
        } else {
            int i = count;
            while (i-- > 0) {
                CustomPlayer player = found[i];
                if (player.getState() == 0) continue;
                try {
                    player.addPlayerListener((PlayerListener)this);
                }
                catch (IllegalStateException e) {
                    e.printRealStackTrace();
                }
            }
            this.updateScreenSounds();
            screen = this.getScreenSounds();
        }
        screen.setTitle("\u0417\u0432\u0443\u043a\u0438");
        display.setCurrent((Displayable)screen);
    }

    protected void execute(String[] arguments, Console console) {
        this.delay = true;
        super.execute(arguments, console);
    }

    protected void executeInBackground() {
        this.delay = false;
        super.executeInBackground();
    }

    private void updateScreenSounds() {
        int len;
        int index;
        CustomPlayer[] found = this.sounds;
        if (this.sounds != null && (index = this.current) >= 0 && index < (len = found.length)) {
            CustomPlayer player = found[index];
            try {
                VolumeControl volume = (VolumeControl)player.getControl("VolumeControl");
                this.getItemVolumeBar().setValue(volume.isMuted() ? 0 : volume.getLevel() / 10);
            }
            catch (Exception exception) {
                this.getItemVolumeBar().setValue(0);
            }
            this.getItemSoundPlay().setImage(player.getState() == 400 ? this.getImagePause() : this.getImagePlay());
            this.getItemSoundNum().setText(new StringBuilder().append(' ').append(index + 1).append(" / ").append(len).toString());
        }
    }

    private Image getImagePrev() {
        Image result = this.imagePrev;
        if (result == null) {
            result = this.imagePrev = DirectUtils.createImage((int)24, (int)24, (int)0);
            Graphics render = this.imagePrev.getGraphics();
            render.setColor(GLYPH_COLOR);
            render.fillTriangle(19, 1, 9, 11, 19, 21);
            render.fillRect(4, 1, 5, 21);
        }
        return result;
    }

    private Image getImageNext() {
        Image result = this.imageNext;
        if (result == null) {
            result = this.imageNext = DirectUtils.createImage((int)24, (int)24, (int)0);
            Graphics render = this.imageNext.getGraphics();
            render.setColor(GLYPH_COLOR);
            render.fillTriangle(4, 1, 14, 11, 4, 21);
            render.fillRect(15, 1, 5, 21);
        }
        return result;
    }

    private Image getImagePlay() {
        Image result = this.imagePlay;
        if (result == null) {
            result = this.imagePlay = DirectUtils.createImage((int)24, (int)24, (int)0);
            Graphics render = this.imagePlay.getGraphics();
            render.setColor(GLYPH_COLOR);
            render.fillTriangle(1, 1, 21, 11, 1, 21);
        }
        return result;
    }

    private Image getImagePause() {
        Image result = this.imagePause;
        if (result == null) {
            result = this.imagePause = DirectUtils.createImage((int)24, (int)24, (int)0);
            Graphics render = this.imagePause.getGraphics();
            render.setColor(GLYPH_COLOR);
            render.fillRect(5, 1, 5, 21);
            render.fillRect(14, 1, 5, 21);
        }
        return result;
    }

    private Command getCommandSaveAction() {
        Command result = this.commandSaveAction;
        if (result == null) {
            result = this.commandSaveAction = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", 4, 0);
        }
        return result;
    }

    private Command getCommandCancel() {
        Command result = this.commandCancel;
        if (result == null) {
            result = this.commandCancel = new Command("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c", 3, 0);
        }
        return result;
    }

    private Command getCommandSelect() {
        Command result = this.commandSelect;
        if (result == null) {
            result = this.commandSelect = new Command("\u0412\u044b\u0431\u0440\u0430\u0442\u044c", 4, 0);
        }
        return result;
    }

    private Command getCommandSave() {
        Command result = this.commandSave;
        if (result == null) {
            result = this.commandSave = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c\u2026", 1, 0);
        }
        return result;
    }

    private Command getCommandBack() {
        Command result = this.commandBack;
        if (result == null) {
            result = this.commandBack = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 0);
        }
        return result;
    }

    private Gauge getItemVolumeBar() {
        Gauge result = this.itemVolumeBar;
        if (result == null) {
            result = this.itemVolumeBar = new Gauge("\u0413\u0440\u043e\u043c\u043a\u043e\u0441\u0442\u044c", true, 10, 0);
        }
        return result;
    }

    private Gauge getItemProgressBar() {
        Gauge result = this.itemProgressBar;
        if (result == null) {
            result = this.itemProgressBar = new Gauge(null, false, 1, 0);
        }
        return result;
    }

    private StringItem getItemSoundNum() {
        StringItem result = this.itemSoundNum;
        if (result == null) {
            result = this.itemSoundNum = new StringItem(null, " ");
            this.itemSoundNum.setLayout(2049);
        }
        return result;
    }

    private ImageItem getItemSoundPrev() {
        ImageItem result = this.itemSoundPrev;
        if (result == null) {
            result = this.itemSoundPrev = new ImageItem(null, this.getImagePrev(), 2048, null, 2);
            this.itemSoundPrev.setItemCommandListener((ItemCommandListener)this);
            result.setDefaultCommand(this.getCommandSelect());
        }
        return result;
    }

    private ImageItem getItemSoundNext() {
        ImageItem result = this.itemSoundNext;
        if (result == null) {
            result = this.itemSoundNext = new ImageItem(null, this.getImageNext(), 2048, null, 2);
            this.itemSoundNext.setItemCommandListener((ItemCommandListener)this);
            result.setDefaultCommand(this.getCommandSelect());
        }
        return result;
    }

    private ImageItem getItemSoundPlay() {
        ImageItem result = this.itemSoundPlay;
        if (result == null) {
            result = this.itemSoundPlay = new ImageItem(null, this.getImagePlay(), 2048, null, 2);
            this.itemSoundPlay.setItemCommandListener((ItemCommandListener)this);
            result.setDefaultCommand(this.getCommandSelect());
        }
        return result;
    }

    private TextField getItemFileName() {
        TextField result = this.itemFileName;
        if (result == null) {
            result = this.itemFileName = new TextField("\u0418\u043c\u044f \u0444\u0430\u0439\u043b\u0430", null, 128, 0);
            this.itemFileName.setLayout(2048);
        }
        return result;
    }

    private Alert getScreenProgress() {
        Alert result = this.screenProgress;
        if (result == null) {
            result = this.screenProgress = new Alert(null, "\u041f\u043e\u0438\u0441\u043a \u0437\u0432\u0443\u043a\u043e\u0432 \u0432 \u043f\u0430\u043c\u044f\u0442\u0438\u2026", null, AlertType.INFO);
            this.screenProgress.setCommandListener((CommandListener)this);
            result.addCommand(this.getCommandCancel());
            result.setIndicator(this.getItemProgressBar());
        }
        return result;
    }

    private Form getScreenSounds() {
        Form result = this.screenSounds;
        if (result == null) {
            ImageItem soundIcon = new ImageItem(null, SystemManager.loadImageFromFile("/ui/audio.png"), 771, null);
            result = this.screenSounds = new Form(null, new Item[]{this.getItemSoundNum(), soundIcon, this.getItemVolumeBar(), this.getItemSoundPrev(), this.getItemSoundPlay(), this.getItemSoundNext()}){

                protected void sizeChanged(int width, int height) {
                    this.get(1).setPreferredSize(-1, height - this.get(0).getPreferredHeight() - this.get(2).getPreferredHeight() - this.get(3).getPreferredHeight());
                }
            };
            this.screenSounds.setCommandListener((CommandListener)this);
            result.setItemStateListener((ItemStateListener)this);
            result.addCommand(this.getCommandBack());
            result.addCommand(this.getCommandSave());
            result.getHorizontalScrollBar().hide();
        }
        return result;
    }

    private Form getScreenEmpty() {
        Form result = this.screenEmpty;
        if (result == null) {
            String text = "(\u043d\u0435\u0442 \u0437\u0432\u0443\u043a\u043e\u0432)";
            StringItem empty = new StringItem(null, "(\u043d\u0435\u0442 \u0437\u0432\u0443\u043a\u043e\u0432)");
            empty.setLayout(3);
            Font font = Font.getFont((int)0, (int)1, (int)8);
            empty.setFont(font);
            empty.setPreferredSize(font.stringWidth(text), -1);
            result = this.screenEmpty = new Form(null, new Item[]{empty});
            this.screenEmpty.setCommandListener((CommandListener)this);
            result.addCommand(this.getCommandBack());
            result.getHorizontalScrollBar().hide();
        }
        return result;
    }

    private Form getScreenSave() {
        Form result = this.screenSave;
        if (result == null) {
            result = this.screenSave = new Form("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", new Item[]{this.getItemFileName()});
            this.screenSave.setCommandListener((CommandListener)this);
            result.addCommand(this.getCommandSaveAction());
            result.addCommand(this.getCommandBack());
            result.getHorizontalScrollBar().hide();
        }
        return result;
    }
}

