/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system.protocol.sms;

import java.util.Date;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;

public abstract class ShortMessage
implements Message {
    public static final long EMPTY_TIMESTAMP = Long.MIN_VALUE;
    private final boolean inbound;
    long timestamp;
    String senderAddress;
    String recipientAddress;
    final MessageConnection creator;

    public ShortMessage(MessageConnection creator, boolean inbound, String senderAddress, String recipientAddress, long timestamp) {
        this.inbound = inbound;
        this.timestamp = timestamp;
        this.senderAddress = senderAddress;
        this.recipientAddress = recipientAddress;
        this.creator = creator;
    }

    public abstract int getLength();

    public abstract ShortMessage createInboundCopy();

    public void setAddress(String address) {
        if (this.inbound) {
            this.senderAddress = address;
            return;
        }
        this.recipientAddress = address;
    }

    public String getAddress() {
        return this.inbound ? this.senderAddress : this.recipientAddress;
    }

    public Date getTimestamp() {
        long timestamp = this.timestamp;
        return timestamp == Long.MIN_VALUE ? null : new Date(timestamp);
    }

    public void setTimestampAsLong(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimestampAsLong() {
        return this.timestamp;
    }

    public final boolean isInbound() {
        return this.inbound;
    }

    public final String getSenderAddress() {
        return this.senderAddress;
    }

    public final String getRecipientAddress() {
        return this.recipientAddress;
    }

    public final MessageConnection getCreator() {
        return this.creator;
    }
}

