/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.compression.zlib;

import malik.emulator.compression.zlib.Deflate;
import malik.emulator.compression.zlib.StaticTree;
import malik.emulator.compression.zlib.Zlib;

final class Tree
extends Zlib {
    private static final int MAX_BITS = 15;
    private static final int LITERALS = 256;
    private static final int LENGTH_CODES = 29;
    private static final int L_CODES = 286;
    private static final int HEAP_SIZE = 573;
    public int maxCode;
    public int[] dynTree;
    public StaticTree statDesc;

    private static void genCodes(int[] tree, int maxCode, int[] blCount) {
        int[] nextCode = new int[16];
        int code = 0;
        int bits = 1;
        while (bits <= 15) {
            short s = (short)(code + blCount[bits - 1] << 1);
            code = s;
            nextCode[bits] = s;
            ++bits;
        }
        int n = 0;
        while (n <= maxCode) {
            int len = tree[n * 2 + 1];
            if (len != 0) {
                int n2 = len;
                int n3 = nextCode[n2];
                nextCode[n2] = n3 + 1;
                tree[n * 2] = (short)Tree.biReverse(n3, len);
            }
            ++n;
        }
    }

    private static int biReverse(int code, int len) {
        int res = 0;
        do {
            res |= code & 1;
            code >>>= 1;
            res <<= 1;
        } while (--len > 0);
        return res >>> 1;
    }

    Tree() {
    }

    public void buildTree(Deflate s) {
        int node;
        int elems = this.statDesc.elems;
        int maxCodeLocal = -1;
        int[] tree = this.dynTree;
        int[] stree = this.statDesc.staticTree;
        s.heapLen = 0;
        s.heapMax = 573;
        int n = 0;
        while (n < elems) {
            if (tree[n * 2] != 0) {
                s.heap[++s.heapLen] = maxCodeLocal = n;
                s.depth[n] = 0;
            } else {
                tree[n * 2 + 1] = 0;
            }
            ++n;
        }
        while (s.heapLen < 2) {
            int n2 = maxCodeLocal < 2 ? ++maxCodeLocal : 0;
            s.heap[++s.heapLen] = n2;
            node = n2;
            tree[node * 2] = 1;
            s.depth[node] = 0;
            --s.optLen;
            if (stree == null) continue;
            s.staticLen -= stree[node * 2 + 1];
        }
        this.maxCode = maxCodeLocal;
        n = s.heapLen / 2;
        while (n >= 1) {
            s.pqDownHeap(tree, n);
            --n;
        }
        node = elems;
        do {
            n = s.heap[1];
            s.heap[1] = s.heap[s.heapLen--];
            s.pqDownHeap(tree, 1);
            int m = s.heap[1];
            s.heap[--s.heapMax] = n;
            s.heap[--s.heapMax] = m;
            tree[node * 2] = (short)(tree[n * 2] + tree[m * 2]);
            s.depth[node] = (byte)(Math.max(s.depth[n], s.depth[m]) + 1);
            short s2 = (short)node;
            tree[m * 2 + 1] = s2;
            tree[n * 2 + 1] = s2;
            s.heap[1] = node++;
            s.pqDownHeap(tree, 1);
        } while (s.heapLen >= 2);
        s.heap[--s.heapMax] = s.heap[1];
        this.genBitlen(s);
        Tree.genCodes(tree, maxCodeLocal, s.blCount);
    }

    private void genBitlen(Deflate s) {
        int n;
        int base = this.statDesc.extraBase;
        int maxLength = this.statDesc.maxLength;
        int overflow = 0;
        int[] tree = this.dynTree;
        int[] stree = this.statDesc.staticTree;
        int[] extra = this.statDesc.extraBits;
        int bits = 0;
        while (bits <= 15) {
            s.blCount[bits] = 0;
            ++bits;
        }
        tree[s.heap[s.heapMax] * 2 + 1] = 0;
        int h = s.heapMax + 1;
        while (h < 573) {
            n = s.heap[h];
            bits = tree[tree[n * 2 + 1] * 2 + 1] + 1;
            if (bits > maxLength) {
                bits = maxLength;
                ++overflow;
            }
            tree[n * 2 + 1] = (short)bits;
            if (n <= this.maxCode) {
                int n2 = bits;
                s.blCount[n2] = s.blCount[n2] + 1;
                int xbits = 0;
                if (n >= base) {
                    xbits = extra[n - base];
                }
                int f = tree[n * 2];
                s.optLen += f * (bits + xbits);
                if (stree != null) {
                    s.staticLen += f * (stree[n * 2 + 1] + xbits);
                }
            }
            ++h;
        }
        if (overflow == 0) {
            return;
        }
        do {
            bits = maxLength - 1;
            while (s.blCount[bits] == 0) {
                --bits;
            }
            int n3 = bits;
            s.blCount[n3] = s.blCount[n3] - 1;
            int n4 = bits + 1;
            s.blCount[n4] = s.blCount[n4] + 2;
            int n5 = maxLength;
            s.blCount[n5] = s.blCount[n5] - 1;
        } while ((overflow -= 2) > 0);
        bits = maxLength;
        while (bits != 0) {
            n = s.blCount[bits];
            while (n != 0) {
                int m;
                if ((m = s.heap[--h]) > this.maxCode) continue;
                if (tree[m * 2 + 1] != bits) {
                    s.optLen = (int)((long)s.optLen + ((long)bits - (long)tree[m * 2 + 1]) * (long)tree[m * 2]);
                    tree[m * 2 + 1] = (short)bits;
                }
                --n;
            }
            --bits;
        }
    }
}

