/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.sound.synthetic.midilib;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import malik.emulator.fileformats.DataEncoder;
import malik.emulator.fileformats.DataHolder;
import malik.emulator.fileformats.EmptyAdapterException;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.OutputAdapter;
import malik.emulator.fileformats.sound.SoundEncoder;
import malik.emulator.fileformats.sound.synthetic.SoundEncoderSynthetic;

public final class MIDIEncoder
implements OutputAdapter,
SoundEncoder,
DataHolder,
DataEncoder,
SoundEncoderSynthetic {
    public static final long MIDI_SIGNATURE = 5572193417670164486L;
    private static final int MTRK_SIGNATURE = 1297379947;
    private static final int PPQN = 100;
    private static final int TEMPO = 100000;
    private long[] messages;

    public void saveToOutputStream(OutputStream stream) throws IOException, EmptyAdapterException {
        this.saveToDataStream(new DataOutputStream(stream));
    }

    public void saveToDataStream(DataOutputStream stream) throws IOException, EmptyAdapterException {
        int dataByte2;
        int statusByte;
        int shortMsg;
        long message;
        long[] messages = this.messages;
        if (this.messages == null) {
            throw new EmptyAdapterException("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 MIDI-\u0444\u0430\u0439\u043b\u043e\u0432: \u0430\u0434\u0430\u043f\u0442\u0435\u0440 \u043f\u0443\u0441\u0442.");
        }
        Track track = new Track();
        track.writeVolatileLengthValue(0);
        track.write(255);
        track.write(81);
        track.write(3);
        track.write(1);
        track.write(-122);
        track.write(-96);
        boolean completed = false;
        int maxNoteVolume = 1;
        int len = messages.length;
        int i = 0;
        while (i < len) {
            message = messages[i];
            shortMsg = (int)message & 0xFFFFFF;
            statusByte = shortMsg >> 16;
            if (statusByte >= 144 && statusByte < 160 && maxNoteVolume < (dataByte2 = shortMsg & 0xFF)) {
                maxNoteVolume = dataByte2;
            }
            ++i;
        }
        long prevTime = 0L;
        int prevStatusByte = 0;
        i = 0;
        while (i < len) {
            block9: {
                int deltaTime;
                block7: {
                    block8: {
                        message = messages[i];
                        long currTime = message >> 24;
                        shortMsg = (int)message & 0xFFFFFF;
                        statusByte = shortMsg >> 16;
                        int dataByte1 = shortMsg >> 8 & 0xFF;
                        dataByte2 = shortMsg & 0xFF;
                        deltaTime = (int)(currTime - prevTime);
                        if (statusByte < 128 || statusByte >= 240) break block7;
                        prevTime = currTime;
                        track.writeVolatileLengthValue(deltaTime);
                        if (statusByte != prevStatusByte || dataByte1 >= 128) {
                            prevStatusByte = statusByte;
                            track.write(prevStatusByte);
                        }
                        track.write(dataByte1);
                        if (statusByte < 144 || statusByte >= 160) break block8;
                        track.write(dataByte2 * 127 / maxNoteVolume);
                        break block9;
                    }
                    if (statusByte >= 192 && statusByte < 224) break block9;
                    track.write(dataByte2);
                    break block9;
                }
                if (shortMsg == 0xFF2F00) {
                    completed = true;
                    track.writeVolatileLengthValue(deltaTime);
                    track.write(255);
                    track.write(47);
                    track.write(0);
                    break;
                }
            }
            ++i;
        }
        if (!completed) {
            track.writeVolatileLengthValue(0);
            track.write(255);
            track.write(47);
            track.write(0);
        }
        stream.writeLong(5572193417670164486L);
        stream.writeShort(0);
        stream.writeShort(1);
        stream.writeShort(100);
        stream.writeInt(1297379947);
        byte[] trackBytes = track.toByteArray();
        stream.writeInt(trackBytes.length);
        stream.write(trackBytes);
    }

    public void clear() {
        this.messages = null;
    }

    public boolean isEmpty() {
        return this.messages == null;
    }

    public void setMessages(long[] messages) throws InvalidDataFormatException {
        if (messages == null) {
            throw new InvalidDataFormatException("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 MIDI-\u0444\u0430\u0439\u043b\u043e\u0432: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 messages \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.messages = messages;
    }

    private static final class Track
    extends ByteArrayOutputStream {
        Track() {
        }

        public void writeVolatileLengthValue(int value) {
            if (value >= 0 && value < 128) {
                this.write(value);
                return;
            }
            if (value >= 128 && value < 16384) {
                this.write(value >> 7 | 0x80);
                this.write(value & 0x7F);
                return;
            }
            if (value >= 16384 && value < 0x200000) {
                this.write(value >> 14 | 0x80);
                this.write(value >> 7 | 0x80);
                this.write(value & 0x7F);
                return;
            }
            if (value >= 0x200000 && value < 0x10000000) {
                this.write(value >> 21 | 0x80);
                this.write(value >> 14 | 0x80);
                this.write(value >> 7 | 0x80);
                this.write(value & 0x7F);
                return;
            }
            this.write(0);
        }
    }
}

