/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.ScrollBar;
import javax.microedition.lcdui.ScrollBarPaintHelper;
import javax.microedition.lcdui.ScrollBarStyle;

public class ScrollBarDefault
implements ScrollBarStyle {
    private static final int DEFAULT_SIZE = 11;
    private static final int TRACK_MARGIN_FROM_ENDS = 1;
    private static final int TRACK_MARGIN_FROM_EDGE = 3;
    private static final int SLIDER_MARGIN_FROM_EDGE = 2;
    private static final int SLIDER_MINIMAL_LENGTH = 7;
    private static final int[] TRACK_COLORS = new int[]{6316191, 0x7A7AAF, 9803199, 0xAFAFCF};
    private static final int[] SLIDER_MARGINS_COLORS = new int[]{0x2FFFFFF, 0x1F3F3F3, 0xE7E7E7, 0xDBDBDB, 0xCFCFCF, 0x1C3C3C3, 0x2B7B7B7};
    private int prev;

    public void paintHorzScrollBar(Graphics render, ScrollBar scrollbar, int length, int width) {
        int page;
        render.translate(0, (width - 11) / 2);
        render.clipRect(0, 0, length, 11);
        int a = 1;
        int b = length - (1 + 1);
        int i = TRACK_COLORS.length;
        int j = i + 3;
        while (i-- > 0) {
            render.setColor(TRACK_COLORS[i]);
            render.drawLine(a, --j, b, j);
        }
        int range = scrollbar.getRange();
        if (range <= 0 || (page = scrollbar.getPage()) <= 0 || range <= page) {
            return;
        }
        b = ScrollBarPaintHelper.getSliderLength(page, range, length, 7);
        a = ScrollBarPaintHelper.getSliderPosition(scrollbar.getPosition(), page, range, length, b);
        b = a + b - 1;
        i = SLIDER_MARGINS_COLORS.length;
        j = i + 2;
        while (i-- > 0) {
            int c = SLIDER_MARGINS_COLORS[i];
            render.setColor(c);
            render.drawLine(a + (c >>= 24), --j, b - c, j);
        }
    }

    public void paintVertScrollBar(Graphics render, ScrollBar scrollbar, int length, int width) {
        int page;
        render.translate((width - 11) / 2, 0);
        render.clipRect(0, 0, 11, length);
        int a = 1;
        int b = length - (1 + 1);
        int i = TRACK_COLORS.length;
        int j = i + 3;
        while (i-- > 0) {
            render.setColor(TRACK_COLORS[i]);
            render.drawLine(--j, a, j, b);
        }
        int range = scrollbar.getRange();
        if (range <= 0 || (page = scrollbar.getPage()) <= 0 || range <= page) {
            return;
        }
        b = ScrollBarPaintHelper.getSliderLength(page, range, length, 7);
        a = ScrollBarPaintHelper.getSliderPosition(scrollbar.getPosition(), page, range, length, b);
        b = a + b - 1;
        i = SLIDER_MARGINS_COLORS.length;
        j = i + 2;
        while (i-- > 0) {
            int c = SLIDER_MARGINS_COLORS[i];
            render.setColor(c);
            render.drawLine(--j, a + (c >>= 24), j, b - c);
        }
    }

    public void onHorzScrollBarPointerPressed(ScrollBar scrollbar, int length, int width, int x, int y, int button) {
        int page;
        int range = scrollbar.getRange();
        if (range <= 0 || (page = scrollbar.getPage()) <= 0 || range <= page) {
            this.prev = Integer.MAX_VALUE;
            return;
        }
        int b = ScrollBarPaintHelper.getSliderLength(page, range, length, 7);
        int a = ScrollBarPaintHelper.getSliderPosition(scrollbar.getPosition(), page, range, length, b);
        b = a + b;
        if (x < a) {
            this.prev = Integer.MAX_VALUE;
            scrollbar.scroll(-page);
            return;
        }
        if (x >= b) {
            this.prev = Integer.MAX_VALUE;
            scrollbar.scroll(page);
            return;
        }
        this.prev = x;
    }

    public void onHorzScrollBarPointerDragged(ScrollBar scrollbar, int length, int width, int x, int y) {
        int p;
        int page;
        int range = scrollbar.getRange();
        if (range <= 0 || (page = scrollbar.getPage()) <= 0 || range <= page || (p = this.prev) == Integer.MAX_VALUE) {
            return;
        }
        scrollbar.scroll((int)((double)(x - p) * (double)range / (double)length));
        this.prev = x;
    }

    public void onHorzScrollBarPointerReleased(ScrollBar scrollbar, int length, int width, int x, int y, int button) {
        int p;
        int page;
        int range = scrollbar.getRange();
        if (range <= 0 || (page = scrollbar.getPage()) <= 0 || range <= page || (p = this.prev) == Integer.MAX_VALUE) {
            return;
        }
        scrollbar.scroll((int)((double)(x - p) * (double)range / (double)length));
    }

    public void onVertScrollBarPointerPressed(ScrollBar scrollbar, int length, int width, int x, int y, int button) {
        int page;
        int range = scrollbar.getRange();
        if (range <= 0 || (page = scrollbar.getPage()) <= 0 || range <= page) {
            this.prev = Integer.MAX_VALUE;
            return;
        }
        int b = ScrollBarPaintHelper.getSliderLength(page, range, length, 7);
        int a = ScrollBarPaintHelper.getSliderPosition(scrollbar.getPosition(), page, range, length, b);
        b = a + b;
        if (y < a) {
            this.prev = Integer.MAX_VALUE;
            scrollbar.scroll(-page);
            return;
        }
        if (y >= b) {
            this.prev = Integer.MAX_VALUE;
            scrollbar.scroll(page);
            return;
        }
        this.prev = y;
    }

    public void onVertScrollBarPointerDragged(ScrollBar scrollbar, int length, int width, int x, int y) {
        int p;
        int page;
        int range = scrollbar.getRange();
        if (range <= 0 || (page = scrollbar.getPage()) <= 0 || range <= page || (p = this.prev) == Integer.MAX_VALUE) {
            return;
        }
        scrollbar.scroll((int)((double)(y - p) * (double)range / (double)length));
        this.prev = y;
    }

    public void onVertScrollBarPointerReleased(ScrollBar scrollbar, int length, int width, int x, int y, int button) {
        int p;
        int page;
        int range = scrollbar.getRange();
        if (range <= 0 || (page = scrollbar.getPage()) <= 0 || range <= page || (p = this.prev) == Integer.MAX_VALUE) {
            return;
        }
        scrollbar.scroll((int)((double)(y - p) * (double)range / (double)length));
    }

    public int getHorzScrollBarWidth() {
        return 11;
    }

    public int getVertScrollBarWidth() {
        return 11;
    }
}

