/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.lang.ref.WeakReference;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Input;
import javax.microedition.lcdui.ScrollBar;
import javax.microedition.lcdui.ScrollBarStyle;
import javax.microedition.lcdui.ScrollBarSystem;
import javax.microedition.lcdui.ScrollingScreen;
import javax.microedition.lcdui.TextInput;
import javax.microedition.lcdui.Ticker;
import malik.emulator.io.j2me.input.CharDestination;
import malik.emulator.media.graphics.RasterCanvas;

public class TextBox
extends ScrollingScreen
implements Input {
    private Font font;
    private TextInput input;
    private ScrollBarStyle systemStyle;
    private CommandListener capabilities;

    public TextBox(String title, String text, int maxLength, int constraints) {
        this(false, false, title, null, null, null, null, text, maxLength, constraints);
    }

    public TextBox(boolean fullScreenMode, String title, Ticker ticker, Command[] commands, Command defaultCommand, CommandListener listener, String text, int maxLength, int constraints) {
        this(true, fullScreenMode, title, ticker, commands, defaultCommand, listener, text, maxLength, constraints);
    }

    private TextBox(boolean system, boolean fullScreenMode, String title, Ticker ticker, Command[] commands, Command defaultCommand, CommandListener listener, String text, int maxLength, int constraints) {
        super(system, fullScreenMode, title, ticker, Displayable.concatCommands(commands, TextInput.getAdditionalCapabilitiesCommands(constraints, true)), defaultCommand, listener, 2);
        TextInput input;
        Font font;
        int charArrayLength = 16384;
        this.font = font = Font.getFont(1);
        this.input = input = new TextInput(text, maxLength, constraints, charArrayLength);
        this.systemStyle = new ScrollBarSystem(font.getHeight());
        TextInput textInput = input;
        textInput.getClass();
        this.capabilities = textInput.new TextInput.AdditionalCapabilities(new Destination(this));
        this.updateView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String src, int position) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.insert(src, position);
            if (src.length() > 0) {
                this.updateView();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(char[] src, int offset, int length, int position) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.insert(src, offset, length, position);
            if (length > 0) {
                this.updateView();
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int offset, int length) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.delete(offset, length);
            if (length > 0) {
                this.updateView();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String src) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.setString(src);
            this.updateView();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChars(char[] src, int offset, int length) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.setChars(src, offset, length);
            this.updateView();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConstraints(int constraints) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            int oldConstraints = input.getConstraints();
            if (oldConstraints != constraints) {
                input.setConstraints(constraints);
                this.removeCommands(TextInput.getAdditionalCapabilitiesCommands(oldConstraints, true));
                this.addCommands(TextInput.getAdditionalCapabilitiesCommands(constraints, true));
                this.updateView();
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    public void setInitialInputMode(String characterSubset) {
        this.input.setInitialInputMode(characterSubset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setMaxSize(int maxLength) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            int result;
            if (input.getMaxSize() != maxLength) {
                result = input.setMaxSize(maxLength);
                this.updateView();
            } else {
                result = maxLength;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return result;
        }
    }

    public int size() {
        return this.input.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChars(char[] dst) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            int result = input.getChars(dst);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return result;
        }
    }

    public int getConstraints() {
        return this.input.getConstraints();
    }

    public int getCaretPosition() {
        return this.input.getCaretPosition();
    }

    public int getMaxSize() {
        return this.input.getMaxSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            String result = input.getString();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics render, ScrollBar horzScrollBar, ScrollBar vertScrollBar) {
        TextInput input;
        int top = vertScrollBar.getPosition();
        int bottom = top + vertScrollBar.getPage();
        Font font = this.font;
        int lineHeight = font.getHeight();
        int topMarginElement = 0;
        render.setFont(font);
        TextInput textInput = input = this.input;
        synchronized (input) {
            render.setColor(RasterCanvas.getSystemColor((int)((input.getConstraints() & 0x20000) != 0 ? 35 : 33)));
            int caretPosition = input.getCaretPosition();
            int caretLine = input.getLineAt(caretPosition);
            caretPosition -= input.getLineStart(caretLine);
            char[] text = input.getChars();
            int len = input.getLinesCount();
            int i = 0;
            while (i < len) {
                if (topMarginElement < bottom && topMarginElement + lineHeight > top) {
                    int s = input.getLineStart(i);
                    render.drawChars(text, s, input.getLineLength(i), 1, 0, 20);
                    if (i == caretLine) {
                        s = font.charsWidth(text, s, caretPosition);
                        render.drawLine(s, 0, s, lineHeight - 1);
                    }
                }
                render.translate(0, lineHeight);
                topMarginElement += lineHeight;
                ++i;
            }
            // ** MonitorExit[var16_10] (shouldn't be in output)
            return;
        }
    }

    void paintClient(Graphics render, int width, int height, int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        render.drawElementOfGUI(8, (this.input.getConstraints() & 0x20000) != 0 ? 3 : 1, 0, 0, 0, render.getClipWidth(), render.getClipHeight());
        Graphics clientRender = this.getClientContext();
        clientRender.reset();
        clientRender.translate(this.getClientLeft(), this.getClientTop());
        clientRender.setClip(0, 0, this.getClientWidth(), this.getClientHeight());
        this.paint(clientRender);
    }

    void paintVertScrollBar(Graphics clientRender, ScrollBar scrollbar, int length, int width) {
        this.systemStyle.paintVertScrollBar(clientRender, scrollbar, length, width);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onKeyPressed(int key, int charCode) {
        switch (key) {
            default: {
                if (charCode <= 0) break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 160: 
            case 161: {
                TextInput input;
                TextInput textInput = input = this.input;
                synchronized (input) {
                    input.keyPressed(key, charCode);
                    if (input.isChanged()) {
                        this.updateView();
                        this.correctScrollBarPositionToLine();
                    }
                    // ** MonitorExit[var4_8] (shouldn't be in output)
                    return;
                }
            }
            case 37: {
                TextInput input;
                TextInput textInput = input = this.input;
                synchronized (input) {
                    input.setCaretPosition(input.getCaretPosition() - 1);
                    this.correctScrollBarPositionToLine();
                    // ** MonitorExit[var4_9] (shouldn't be in output)
                    return;
                }
            }
            case 39: {
                TextInput input;
                TextInput textInput = input = this.input;
                synchronized (input) {
                    input.setCaretPosition(input.getCaretPosition() + 1);
                    this.correctScrollBarPositionToLine();
                    // ** MonitorExit[var4_10] (shouldn't be in output)
                    return;
                }
            }
            case 38: {
                TextInput input;
                TextInput textInput = input = this.input;
                synchronized (input) {
                    this.moveCaretUp();
                    this.correctScrollBarPositionToLine();
                    // ** MonitorExit[var4_11] (shouldn't be in output)
                    return;
                }
            }
            case 40: {
                TextInput input;
                TextInput textInput = input = this.input;
                synchronized (input) {
                    this.moveCaretDown();
                    this.correctScrollBarPositionToLine();
                    // ** MonitorExit[var4_12] (shouldn't be in output)
                    return;
                }
            }
        }
        super.onKeyPressed(key, charCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onKeyRepeated(int key, int charCode) {
        switch (key) {
            default: {
                if (charCode <= 0) break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 160: 
            case 161: {
                TextInput input;
                TextInput textInput = input = this.input;
                synchronized (input) {
                    input.keyPressed(key, charCode);
                    if (input.isChanged()) {
                        this.updateView();
                        this.correctScrollBarPositionToLine();
                    }
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    return;
                }
            }
            case 37: {
                TextInput input;
                TextInput textInput = input = this.input;
                synchronized (input) {
                    input.setCaretPosition(input.getCaretPosition() - 1);
                    // ** MonitorExit[var4_7] (shouldn't be in output)
                    this.correctScrollBarPositionToLine();
                    return;
                }
            }
            case 39: {
                TextInput input;
                TextInput textInput = input = this.input;
                synchronized (input) {
                    input.setCaretPosition(input.getCaretPosition() + 1);
                    // ** MonitorExit[var4_8] (shouldn't be in output)
                    this.correctScrollBarPositionToLine();
                    return;
                }
            }
            case 38: {
                TextInput textInput = this.input;
                synchronized (textInput) {
                    this.moveCaretUp();
                    this.correctScrollBarPositionToLine();
                }
                return;
            }
            case 40: {
                TextInput textInput = this.input;
                synchronized (textInput) {
                    this.moveCaretDown();
                    this.correctScrollBarPositionToLine();
                }
                return;
            }
        }
        super.onKeyRepeated(key, charCode);
    }

    void onKeyReleased(int key) {
        switch (key) {
            case 16: 
            case 160: 
            case 161: {
                this.input.keyReleased(key);
                return;
            }
        }
        super.onKeyReleased(key);
    }

    void onClientPointerPressed(int x, int y, int button) {
        this.pointerHandle(x, y);
    }

    void onClientPointerDragged(int x, int y) {
        this.pointerHandle(x, y);
    }

    void onClientPointerReleased(int x, int y, int button) {
        this.pointerHandle(x, y);
    }

    void onCommandAction(Command command) {
        if (TextInput.isAdditionalCapabilitiesCommand(command)) {
            this.capabilities.commandAction(command, this);
            return;
        }
        super.onCommandAction(command);
    }

    void onVertScrollBarPointerPressed(ScrollBar scrollbar, int length, int width, int x, int y, int button) {
        this.systemStyle.onVertScrollBarPointerPressed(scrollbar, length, width, x, y, button);
    }

    void onVertScrollBarPointerDragged(ScrollBar scrollbar, int length, int width, int x, int y) {
        this.systemStyle.onVertScrollBarPointerDragged(scrollbar, length, width, x, y);
    }

    void onVertScrollBarPointerReleased(ScrollBar scrollbar, int length, int width, int x, int y, int button) {
        this.systemStyle.onVertScrollBarPointerReleased(scrollbar, length, width, x, y, button);
    }

    int getMarginLeft() {
        return 2;
    }

    int getMarginTop() {
        return 2;
    }

    int getMarginRight() {
        return this.getVertScrollBar().isVisible() ? this.getVertScrollBarWidth() + 2 : 2;
    }

    int getMarginBottom() {
        return this.getHorzScrollBar().isVisible() ? this.getHorzScrollBarWidth() + 2 : 2;
    }

    int getVertScrollBarWidth() {
        return this.systemStyle.getVertScrollBarWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pointerHandle(int x, int y) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            int caretPosition;
            int start;
            block5: {
                Font font = this.font;
                char[] text = input.getChars();
                int caretLine = Math.min(y / font.getHeight(), input.getLinesCount() - 1);
                start = input.getLineStart(caretLine);
                int length = input.getLineLength(caretLine);
                int w1 = 0;
                int i = 1;
                while (i <= length) {
                    int w2 = font.charsWidth(text, start, i);
                    if (x >= w1 && x < w2) {
                        caretPosition = x - w1 <= w2 - x ? i - 1 : i;
                        break block5;
                    }
                    w1 = w2;
                    ++i;
                }
                caretPosition = length;
            }
            input.setCaretPosition(start + caretPosition);
            this.correctScrollBarPositionToLine();
            // ** MonitorExit[var13_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(char src) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.insert(src);
            if (input.isChanged()) {
                this.updateView();
                this.correctScrollBarPositionToLine();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(String src) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.insert(src);
            if (input.isChanged()) {
                this.updateView();
                this.correctScrollBarPositionToLine();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void updateView() {
        TextInput input = this.input;
        Font font = this.font;
        input.split(font, this.getClientWidth() - 2);
        this.getVertScrollBar().setRange(input.getLinesCount() * font.getHeight());
        this.callSeriallyPaintScreen(4);
    }

    private void moveCaretUp() {
        int start;
        int caretPosition;
        TextInput input;
        block3: {
            input = this.input;
            caretPosition = input.getCaretPosition();
            int caretLine = input.getLineAt(caretPosition);
            if (caretLine <= 0) {
                return;
            }
            Font font = this.font;
            start = input.getLineStart(caretLine);
            char[] text = input.getChars();
            int charsWidth = font.charsWidth(text, start, caretPosition -= start);
            start = input.getLineStart(--caretLine);
            int length = input.getLineLength(caretLine);
            int w1 = 0;
            int i = 1;
            while (i <= length) {
                int w2 = font.charsWidth(text, start, i);
                if (charsWidth >= w1 && charsWidth < w2) {
                    caretPosition = charsWidth - w1 <= w2 - charsWidth ? i - 1 : i;
                    break block3;
                }
                w1 = w2;
                ++i;
            }
            caretPosition = length;
        }
        input.setCaretPosition(start + caretPosition);
    }

    private void moveCaretDown() {
        int start;
        int caretPosition;
        TextInput input;
        block3: {
            input = this.input;
            caretPosition = input.getCaretPosition();
            int caretLine = input.getLineAt(caretPosition);
            if (caretLine >= input.getLinesCount() - 1) {
                return;
            }
            Font font = this.font;
            start = input.getLineStart(caretLine);
            char[] text = input.getChars();
            int charsWidth = font.charsWidth(text, start, caretPosition -= start);
            start = input.getLineStart(++caretLine);
            int length = input.getLineLength(caretLine);
            int w1 = 0;
            int i = 1;
            while (i <= length) {
                int w2 = font.charsWidth(text, start, i);
                if (charsWidth >= w1 && charsWidth < w2) {
                    caretPosition = charsWidth - w1 <= w2 - charsWidth ? i - 1 : i;
                    break block3;
                }
                w1 = w2;
                ++i;
            }
            caretPosition = length;
        }
        input.setCaretPosition(start + caretPosition);
    }

    private void correctScrollBarPositionToLine() {
        int need;
        int lineHeight = this.font.getHeight();
        ScrollBar scrollbar = this.getVertScrollBar();
        int pos = scrollbar.getPosition();
        if (pos > (need = this.input.getCaretLine() * lineHeight)) {
            scrollbar.setPosition(need);
        } else if (pos < (need -= scrollbar.getPage() - lineHeight)) {
            scrollbar.setPosition(need);
        }
        this.callSeriallyPaintScreen(4);
    }

    private void addCommands(Command[] commands) {
        int len = commands.length;
        int i = 0;
        while (i < len) {
            super.addCommand(commands[i]);
            ++i;
        }
    }

    private void removeCommands(Command[] commands) {
        int i = commands.length;
        while (i-- > 0) {
            super.removeCommand(commands[i]);
        }
    }

    private static final class Destination
    extends WeakReference
    implements CharDestination {
        Destination(TextBox thisScreen) {
            super(thisScreen);
        }

        public void insert(char src) {
            TextBox thisScreen = (TextBox)this.get();
            if (thisScreen == null) {
                return;
            }
            thisScreen.insert(src);
        }

        public void insert(String src) {
            TextBox thisScreen = (TextBox)this.get();
            if (thisScreen == null) {
                return;
            }
            thisScreen.insert(src);
        }
    }
}

