/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.midp;

import java.io.PrintListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.CustomDisplayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextInput;
import javax.microedition.lcdui.Ticker;
import malik.emulator.i18n.Helper;
import malik.emulator.midp.ConsoleCommand;
import malik.emulator.midp.TextOutputMultilinedColor;

public class ConsoleScreen
extends CustomDisplayable
implements PrintListener {
    public static final int DEFAULT_MAXIMUM_LINES = 200;
    public static final int DEFAULT_BACKGROUND_COLOR = 0;
    public static final int DEFAULT_TITLE_COLOR = 0xC0D0C0;
    public static final int DEFAULT_OUTPUT_COLOR = 0xC0C0C0;
    public static final int DEFAULT_INPUT_COLOR = 0xFFFFFF;
    public static final Font DEFAULT_OUTPUT_FONT;
    public static final Font DEFAULT_INPUT_FONT;
    public static final Command BACK_COMMAND;
    private static final char SPACE = ' ';
    private static final Command[] COMMANDS;
    private static final Command RUN_COMMAND;
    private static final String GREETING = "\u041a\u043e\u043c\u0430\u043d\u0434\u0430: ";
    private int backgroundColor;
    private int titleColor;
    private int inputColor;
    private int inputTop;
    private int outputColor;
    private int outputLinesCount;
    private int outputFirstLineIndex;
    private int lastCommandIndex;
    private int lastCommandsCount;
    private int consoleCommandsCount;
    private String[] lastCommands;
    private ConsoleCommand[] consoleCommands;
    private TextOutputMultilinedColor output;
    private TextInput input;
    private Font inputFont;
    private Font outputFont;
    private Reference reference;

    static {
        Font font = Font.getFont((int)0, (int)0, (int)8);
        Command run = new Command("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c", 4, 0);
        Command back = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 0);
        Command[] commands = new Command[]{run, back};
        DEFAULT_OUTPUT_FONT = font;
        DEFAULT_INPUT_FONT = font;
        BACK_COMMAND = back;
        COMMANDS = commands;
        RUN_COMMAND = run;
    }

    private static String toString(char[] src, int offset, int length) {
        int len = length;
        char[] str = new char[len];
        Array.copy((char[])src, (int)offset, (char[])str, (int)0, (int)len);
        int i = len - 1;
        while (i-- > 0) {
            char next;
            if (str[i] != '\\' || (next = str[i + 1]) != '\"' && next != 'n' && next != '\\') continue;
            Array.copy((char[])str, (int)(i + 1), (char[])str, (int)i, (int)(len-- - i - 1));
            if (next != 'n') continue;
            str[i] = 10;
        }
        return new String(str, 0, len);
    }

    public ConsoleScreen(String title, CommandListener listener) {
        this(false, title, listener, 200, 0, 0xC0D0C0, 0xC0C0C0, DEFAULT_OUTPUT_FONT, 0xFFFFFF, DEFAULT_INPUT_FONT);
    }

    public ConsoleScreen(boolean fullScreenMode, String title, CommandListener listener, int maximumLines, int backgroundColor, int titleColor, int outputColor, Font outputFont, int inputColor, Font inputFont) {
        super(fullScreenMode, title, null, COMMANDS, null, listener);
        WeakReference<ConsoleScreen> ref;
        int t;
        int sh = super.getHeight();
        Font inf = inputFont == null ? DEFAULT_INPUT_FONT : inputFont;
        int infh = inf.getHeight();
        Font outf = outputFont == null ? DEFAULT_OUTPUT_FONT : outputFont;
        int outfh = outf.getHeight();
        maximumLines = maximumLines < 10 ? 10 : (maximumLines > 1000 ? 1000 : maximumLines);
        this.backgroundColor = backgroundColor;
        this.titleColor = titleColor;
        this.inputColor = inputColor;
        this.inputTop = t = sh - (infh + 1);
        this.outputColor = outputColor;
        this.outputLinesCount = t / outfh;
        this.consoleCommandsCount = 1;
        this.lastCommands = new String[50];
        ConsoleCommand[] list = new ConsoleCommand[9];
        this.consoleCommands = list;
        this.output = new TextOutputMultilinedColor(1024, maximumLines, outputColor);
        this.input = new TextInput(null, 1000, 0, 1000);
        this.inputFont = inf;
        this.outputFont = outf;
        this.reference = ref = new WeakReference<ConsoleScreen>(this);
        list[0] = new HelpCommand();
        list[0].setConsoleScreen(ref);
    }

    public void addCommand(Command command) {
        throw new IllegalStateException("ConsoleScreen.addCommand: \u043a\u043e\u043d\u0441\u043e\u043b\u044c\u043d\u044b\u0439 \u044d\u043a\u0440\u0430\u043d \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b.");
    }

    public void setDefaultCommand(Command command) {
        throw new IllegalStateException("ConsoleScreen.setDefaultCommand: \u043a\u043e\u043d\u0441\u043e\u043b\u044c\u043d\u044b\u0439 \u044d\u043a\u0440\u0430\u043d \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b.");
    }

    public void setTicker(Ticker ticker) {
        throw new IllegalStateException("ConsoleScreen.setTicker: \u043a\u043e\u043d\u0441\u043e\u043b\u044c\u043d\u044b\u0439 \u044d\u043a\u0440\u0430\u043d \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0431\u0435\u0433\u0443\u0449\u0438\u0435 \u0441\u0442\u0440\u043e\u043a\u0438.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] src, int offset, int length) {
        TextOutputMultilinedColor output;
        TextOutputMultilinedColor textOutputMultilinedColor = output = this.output;
        synchronized (output) {
            char[] ac = Helper.byteToCharArray((byte[])src, (int)offset, (int)length);
            output.append(ac, 0, ac.length);
            this.checkLength(output);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            this.repaint(4);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(char src) {
        TextOutputMultilinedColor output;
        TextOutputMultilinedColor textOutputMultilinedColor = output = this.output;
        synchronized (output) {
            output.append(String.valueOf(src));
            this.checkLength(output);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.repaint(4);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(char[] src) {
        TextOutputMultilinedColor output;
        TextOutputMultilinedColor textOutputMultilinedColor = output = this.output;
        synchronized (output) {
            output.append(src, 0, src != null ? src.length : 0);
            this.checkLength(output);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.repaint(4);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String src) {
        TextOutputMultilinedColor output;
        TextOutputMultilinedColor textOutputMultilinedColor = output = this.output;
        synchronized (output) {
            output.append(src);
            this.checkLength(output);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.repaint(4);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        TextOutputMultilinedColor output;
        TextOutputMultilinedColor textOutputMultilinedColor = output = this.output;
        synchronized (output) {
            output.append(String.valueOf('\n'));
            this.checkLength(output);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.repaint(4);
            return;
        }
    }

    public void printHelp() {
        this.print("\u0420\u0435\u0433\u0438\u0441\u0442\u0440 \u043a\u043e\u043c\u0430\u043d\u0434 \u0438 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0443\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f. \u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b \u043f\u0438\u0448\u0443\u0442\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u043f\u0440\u043e\u0431\u0435\u043b, \u0432 \u043d\u0438\u0445 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b \u0442\u0430\u043a \u043d\u0430\u0437\u044b\u0432\u0430\u0435\u043c\u044b\u0435 escape-\u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \\\\, \\\", \\n; \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043a\u043b\u044e\u0447\u0430\u0442\u044c \u0432 \u043a\u0430\u0432\u044b\u0447\u043a\u0438 (\"\u2026\"), \u0435\u0441\u043b\u0438 \u0432\u043d\u0443\u0442\u0440\u0438 \u043d\u0438\u0445 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u0441\u044f \u043f\u0440\u043e\u0431\u0435\u043b\u044b.\n\u0421\u0442\u0440\u0435\u043b\u043a\u0430\u043c\u0438 \u2191 \u0438 \u2193 \u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043a\u043e\u043d\u0441\u043e\u043b\u0438, \u0441\u0442\u0440\u0435\u043b\u043a\u0430\u043c\u0438 \u2190 \u0438 \u2192 \u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u0442\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u043d\u0430\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b,\nEnter \u2013 \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043d\u0430\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u043a\u043e\u043c\u0430\u043d\u0434\u0443,\nEsc \u2013 \u0432\u044b\u0445\u043e\u0434 \u0438\u0437 \u043a\u043e\u043d\u0441\u043e\u043b\u0438.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        TextOutputMultilinedColor output;
        TextOutputMultilinedColor textOutputMultilinedColor = output = this.output;
        synchronized (output) {
            output.setColor(this.outputColor);
            output.clear();
            output.split(this.outputFont, super.getWidth());
            this.scrollToLastLine();
            this.repaint(4);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColor(int color) {
        TextOutputMultilinedColor output;
        TextOutputMultilinedColor textOutputMultilinedColor = output = this.output;
        synchronized (output) {
            output.setColor(color);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.repaint();
    }

    public void setTitleColor(int titleColor) {
        this.titleColor = titleColor;
        this.repaint(1);
    }

    public void setOutputColor(int outputColor) {
        this.outputColor = outputColor;
    }

    public void setInputColor(int inputColor) {
        this.inputColor = inputColor;
        this.repaint(4);
    }

    public void setOutputFont(Font outputFont) {
        this.outputFont = outputFont == null ? DEFAULT_OUTPUT_FONT : outputFont;
        super.setEventSizeChanged();
        this.repaint(4);
    }

    public void setInputFont(Font inputFont) {
        this.inputFont = inputFont == null ? DEFAULT_INPUT_FONT : inputFont;
        super.setEventSizeChanged();
        this.repaint(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsoleCommand(ConsoleCommand command) {
        if (command == null) {
            throw new NullPointerException("ConsoleScreen.addConsoleCommand: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 command \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (command.getConsoleScreen() != null) {
            throw new IllegalArgumentException("ConsoleScreen.addConsoleCommand: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 command \u0443\u0436\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u043a\u043e\u043d\u0441\u043e\u043b\u0438.");
        }
        Object object = super.getMonitor();
        synchronized (object) {
            int len = this.consoleCommandsCount;
            Object[] c = this.consoleCommands;
            if (len == this.consoleCommands.length) {
                Object[] objectArray = c;
                this.consoleCommands = new ConsoleCommand[(len << 1) - 1];
                c = this.consoleCommands;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.consoleCommands, (int)0, (int)len);
            }
            c[len++] = command;
            this.consoleCommandsCount = len;
            command.setConsoleScreen(this.reference);
        }
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getTitleColor() {
        return this.titleColor;
    }

    public int getOutputColor() {
        return this.outputColor;
    }

    public int getInputColor() {
        return this.inputColor;
    }

    public Font getOutputFont() {
        return this.outputFont;
    }

    public Font getInputFont() {
        return this.inputFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics render) {
        TextOutputMultilinedColor output;
        Font inputFont = this.inputFont;
        Font outputFont = this.outputFont;
        TextInput input = this.input;
        render.setFont(outputFont);
        TextOutputMultilinedColor textOutputMultilinedColor = output = this.output;
        synchronized (output) {
            int outputFirstLineIndex;
            int outputLinesCount = output.getLinesCount();
            if (output.getLineStart(outputLinesCount) < output.getLength()) {
                output.split(outputFont, super.getWidth());
                output.deleteStartLines();
                this.scrollToLastLine();
            }
            if ((outputLinesCount = output.getLinesCount()) > 0 && outputLinesCount > (outputFirstLineIndex = this.outputFirstLineIndex)) {
                output.paintLines(render, 0, 0, outputFirstLineIndex, Math.min(outputLinesCount - outputFirstLineIndex, this.outputLinesCount));
            }
            // ** MonitorExit[var13_6] (shouldn't be in output)
            render.setFont(inputFont);
            render.setColor(this.inputColor);
            int inputTop = this.inputTop;
            int width = super.getWidth();
            render.drawLine(0, inputTop, width - 1, inputTop++);
            render.drawString(GREETING, 0, inputTop, 20);
            int inputLeft = inputFont.stringWidth(GREETING);
            int inputLength = input.getLength();
            char[] inputChars = input.getChars();
            if (inputLength < inputChars.length) {
                inputChars[inputLength++] = 95;
            }
            render.clipRect(inputLeft, inputTop, width - inputLeft, super.getHeight() - inputTop);
            render.drawChars(inputChars, 0, inputLength, Math.min(inputLeft, width - inputFont.charsWidth(inputChars, 0, inputLength)), inputTop, 20);
            return;
        }
    }

    protected void paintTitle(Graphics render, int width, int height, String title) {
        render.setColor(this.backgroundColor);
        render.fillRect(0, 0, width--, --height);
        render.setColor(this.titleColor);
        render.drawLine(0, height, width, height);
        render.drawString(title, 1, 2, 20);
    }

    protected void paintClient(Graphics render, int width, int height, int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        render.setColor(this.backgroundColor);
        render.fillRect(0, 0, width, height);
        Graphics clientRender = this.getClientGraphics();
        clientRender.reset();
        clientRender.setClip(clipLeft, clipTop, clipWidth, clipHeight);
        this.paint(clientRender);
    }

    protected void paintCommands(Graphics render, int width, int height, Command[] commands, int pressedIndex, Font defaultCommandFont) {
        int w = width;
        int a = w / 3;
        int b = w - a;
        render.setColor(this.backgroundColor);
        render.fillRect(0, 0, width, height);
        render.setColor(this.inputColor);
        this.paintCommand(render, 0, 0, a, height, commands[0], false, pressedIndex == 0);
        this.paintCommand(render, b, 0, w - b, height, commands[2], false, pressedIndex == 2);
        render.setFont(defaultCommandFont);
        this.paintCommand(render, a, 0, b - a, height, commands[1], true, pressedIndex == 1);
    }

    protected void paintCommand(Graphics render, int left, int top, int width, int height, Command command, boolean asDefault, boolean asPressed) {
        if (command != null) {
            render.drawRoundRect(left, top, width - 1, height - 1, 2, 2);
            render.drawString(command.getTruncatedLabel(render.getFont(), width - 4), left + width / 2 + (asPressed ? 1 : 0), top + (asPressed ? 3 : 2) + (asDefault ? -1 : 1), 17);
        }
    }

    protected void onSizeChanged(int width, int height) {
        int t;
        int infh = this.inputFont.getHeight();
        this.inputTop = t = height - (infh + 1);
        this.outputLinesCount = t / this.outputFont.getHeight();
        super.onSizeChanged(width, height);
    }

    protected void onKeyPressed(int key, int charCode) {
        if (!super.keyHandling(key)) {
            switch (key) {
                case 38: {
                    int firstLineIndex = this.outputFirstLineIndex;
                    if (firstLineIndex > 0) {
                        this.outputFirstLineIndex = firstLineIndex - 1;
                        this.repaint(4);
                    }
                    return;
                }
                case 40: {
                    int firstLineIndex = this.outputFirstLineIndex;
                    if (firstLineIndex < this.output.getLinesCount() - this.outputLinesCount) {
                        this.outputFirstLineIndex = firstLineIndex + 1;
                        this.repaint(4);
                    }
                    return;
                }
                case 37: {
                    int count = this.lastCommandsCount + 1;
                    int index = this.lastCommandIndex = (this.lastCommandIndex + count - 1) % count;
                    TextInput input = this.input;
                    input.setString(this.lastCommands[index]);
                    input.setCaretPosition(input.getLength());
                    this.repaint(4);
                    return;
                }
                case 39: {
                    int count = this.lastCommandsCount + 1;
                    int index = this.lastCommandIndex = (this.lastCommandIndex + 1) % count;
                    TextInput input = this.input;
                    input.setString(this.lastCommands[index]);
                    input.setCaretPosition(input.getLength());
                    this.repaint(4);
                    return;
                }
            }
            TextInput input = this.input;
            input.keyPressed(key, charCode);
            if (input.isChanged()) {
                this.repaint(4);
            }
            return;
        }
        super.onKeyPressed(key, charCode);
    }

    protected void onKeyRepeated(int key, int charCode) {
        if (!super.keyHandling(key)) {
            switch (key) {
                case 38: {
                    int firstLineIndex = this.outputFirstLineIndex;
                    if (firstLineIndex > 0) {
                        this.outputFirstLineIndex = firstLineIndex - 1;
                        this.repaint(4);
                    }
                    return;
                }
                case 40: {
                    int firstLineIndex = this.outputFirstLineIndex;
                    if (firstLineIndex < this.output.getLinesCount() - this.outputLinesCount) {
                        this.outputFirstLineIndex = firstLineIndex + 1;
                        this.repaint(4);
                    }
                    return;
                }
            }
            TextInput input = this.input;
            input.keyPressed(key, charCode);
            if (input.isChanged()) {
                this.repaint(4);
            }
            return;
        }
        super.onKeyRepeated(key, charCode);
    }

    protected void onKeyReleased(int key) {
        switch (key) {
            case 27: {
                if (super.keyHandling(key)) break;
                super.setEventCommandAction(BACK_COMMAND);
                return;
            }
            case 13: {
                if (super.keyHandling(key)) break;
                super.setEventCommandAction(RUN_COMMAND);
                return;
            }
            case 16: 
            case 160: 
            case 161: {
                this.input.keyReleased(key);
                return;
            }
        }
        super.onKeyReleased(key);
    }

    protected void onCommandAction(Command command) {
        if (command == RUN_COMMAND) {
            this.runCommand();
            return;
        }
        super.onCommandAction(command);
    }

    private void runCommand() {
        boolean cq;
        int c;
        TextInput input = this.input;
        int len = input.getLength();
        char[] line = input.getChars();
        int i0 = -1;
        int argsStart = -1;
        int i = 0;
        while (i <= len) {
            c = i < len ? line[i] : 0;
            if (c > 32 && (i <= 0 || line[i - 1] <= ' ')) {
                i0 = i;
            }
            if (i > 0 && c <= 32 && line[i - 1] > ' ') {
                argsStart = i + 1;
                break;
            }
            ++i;
        }
        if (i0 < 0 || argsStart < 0) {
            return;
        }
        String name = new String(line, i0, argsStart - i0 - 1);
        int argsLen = 0;
        boolean q = false;
        int p = line[argsStart - 1];
        i = argsStart;
        while (i <= len) {
            c = i < len ? line[i] : 0;
            cq = c == 34 && p != 92;
            if (cq) {
                q = !q;
                c = 32;
            }
            if (cq ? !q : (q ? i == len : c <= 32 && p > 32)) {
                ++argsLen;
            }
            p = c;
            ++i;
        }
        String[] args = new String[argsLen];
        int argsIndex = 0;
        q = false;
        p = line[argsStart - 1];
        i = argsStart;
        while (i <= len) {
            c = i < len ? line[i] : 0;
            cq = c == 34 && p != 92;
            if (cq) {
                q = !q;
                c = 32;
            }
            if (cq ? q : !q && c > 32 && p <= 32) {
                int n = i0 = cq ? i + 1 : i;
            }
            if (cq ? !q : (q ? i == len : c <= 32 && p > 32)) {
                args[argsIndex++] = ConsoleScreen.toString(line, i0, i - i0);
            }
            p = c;
            ++i;
        }
        if (argsIndex < argsLen) {
            return;
        }
        this.addLastCommand(String.valueOf(line, 0, len).intern());
        input.clear();
        this.setColor(this.inputColor);
        this.print(new StringBuffer(GREETING).append(line, 0, len).append('\n').toString());
        this.serviceRepaints();
        this.setColor(this.outputColor);
        ConsoleCommand command = this.getConsoleCommand(name);
        if (command == null) {
            this.print("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430 " + name + '\n');
            return;
        }
        this.repaint(4);
        command.run(args);
    }

    private void addLastCommand(String lastCommand) {
        int len = this.lastCommandsCount;
        Object[] list = this.lastCommands;
        if (len == this.lastCommands.length - 1) {
            Array.copy((Object[])list, (int)1, (Object[])list, (int)0, (int)(len-- - 2));
        }
        list[len++] = lastCommand;
        this.lastCommandIndex = len;
        this.lastCommandsCount = len;
    }

    private void scrollToLastLine() {
        this.outputFirstLineIndex = Math.max(this.output.getLinesCount() - this.outputLinesCount, 0);
    }

    private void checkLength(TextOutputMultilinedColor output) {
        if (output.getLength() >= 25000) {
            output.split(this.outputFont, super.getWidth());
            output.deleteStartLines();
            this.scrollToLastLine();
        }
    }

    private ConsoleCommand getConsoleCommand(String name) {
        ConsoleCommand[] commands = this.consoleCommands;
        int i = this.consoleCommandsCount;
        while (i-- > 0) {
            ConsoleCommand command = commands[i];
            if (!name.equals(command.getName())) continue;
            return command;
        }
        return null;
    }

    private static final class HelpCommand
    extends ConsoleCommand {
        HelpCommand() {
            super("?", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435:\n  ?\n  ? <\u043a\u043e\u043c\u0430\u043d\u0434\u0430>\n\u0411\u0435\u0437 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u2013 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043a\u043e\u043c\u0430\u043d\u0434, \u0441 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u043c \u2013 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043a\u0438 \u043f\u043e \u043a\u043e\u043c\u0430\u043d\u0434\u0435, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0439 \u0432 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0435.");
        }

        public void run(String[] arguments) {
            ConsoleScreen console = this.getConsoleScreen();
            if (console == null) {
                return;
            }
            if (arguments.length <= 0) {
                console.print("\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043a\u043e\u043c\u0430\u043d\u0434:\n");
                ConsoleCommand[] commands = console.consoleCommands;
                int len = console.consoleCommandsCount;
                int i = 0;
                while (i < len) {
                    ConsoleCommand command = commands[i];
                    if (!command.isHide()) {
                        console.print("  " + command.getName() + '\n');
                    }
                    ++i;
                }
                console.print("\u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0442\u0430\u043a \u0436\u0435\n  ? <\u043a\u043e\u043c\u0430\u043d\u0434\u0430>\n\u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0440\u0430\u0432\u043a\u0438 \u043f\u043e \u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u0435.\n");
                console.printHelp();
            } else {
                String name = arguments[0];
                ConsoleCommand command = console.getConsoleCommand(name);
                if (command == null || command.isHide()) {
                    console.print("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430 " + name + '\n');
                    return;
                }
                console.print(command.getHelp());
                console.println();
            }
        }
    }
}

