/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.midp.player;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import malik.emulator.fileformats.sound.sampled.SoundDecoderSampled;
import malik.emulator.fileformats.sound.sampled.wavelib.WaveDecoder;
import malik.emulator.fileformats.sound.synthetic.SoundDecoderSynthetic;
import malik.emulator.fileformats.sound.synthetic.midilib.MIDIDecoder;
import malik.emulator.io.j2me.VirtualPlayerManager;
import malik.emulator.media.sound.SoundPlayerException;
import malik.emulator.media.sound.SoundPlayerMessaged;
import malik.emulator.media.sound.SoundPlayerSynthetic;
import malik.emulator.midp.player.SampledPlayer;
import malik.emulator.midp.player.SyntheticPlayer;

public class SupportedPlayerFormats
implements VirtualPlayerManager {
    private static final String CONTENT_TYPE_AUDIO_MIDI = "audio/midi";
    private static final String CONTENT_TYPE_AUDIO_WAVE = "audio/x-wav";
    private static final String PROTOCOL_SIGNATURE = "://";
    private static final String PROTOCOL_RESOURCE = "resource";
    private static final String PROTOCOL_RESOURCE_SIGNATURE = "resource://";
    private String[] supportedContentTypes;
    private String[] supportedProtocols;
    private String[] emptyList;
    private SoundPlayerMessaged toneGenerator;

    public static int midpVolumeToDeviceVolume(int volume) {
        return volume < 0 ? 0 : (volume >= 100 ? 127 : volume * 127 / 100);
    }

    public static int midpVolumeToMIDPVolume(int volume) {
        return volume < 0 ? 0 : (volume > 100 ? 100 : volume);
    }

    public static int deviceVolumeToMIDPVolume(int volume) {
        return volume < 0 ? 0 : (volume >= 127 ? 100 : volume * 100 / 127);
    }

    private static long continueReadSignature(long signature, InputStream stream, int bytes) throws IOException {
        int i = bytes;
        while (i-- > 0) {
            signature = signature << 8 | (long)stream.read();
        }
        return signature;
    }

    public SupportedPlayerFormats() {
        SoundPlayerSynthetic generator;
        try {
            generator = SoundPlayerSynthetic.open();
        }
        catch (SoundPlayerException soundPlayerException) {
            generator = null;
        }
        this.supportedContentTypes = new String[]{CONTENT_TYPE_AUDIO_MIDI, CONTENT_TYPE_AUDIO_WAVE};
        this.supportedProtocols = new String[]{PROTOCOL_RESOURCE};
        this.emptyList = new String[0];
        this.toneGenerator = generator;
    }

    public void playTone(int note, int duration, int volume) throws MediaException {
        if (note < 0 || note > 127) {
            throw new IllegalArgumentException("Manager.playTone: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 note \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (duration <= 0) {
            throw new IllegalArgumentException("Manager.playTone: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 duration \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        SoundPlayerMessaged generator = this.toneGenerator;
        if (generator == null) {
            throw new MediaException("Manager.playTone: \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u043f\u0430\u043c\u044f\u0442\u0438 \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043d\u043e\u0432\u043e\u0433\u043e MIDI-\u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442 MIDI.");
        }
        int msg = 0x900000 | note << 8;
        generator.sendMessage(msg | SupportedPlayerFormats.midpVolumeToDeviceVolume(volume));
        Scheduler.schedule((Scheduler.Task)new NoteOffTask(generator, msg), (long)duration, (int)2);
    }

    public String[] getSupportedContentTypes(String protocol) {
        int i;
        Object[] result = this.emptyList;
        if (protocol != null) {
            String[] list = this.supportedProtocols;
            i = this.supportedProtocols.length;
            while (i-- > 0) {
                if (!protocol.equalsIgnoreCase(list[i])) continue;
                result = this.supportedContentTypes;
                break;
            }
        } else {
            result = this.supportedContentTypes;
        }
        Object[] objectArray = result;
        i = result.length;
        result = new String[i];
        Array.copy((Object[])objectArray, (int)0, (Object[])result, (int)0, (int)i);
        return result;
    }

    public String[] getSupportedProtocols(String type) {
        int i;
        Object[] result = this.emptyList;
        if (type != null) {
            String[] list = this.supportedContentTypes;
            i = this.supportedContentTypes.length;
            while (i-- > 0) {
                if (!type.equalsIgnoreCase(list[i])) continue;
                result = this.supportedProtocols;
                break;
            }
        } else {
            result = this.supportedProtocols;
        }
        Object[] objectArray = result;
        i = result.length;
        result = new String[i];
        Array.copy((Object[])objectArray, (int)0, (Object[])result, (int)0, (int)i);
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Player createPlayer(InputStream stream, String type) throws IOException, MediaException {
        void var5_8;
        if (stream == null) {
            throw new IllegalArgumentException("Manager.createPlayer: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 stream \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        long signature = SupportedPlayerFormats.continueReadSignature(0L, stream, 4);
        if (type == null) {
            if (signature == 1380533830L) {
                SampledPlayer sampledPlayer = new SampledPlayer((SoundDecoderSampled)new WaveDecoder(), CONTENT_TYPE_AUDIO_WAVE);
            } else {
                if (SupportedPlayerFormats.continueReadSignature(signature, stream, 4) != 5572193417670164486L) throw new MediaException("Manager.createPlayer: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u0442\u044c \u0442\u0438\u043f \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e.");
                SyntheticPlayer syntheticPlayer = new SyntheticPlayer((SoundDecoderSynthetic)new MIDIDecoder(), CONTENT_TYPE_AUDIO_MIDI);
            }
        } else if (signature == 1380533830L && CONTENT_TYPE_AUDIO_WAVE.equalsIgnoreCase(type)) {
            SampledPlayer sampledPlayer = new SampledPlayer((SoundDecoderSampled)new WaveDecoder(), CONTENT_TYPE_AUDIO_WAVE);
        } else {
            if (SupportedPlayerFormats.continueReadSignature(signature, stream, 4) != 5572193417670164486L || !CONTENT_TYPE_AUDIO_MIDI.equalsIgnoreCase(type)) throw new MediaException("Manager.createPlayer: \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e " + type);
            SyntheticPlayer syntheticPlayer = new SyntheticPlayer((SoundDecoderSynthetic)new MIDIDecoder(), CONTENT_TYPE_AUDIO_MIDI);
        }
        var5_8.getData(stream);
        return var5_8;
    }

    public Player createPlayer(String locator) throws IOException, MediaException {
        if (locator == null) {
            throw new IllegalArgumentException("Manager.createPlayer: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 locator \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = PROTOCOL_RESOURCE_SIGNATURE.length();
        if (!PROTOCOL_RESOURCE_SIGNATURE.regionMatches(true, 0, locator, 0, len)) {
            throw new ConnectionNotFoundException("Manager.createPlayer: \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
        }
        InputStream stream = this.getClass().getResourceAsStream(locator.substring(len - 1));
        if (stream == null) {
            throw new ConnectionNotFoundException("Manager.createPlayer: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 " + locator + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
        }
        return this.createPlayer(stream, null);
    }

    private static final class NoteOffTask
    extends Scheduler.Task {
        private int message;
        private SoundPlayerMessaged generator;

        NoteOffTask(SoundPlayerMessaged generator, int message) {
            this.message = message;
            this.generator = generator;
        }

        public void run() {
            this.generator.sendMessage(this.message);
        }
    }
}

