/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.midp.player;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.VolumeControl;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.sound.SoundEncoder;
import malik.emulator.fileformats.sound.synthetic.SoundDecoderSynthetic;
import malik.emulator.fileformats.sound.synthetic.midilib.MIDIEncoder;
import malik.emulator.media.sound.SoundPlayer;
import malik.emulator.media.sound.SoundPlayerException;
import malik.emulator.media.sound.SoundPlayerListener;
import malik.emulator.media.sound.SoundPlayerSynthetic;
import malik.emulator.midp.player.ContentPlayer;
import malik.emulator.midp.player.SoundEncoderGetter;
import malik.emulator.midp.player.SupportedPlayerFormats;

public final class SyntheticPlayer
extends ContentPlayer
implements SoundPlayerListener,
VolumeControl,
SoundEncoderGetter {
    private boolean loaded;
    private boolean muted;
    private int volume = 100;
    private int startFromIndex;
    private int loopCountSetted = 1;
    private int loopCountRemaining;
    private long[] synthesizerMessages;
    private SoundPlayerSynthetic player;
    private SoundDecoderSynthetic decoder;
    private String contentType;

    public SyntheticPlayer(SoundDecoderSynthetic decoder, String contentType) {
        this.decoder = decoder;
        this.contentType = contentType;
    }

    public void getData(InputStream source) throws IOException, InvalidDataFormatException, MediaException {
        this.decoder.loadFromInputStream(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.state == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.state != 0) {
                SoundDecoderSynthetic sd;
                this.state = 0;
                this.synthesizerMessages = null;
                SoundPlayerSynthetic sp = this.player;
                if (sp != null) {
                    sp.close();
                    sp = null;
                    this.player = null;
                }
                if ((sd = this.decoder) != null) {
                    sd.clear();
                    sd = null;
                    this.decoder = null;
                }
                this.deliverEvent("closed", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void realize() throws MediaException {
        int error = 0;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                default: {
                    break;
                }
                case 0: {
                    error = 1;
                    break;
                }
                case 100: {
                    if (!this.realizePlayer()) break;
                    error = 2;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Player.realize: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                this.deliverEvent("error", "Player.realize: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u0441\u0438\u043d\u0442\u0435\u0437\u0430\u0442\u043e\u0440\u0430 MIDI.");
                throw new MediaException("Player.realize: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u0441\u0438\u043d\u0442\u0435\u0437\u0430\u0442\u043e\u0440\u0430 MIDI.");
            }
        }
        super.realize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prefetch() throws MediaException {
        int error = 0;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                default: {
                    break;
                }
                case 0: {
                    error = 1;
                    break;
                }
                case 100: {
                    if (this.realizePlayer()) {
                        error = 2;
                        break;
                    }
                    if (this.synthesizerMessages == null) break;
                }
                case 200: {
                    if (!this.prefetchPlayer()) break;
                    error = 3;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Player.prefetch: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                this.deliverEvent("error", "Player.prefetch: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u0441\u0438\u043d\u0442\u0435\u0437\u0430\u0442\u043e\u0440\u0430 MIDI.");
                throw new MediaException("Player.prefetch: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u0441\u0438\u043d\u0442\u0435\u0437\u0430\u0442\u043e\u0440\u0430 MIDI.");
            }
            case 3: {
                this.deliverEvent("error", "Player.prefetch: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0441\u0438\u043d\u0442\u0435\u0437\u0430\u0442\u043e\u0440\u0443 MIDI.");
                throw new MediaException("Player.prefetch: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0441\u0438\u043d\u0442\u0435\u0437\u0430\u0442\u043e\u0440\u0443 MIDI.");
            }
        }
        super.prefetch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws MediaException {
        int error = 0;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                default: {
                    break;
                }
                case 0: {
                    error = 1;
                    break;
                }
                case 100: {
                    if (this.realizePlayer()) {
                        error = 2;
                        break;
                    }
                    if (this.synthesizerMessages == null) break;
                }
                case 200: {
                    if (this.prefetchPlayer()) {
                        error = 3;
                        break;
                    }
                }
                case 300: {
                    int position;
                    if (this.loopCountRemaining == 0) {
                        this.loopCountRemaining = this.loopCountSetted;
                    }
                    long[] messages = this.synthesizerMessages;
                    SoundPlayerSynthetic sp = this.player;
                    if (!this.loaded) {
                        this.loaded = true;
                        position = this.startFromIndex;
                        sp.loadBlock(messages, 0, messages.length);
                        if (position > 0) {
                            sp.setCurrentBlockPosition(position);
                        }
                    } else {
                        position = sp.getCurrentBlockPosition();
                        sp.start();
                    }
                    long mediaTime = 1000L * (messages[position] >>> 24);
                    this.state = 400;
                    this.deliverEvent("started", new Long(mediaTime));
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Player.start: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                this.deliverEvent("error", "Player.start: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u0441\u0438\u043d\u0442\u0435\u0437\u0430\u0442\u043e\u0440\u0430 MIDI.");
                throw new MediaException("Player.start: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u0441\u0438\u043d\u0442\u0435\u0437\u0430\u0442\u043e\u0440\u0430 MIDI.");
            }
            case 3: {
                this.deliverEvent("error", "Player.start: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0441\u0438\u043d\u0442\u0435\u0437\u0430\u0442\u043e\u0440\u0443 MIDI.");
                throw new MediaException("Player.start: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0441\u0438\u043d\u0442\u0435\u0437\u0430\u0442\u043e\u0440\u0443 MIDI.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws MediaException {
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                default: {
                    break;
                }
                case 0: {
                    error = true;
                    break;
                }
                case 400: {
                    SoundPlayerSynthetic sp = this.player;
                    sp.stop();
                    int position = sp.getCurrentBlockPosition();
                    long[] messages = this.synthesizerMessages;
                    long mediaTime = 1000L * (messages[position] >>> 24);
                    this.state = 300;
                    this.deliverEvent("stopped", new Long(mediaTime));
                }
            }
        }
        if (error) {
            throw new IllegalStateException("Player.stop: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoopCount(int loopCount) {
        if (loopCount == 0) {
            throw new IllegalArgumentException("Player.setLoopCount: \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0432\u0442\u043e\u0440\u043e\u0432 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u044b\u043c.");
        }
        int error = 0;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case 0: {
                    error = 1;
                    break;
                }
                case 400: {
                    error = 2;
                    break;
                }
                default: {
                    this.loopCountSetted = loopCount;
                    this.loopCountRemaining = loopCount;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Player.setLoopCount: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                this.deliverEvent("error", "Player.setLoopCount: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0432\u0442\u043e\u0440\u043e\u0432 \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0438\u044f.");
                throw new IllegalStateException("Player.setLoopCount: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0432\u0442\u043e\u0440\u043e\u0432 \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0438\u044f.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setMediaTime(long time) throws MediaException {
        int error = 0;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case 0: {
                    error = 1;
                    break;
                }
                case 100: {
                    error = 2;
                    break;
                }
                default: {
                    long timeApprox;
                    int posApprox;
                    long[] messages = this.synthesizerMessages;
                    int positionA = 0;
                    int positionB = messages.length - 1;
                    while (true) {
                        posApprox = positionA + positionB >> 1;
                        timeApprox = 1000L * (messages[posApprox] >>> 24);
                        if (positionA == positionB) break;
                        if (time < timeApprox) {
                            positionB = posApprox - 1;
                            if (positionB >= positionA) continue;
                            positionB = positionA;
                            continue;
                        }
                        if (time <= timeApprox) break;
                        positionA = posApprox + 1;
                        if (positionA <= positionB) continue;
                        positionA = positionB;
                    }
                    time = timeApprox;
                    if (!this.loaded) {
                        this.startFromIndex = posApprox;
                        break;
                    }
                    this.player.setCurrentBlockPosition(posApprox);
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Player.setMediaTime: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                this.deliverEvent("error", "Player.setMediaTime: \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0435\u0449\u0451 \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430.");
                throw new IllegalStateException("Player.setMediaTime: \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0435\u0449\u0451 \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430.");
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMediaTime() {
        long result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case 0: {
                    error = true;
                    result = 0L;
                    break;
                }
                case 100: {
                    result = -1L;
                    break;
                }
                default: {
                    int position = this.loaded ? this.player.getCurrentBlockPosition() : this.startFromIndex;
                    long[] messages = this.synthesizerMessages;
                    result = 1000L * (messages[position] >>> 24);
                }
            }
        }
        if (error) {
            throw new IllegalStateException("Player.getMediaTime: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDuration() {
        long result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case 0: {
                    error = true;
                    result = 0L;
                    break;
                }
                case 100: {
                    result = -1L;
                    break;
                }
                default: {
                    long[] messages = this.synthesizerMessages;
                    int position = this.synthesizerMessages.length - 1;
                    result = 1000L * (messages[position] >>> 24);
                }
            }
        }
        if (error) {
            throw new IllegalStateException("Player.getDuration: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBlock(SoundPlayer player, int blockIndex) {
        if (blockIndex >= 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            long[] messages = this.synthesizerMessages;
            int position = this.synthesizerMessages.length - 1;
            long duration = 1000L * (messages[position] >>> 24);
            if (--this.loopCountRemaining == 0) {
                this.state = 300;
                this.deliverEvent("endOfMedia", new Long(duration));
            } else {
                player.start();
                this.deliverEvent("endOfMedia", new Long(duration));
                this.deliverEvent("started", new Long(0L));
            }
        }
    }

    public void setMute(boolean mute) {
        this.muted = mute;
        if (this.muted != this.muted) {
            SoundPlayerSynthetic sp = this.player;
            if (sp != null) {
                sp.setVolume(SupportedPlayerFormats.midpVolumeToDeviceVolume(mute ? 0 : this.volume));
            }
            this.deliverEvent("volumeChanged", this);
        }
    }

    public boolean isMuted() {
        return this.muted;
    }

    public int setLevel(int volume) {
        SoundPlayerSynthetic sp = this.player;
        volume = sp != null ? SupportedPlayerFormats.deviceVolumeToMIDPVolume(sp.setVolume(SupportedPlayerFormats.midpVolumeToDeviceVolume(this.muted ? 0 : volume))) : SupportedPlayerFormats.midpVolumeToMIDPVolume(volume);
        this.volume = volume;
        if (this.volume != volume) {
            this.deliverEvent("volumeChanged", this);
        }
        return volume;
    }

    public int getLevel() {
        return this.volume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoundEncoder getSoundEncoder() throws InvalidDataFormatException {
        long[] messages;
        int error = 0;
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 0) {
                error = 1;
                messages = null;
            } else {
                messages = this.synthesizerMessages;
                if (this.synthesizerMessages == null) {
                    error = 2;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("SoundEncoderGetter.getSoundEncoder: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IllegalStateException("SoundEncoderGetter.getSoundEncoder: \u0434\u0430\u043d\u043d\u044b\u0435 \u0435\u0449\u0451 \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b.");
            }
        }
        MIDIEncoder result = new MIDIEncoder();
        result.setMessages(messages);
        return result;
    }

    protected void unrealize() {
        SoundDecoderSynthetic sd = this.decoder;
        if (sd != null) {
            sd.stopLoading();
        }
        super.unrealize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unprefetch() {
        Object object = this.lock;
        synchronized (object) {
            SoundPlayerSynthetic sp = this.player;
            if (sp != null) {
                sp.close();
                this.player = null;
                this.loaded = false;
                this.startFromIndex = 0;
            }
            super.unprefetch();
        }
    }

    protected String getPlayerContentType() {
        return this.contentType;
    }

    private boolean realizePlayer() {
        long[] messages = this.decoder.getMessages();
        if (messages == null) {
            return false;
        }
        int position = messages.length;
        if (position <= 0) {
            return true;
        }
        long duration = 1000L * (messages[--position] >>> 24);
        this.decoder = null;
        this.synthesizerMessages = messages;
        this.state = 200;
        this.deliverEvent("durationUpdated", new Long(duration));
        return false;
    }

    private boolean prefetchPlayer() {
        boolean result;
        try {
            SoundPlayerSynthetic sp;
            this.player = sp = SoundPlayerSynthetic.open();
            sp.setSoundPlayerListener((SoundPlayerListener)this);
            sp.setVolume(this.muted ? 0 : SupportedPlayerFormats.midpVolumeToDeviceVolume(this.volume));
            this.state = 300;
            result = false;
        }
        catch (SoundPlayerException e) {
            e.printRealStackTrace();
            result = true;
        }
        return result;
    }
}

