/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import malik.emulator.i18n.Helper;

public class InputStreamReader
extends Reader {
    private final Reader in;

    public InputStreamReader(InputStream stream) {
        Reader reader;
        this.in = reader = Helper.createReader(stream);
        this.lock = reader.lock;
    }

    public InputStreamReader(InputStream stream, String encoding) throws UnsupportedEncodingException {
        Reader reader;
        this.in = reader = Helper.createReader(stream, encoding);
        this.lock = reader.lock;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public void mark(int readLimit) throws IOException {
        this.in.mark(readLimit);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public boolean ready() throws IOException {
        return this.in.ready();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(char[] dst, int offset, int length) throws IOException {
        long bounds = Array.intersectBound(dst == null ? 0 : dst.length, offset, length);
        offset = (int)bounds;
        length = (int)(bounds >> 32);
        return this.in.read(dst, offset, length);
    }

    public long skip(long quantity) throws IOException {
        return this.in.skip(quantity);
    }
}

