/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import malik.emulator.i18n.Helper;

public class OutputStreamWriter
extends Writer {
    private final Writer out;

    public OutputStreamWriter(OutputStream stream) {
        Writer writer;
        this.out = writer = Helper.createWriter(stream);
        this.lock = writer.lock;
    }

    public OutputStreamWriter(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        Writer writer;
        this.out = writer = Helper.createWriter(stream, encoding);
        this.lock = writer.lock;
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(int charData) throws IOException {
        this.out.write(charData);
    }

    public void write(char[] src, int offset, int length) throws IOException {
        long bounds = Array.intersectBound(src == null ? 0 : src.length, offset, length);
        offset = (int)bounds;
        length = (int)(bounds >> 32);
        this.out.write(src, offset, length);
    }

    public void write(String string, int offset, int length) throws IOException {
        long bounds = Array.intersectBound(string == null ? 0 : string.length(), offset, length);
        offset = (int)bounds;
        length = (int)(bounds >> 32);
        this.out.write(string, offset, length);
    }
}

