/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import malik.emulator.util.StringBuilder;

public abstract class Reader {
    protected Object lock;

    protected Reader() {
        this.lock = this;
    }

    protected Reader(Object lock) {
        this.lock = lock;
    }

    public abstract void close() throws IOException;

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    public void reset() throws IOException {
        throw new IOException(new StringBuilder().append("Reader.reset: \u043a\u043b\u0430\u0441\u0441 ").append(this.getClass().getName()).append(" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043c\u0435\u0442\u043e\u0434 reset.").toString());
    }

    public void mark(int readLimit) throws IOException {
        throw new IOException(new StringBuilder().append("Reader.mark: \u043a\u043b\u0430\u0441\u0441 ").append(this.getClass().getName()).append(" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043c\u0435\u0442\u043e\u0434 mark.").toString());
    }

    public boolean markSupported() {
        return false;
    }

    public boolean ready() throws IOException {
        return false;
    }

    public int read() throws IOException {
        char[] buf = new char[1];
        return this.read(buf, 0, 1) == 1 ? buf[0] : -1;
    }

    public int read(char[] dst) throws IOException {
        return this.read(dst, 0, dst == null ? 0 : dst.length);
    }

    public long skip(long quantity) throws IOException {
        if (quantity < 0L) {
            throw new IllegalArgumentException("Reader.skip: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 quantity \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (quantity == 0L) {
            return 0L;
        }
        char[] buf = new char[256];
        long remaining = quantity;
        long result = 0L;
        while (result < quantity) {
            long readed;
            try {
                readed = this.read(buf, 0, remaining < 256L ? (int)remaining : 256);
                if (readed < 0L) {
                    break;
                }
            }
            catch (IOException e) {
                if (result > 0L) break;
                throw e;
            }
            remaining -= readed;
            result += readed;
        }
        return result;
    }
}

