/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import malik.emulator.util.StringBuilder;

public class Vector {
    protected int capacityIncrement;
    protected int elementCount;
    protected Object[] elementData;
    final Object monitor;

    public Vector() {
        this(16, 0);
    }

    public Vector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public Vector(int initialCapacity, int incrementCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Vector: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 initialCapacity \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        this.capacityIncrement = incrementCapacity;
        this.elementData = new Object[initialCapacity];
        this.monitor = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder result = new StringBuilder().append('[');
        Object object = this.monitor;
        synchronized (object) {
            Enumerator e = new Enumerator();
            int i = this.elementCount;
            while (i-- > 0) {
                result.append(e.nextElement());
                if (i <= 0) continue;
                result.append(", ");
            }
        }
        return result.append(']').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize() {
        Object object = this.monitor;
        synchronized (object) {
            int c = this.elementCount;
            Object[] d = this.elementData;
            if (c < this.elementData.length) {
                this.elementData = new Object[c];
                Array.copy(d, 0, this.elementData, 0, c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int minimumCapacity) {
        Object object = this.monitor;
        synchronized (object) {
            if (minimumCapacity > this.elementData.length) {
                this.madeLarger(minimumCapacity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertElementAt(Object element, int index) {
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            int c = this.elementCount;
            if (index > c || index < 0) {
                error = true;
            } else {
                Object[] d = this.elementData;
                if (c == this.elementData.length) {
                    d = this.madeLarger(c + 1);
                }
                if (c > index) {
                    Array.copy(d, index, d, index + 1, c - index);
                }
                d[index] = element;
                this.elementCount = c + 1;
            }
        }
        if (error) {
            throw new ArrayIndexOutOfBoundsException("Vector.insertElementAt: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(Object element) {
        Object object = this.monitor;
        synchronized (object) {
            int c = this.elementCount;
            Object[] d = this.elementData;
            if (c == this.elementData.length) {
                d = this.madeLarger(c + 1);
            }
            d[c] = element;
            this.elementCount = c + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElementAt(int index) {
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            int c = this.elementCount - 1;
            if (index > c || index < 0) {
                error = true;
            } else {
                Object[] d = this.elementData;
                if (c > index) {
                    Array.copy(d, index + 1, d, index, c - index);
                }
                this.elementCount = c;
                d[this.elementCount] = null;
            }
        }
        if (error) {
            throw new ArrayIndexOutOfBoundsException("Vector.removeElementAt: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllElements() {
        Object object = this.monitor;
        synchronized (object) {
            Array.fill(this.elementData, 0, this.elementCount, null);
            this.elementCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyInto(Object[] dst) {
        if (dst == null) {
            return;
        }
        Object object = this.monitor;
        synchronized (object) {
            Object[] d = this.elementData;
            int len = Math.min(this.elementCount, dst.length);
            int i = 0;
            while (i < len) {
                dst[i] = d[i];
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int size) {
        if (size < 0) {
            throw new ArrayIndexOutOfBoundsException("Vector.setSize: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 size \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        Object object = this.monitor;
        synchronized (object) {
            int c;
            Object[] d = this.elementData;
            if (size > this.elementData.length) {
                d = this.madeLarger(size);
            }
            if (size > (c = this.elementCount)) {
                Array.fill(d, c, size - c, null);
            } else if (size < c) {
                Array.fill(d, size, c - size, null);
            }
            this.elementCount = size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setElementAt(Object element, int index) {
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (index >= this.elementCount || index < 0) {
                error = true;
            } else {
                this.elementData[index] = element;
            }
        }
        if (error) {
            throw new ArrayIndexOutOfBoundsException("Vector.setElementAt: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    public boolean isEmpty() {
        return this.elementCount <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object element) {
        boolean result;
        Object object = this.monitor;
        synchronized (object) {
            block6: {
                Object[] d = this.elementData;
                if (element == null) {
                    result = Array.findb(d, this.elementCount - 1, null) >= 0;
                } else {
                    int i = this.elementCount;
                    while (i-- > 0) {
                        if (!element.equals(d[i])) continue;
                        result = true;
                        break block6;
                    }
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeElement(Object element) {
        boolean result;
        block9: {
            Object object = this.monitor;
            synchronized (object) {
                int i;
                Object[] d;
                int c;
                block6: {
                    block8: {
                        block7: {
                            c = this.elementCount;
                            d = this.elementData;
                            if (element != null) break block7;
                            i = Array.findf(d, 0, null);
                            if (i >= c) break block8;
                            result = true;
                            break block6;
                        }
                        i = 0;
                        while (i < c) {
                            if (element.equals(d[i])) {
                                result = true;
                                break block6;
                            }
                            ++i;
                        }
                    }
                    result = false;
                    break block9;
                }
                int index = i;
                i = --c - index;
                if (i > 0) {
                    Array.copy(d, index + 1, d, index, i);
                }
                this.elementCount = c;
                d[this.elementCount] = null;
            }
        }
        return result;
    }

    public int size() {
        return this.elementCount;
    }

    public int capacity() {
        return this.elementData.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object element) {
        int result;
        Object object = this.monitor;
        synchronized (object) {
            block5: {
                block8: {
                    Object[] d;
                    int c;
                    block7: {
                        block6: {
                            c = this.elementCount;
                            if (c > 0) break block6;
                            result = -1;
                            break block5;
                        }
                        d = this.elementData;
                        if (element != null) break block7;
                        int i = Array.findf(d, 0, null);
                        if (i >= c) break block8;
                        result = i;
                        break block5;
                    }
                    int i = 0;
                    while (i < c) {
                        if (element.equals(d[i])) {
                            result = i;
                            break block5;
                        }
                        ++i;
                    }
                }
                result = -1;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object element, int startFromIndex) {
        int result;
        if (startFromIndex < 0) {
            startFromIndex = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            block6: {
                block9: {
                    Object[] d;
                    int c;
                    block8: {
                        block7: {
                            c = this.elementCount;
                            if (startFromIndex < c) break block7;
                            result = -1;
                            break block6;
                        }
                        d = this.elementData;
                        if (element != null) break block8;
                        int i = Array.findf(d, startFromIndex, null);
                        if (i >= c) break block9;
                        result = i;
                        break block6;
                    }
                    int i = startFromIndex;
                    while (i < c) {
                        if (element.equals(d[i])) {
                            result = i;
                            break block6;
                        }
                        ++i;
                    }
                }
                result = -1;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object element) {
        int result;
        Object object = this.monitor;
        synchronized (object) {
            block4: {
                block7: {
                    Object[] d;
                    int c;
                    block6: {
                        block5: {
                            c = this.elementCount;
                            if (c > 0) break block5;
                            result = -1;
                            break block4;
                        }
                        d = this.elementData;
                        if (element != null) break block6;
                        int i = Array.findb(d, c - 1, null);
                        if (i < 0) break block7;
                        result = i;
                        break block4;
                    }
                    int i = c;
                    while (i-- > 0) {
                        if (!element.equals(d[i])) continue;
                        result = i;
                        break block4;
                    }
                }
                result = -1;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object element, int startFromIndex) {
        int result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            block5: {
                block8: {
                    Object[] d;
                    block7: {
                        block6: {
                            if (startFromIndex++ < this.elementCount) break block6;
                            error = true;
                            result = 0;
                            break block5;
                        }
                        d = this.elementData;
                        if (element != null) break block7;
                        int i = Array.findb(d, startFromIndex - 1, null);
                        if (i < 0) break block8;
                        result = i;
                        break block5;
                    }
                    int i = startFromIndex;
                    while (i-- > 0) {
                        if (!element.equals(d[i])) continue;
                        result = i;
                        break block5;
                    }
                }
                result = -1;
            }
        }
        if (error) {
            throw new ArrayIndexOutOfBoundsException("Vector.lastIndexOf: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 startFromIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object firstElement() {
        Object result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (this.elementCount <= 0) {
                error = true;
                result = null;
            } else {
                result = this.elementData[0];
            }
        }
        if (error) {
            throw new NoSuchElementException("Vector.firstElement: \u0432\u0435\u043a\u0442\u043e\u0440 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lastElement() {
        Object result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            int c = this.elementCount;
            if (c <= 0) {
                error = true;
                result = null;
            } else {
                result = this.elementData[c - 1];
            }
        }
        if (error) {
            throw new NoSuchElementException("Vector.lastElement: \u0432\u0435\u043a\u0442\u043e\u0440 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object elementAt(int index) {
        Object result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (index >= this.elementCount || index < 0) {
                error = true;
                result = null;
            } else {
                result = this.elementData[index];
            }
        }
        if (error) {
            throw new ArrayIndexOutOfBoundsException("Vector.elementAt: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    public Enumeration elements() {
        return new Enumerator();
    }

    private Object[] madeLarger(int minimumCapacity) {
        Object[] result = this.elementData;
        int oc = this.elementData.length;
        int delta = this.capacityIncrement;
        int nc = delta <= 0 ? (oc << 1) + 1 : oc + delta;
        if (nc < minimumCapacity) {
            nc = minimumCapacity;
        }
        Object[] objectArray = result;
        this.elementData = new Object[nc];
        result = this.elementData;
        Array.copy(objectArray, 0, this.elementData, 0, this.elementCount);
        return result;
    }

    private class Enumerator
    implements Enumeration {
        private int index;

        public boolean hasMoreElements() {
            return this.index < Vector.this.elementCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            Object result;
            boolean error = false;
            Vector parent = Vector.this;
            Object object = parent.monitor;
            synchronized (object) {
                int i = this.index;
                if (i >= parent.elementCount) {
                    error = true;
                    result = null;
                } else {
                    this.index = i + 1;
                    result = parent.elementData[i];
                }
            }
            if (error) {
                throw new NoSuchElementException("Enumeration.nextElement: \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c.");
            }
            return result;
        }
    }
}

