/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import malik.emulator.application.AppProxy;
import malik.emulator.application.DelayedAction;
import malik.emulator.application.InputDevice;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.KeyboardInterruptHandler;
import malik.emulator.application.MIDIPlayerListener;
import malik.emulator.application.PCMPlayerListener;
import malik.emulator.application.PlayerInterruptHandler;
import malik.emulator.application.PointerEvent;
import malik.emulator.application.PointerInterruptHandler;
import malik.emulator.application.Requestable;
import malik.emulator.application.RequestableQueue;
import malik.emulator.application.ThreadTerminationRecord;
import malik.emulator.application.ThreadTerminationRequest;
import malik.emulator.application.WindowResizeInterruptHandler;
import malik.emulator.application.WindowShowHideInterruptHandler;
import malik.emulator.fileformats.InputAdapter;
import malik.emulator.fileformats.text.mapped.AttributedTextDecoder;
import malik.emulator.fileformats.text.mapped.ManifestDecoder;
import malik.emulator.io.cloud.FileInputStream;
import malik.emulator.media.graphics.Paint;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.media.graphics.SystemFont;
import malik.emulator.media.graphics.TextPaint;
import malik.emulator.util.Queue;
import malik.emulator.util.RunnableQueue;
import malik.emulator.util.ThreadTerminationListener;
import malik.emulator.util.ThreadTerminationListenerCollection;
import malik.emulator.util.ThrowableStackTrace;

public final class Run
extends Requestable
implements ThreadTerminationListener {
    static final int ACTION_APP_LAUNCH = 16;
    static final int ACTION_APP_TERMINATE = 17;
    private static final int ACTION_VIRTUAL_KEYBOARD = 32;
    public static final Run instance = new Run();
    private AppProxy proxyActions;
    private ThreadTerminationListener proxyThreads;
    private KeyboardEvent eventKeyboard;
    private PointerEvent eventPointer;
    private final Hashtable playerListeners;
    private final RunnableQueue queueThreads;
    private final RequestableQueue queueActions;
    private final AttributedTextDecoder appManifest;
    private final InputDevice deviceKeyboardVirtual;
    private final InputDevice deviceKeyboardStandard;
    private final InputDevice devicePointingStandard;
    private final Paint fillScreenParameters;
    private final Paint drawMessageParameters;

    public static long workingTimeMillis() {
        return MalikSystem.syscall(0L, 13);
    }

    public static String getLocalizedApplicationError() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f";
    }

    static void main() {
        instance.execute();
    }

    private static void loadFromFile(InputAdapter adapter, String fileName) {
        FileInputStream stream = new FileInputStream("/META-INF/MANIFEST.MF");
        if (!stream.hasOpenError()) {
            try {
                try {
                    adapter.loadFromInputStream(stream);
                }
                finally {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException e) {
                e.printRealStackTrace();
            }
        }
    }

    private static AppProxy getStartAppProxyInstance() {
        AppProxy result = null;
        String typeName = System.getSystemProperty("malik.emulator.application.app.proxy.class");
        if (typeName == null) {
            System.err.println("Run: \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432\u0430\u0436\u043d\u043e\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e malik.emulator.application.app.proxy.class. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0444\u0430\u0439\u043b config.properties \u0438 \u0438\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0445 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a.");
            return null;
        }
        try {
            result = (AppProxy)Class.forName(typeName).newInstance();
        }
        catch (Exception e) {
            e.printRealStackTrace();
        }
        return result;
    }

    private Run() {
        SystemFont font = SystemFont.getDefault();
        int messageHeight = font.getHeight();
        ManifestDecoder manifest = new ManifestDecoder();
        Run.loadFromFile(manifest, "/META-INF/MANIFEST.MF");
        this.eventKeyboard = new KeyboardEvent();
        this.eventPointer = new PointerEvent();
        this.playerListeners = new Hashtable();
        this.queueThreads = new RunnableQueue();
        this.queueActions = new RequestableQueue();
        this.appManifest = manifest;
        this.deviceKeyboardVirtual = InputDevice.get(617388);
        this.deviceKeyboardStandard = InputDevice.get(527078);
        this.devicePointingStandard = InputDevice.get(888888);
        this.fillScreenParameters = new Paint(1024, 768);
        this.drawMessageParameters = new TextPaint(1024, messageHeight, font, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(int action, int param1, int param2, int param3) {
        RequestableQueue monitor;
        RequestableQueue requestableQueue = monitor = this.queueActions;
        synchronized (monitor) {
            monitor.addTailElement(null, (long)(action & 0xFFFF) | (long)(param1 & 0xFFFF) << 16 | (long)(param2 & 0xFFFF) << 32 | (long)(param3 & 0xFFFF) << 48);
            monitor.notify();
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(Runnable action, long delay) {
        RequestableQueue monitor;
        if (action == null) {
            return;
        }
        if (delay > 0L) {
            Scheduler.schedule(new DelayedAction(action), delay, 0);
            return;
        }
        RequestableQueue requestableQueue = monitor = this.queueActions;
        synchronized (monitor) {
            ((RunnableQueue)monitor).addTailElement(action);
            monitor.notify();
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        RequestableQueue monitor;
        super.terminate();
        RequestableQueue requestableQueue = monitor = this.queueActions;
        synchronized (monitor) {
            monitor.addTailElement(null, 17L);
            monitor.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void threadTerminated(Thread terminatedThread, Throwable exitThrowable) {
        if (exitThrowable != null) {
            this.drawMessage(Run.getLocalizedApplicationError());
            exitThrowable.printRealStackTrace();
            this.terminate();
        }
    }

    public void requestVirtualKeyboardEvent(int action, int key, int charCode) {
        if (action != 5 && action != 6 && action != 7) {
            throw new IllegalArgumentException("Run.requestVirtualKeyboardEvent: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 action \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        this.request(action | 0x20, key, charCode & 0xFFFF, charCode >>> 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillScreen(int colorRGB) {
        AttributedTextDecoder attributedTextDecoder = this.appManifest;
        synchronized (attributedTextDecoder) {
            RasterCanvas canvas = RasterCanvas.screen;
            Paint paint = this.fillScreenParameters;
            paint.setColor(colorRGB, false);
            canvas.fillRectangle(0, 0, canvas.getWidth(), canvas.getHeight(), paint);
            canvas.updateScreen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMessage(String message) {
        AttributedTextDecoder attributedTextDecoder = this.appManifest;
        synchronized (attributedTextDecoder) {
            RasterCanvas canvas = RasterCanvas.screen;
            Paint paint = this.drawMessageParameters;
            paint.setColor(-1069531072, true);
            int h = paint.getHeight();
            paint.translateTo(0, (865 * canvas.getHeight() >> 10) - (h >> 1));
            int w = canvas.getWidth();
            paint.setClip(0, 0, w, h);
            canvas.fillRectangle(0, 0, w, h, paint);
            if (message != null) {
                SystemFont font = SystemFont.getDefault();
                paint.setColor(0xFFFFFF, false);
                canvas.drawString(message, w - font.stringWidth(message) >> 1, font.getBaselinePosition(), paint);
            }
            canvas.updateScreen();
        }
    }

    public void setAppProxy(AppProxy proxy) {
        this.proxyActions = proxy;
    }

    public void setPointerEvent(PointerEvent event) {
        if (event == null) {
            throw new NullPointerException("Run.setPointerEvent: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 event \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.eventPointer = event;
    }

    public void setKeyboardEvent(KeyboardEvent event) {
        if (event == null) {
            throw new NullPointerException("Run.setKeyboardEvent: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 event \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.eventKeyboard = event;
    }

    public void setThreadTerminationListener(ThreadTerminationListener listener) {
        this.proxyThreads = listener;
    }

    public void setPCMPlayerListener(int playerHandle, PCMPlayerListener listener) {
        this.setPlayerListener(playerHandle, listener);
    }

    public void setMIDIPlayerListener(int playerHandle, MIDIPlayerListener listener) {
        this.setPlayerListener(playerHandle, listener);
    }

    public String[] getAppPropertyAttributes(String key) {
        return this.appManifest.getAttributes(key);
    }

    public String getAppProperty(String key) {
        return this.appManifest.get(key);
    }

    public PointerEvent getPointerEvent() {
        return this.eventPointer;
    }

    public KeyboardEvent getKeyboardEvent() {
        return this.eventKeyboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestThreadTerminated(Thread terminatedThread, Throwable exitThrowable) {
        RequestableQueue monitor;
        RequestableQueue requestableQueue = monitor = this.queueActions;
        synchronized (monitor) {
            this.queueThreads.addTailElement(new ThreadTerminationRecord(terminatedThread, exitThrowable));
            monitor.notify();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    void notifyPlayerListener(int playerHandle, int blockIndexForLoad) {
        Object listener = this.playerListeners.get(new Integer(playerHandle));
        if (listener instanceof PCMPlayerListener) {
            ((PCMPlayerListener)listener).endOfBlock(playerHandle, blockIndexForLoad);
        }
        if (listener instanceof MIDIPlayerListener) {
            ((MIDIPlayerListener)listener).endOfTrack(playerHandle);
        }
    }

    ThreadTerminationListener getThreadTerminationListener() {
        ThreadTerminationListener result = this.proxyThreads;
        return result == null ? this : result;
    }

    private void execute() {
        Throwable exitThrowable;
        ThreadTerminationRequest listener = new ThreadTerminationRequest();
        ThreadTerminationListenerCollection.instance.addListener(listener);
        try {
            exitThrowable = null;
            try {
                ThrowableStackTrace.enable();
                this.drawMessage("\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435\u2026");
                if (this.findAppProxy()) {
                    this.registerInterruptHandlers();
                    this.lifecycle();
                }
            }
            catch (Throwable e) {
                exitThrowable = e;
            }
        }
        finally {
            ThreadTerminationListenerCollection.instance.removeListener(listener);
        }
        MalikInterrupt.disable();
        try {
            this.getThreadTerminationListener().threadTerminated(Thread.currentThread(), exitThrowable);
        }
        catch (Throwable throwable) {}
        System.out.close();
        System.err.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lifecycle() {
        RunnableQueue queueThreads = this.queueThreads;
        RequestableQueue queueActions = this.queueActions;
        while (true) {
            try {
                while (true) {
                    this.waitAction();
                    boolean empty = false;
                    long actionByUser = 0L;
                    Runnable actionByApplication = null;
                    RequestableQueue requestableQueue = queueActions;
                    synchronized (requestableQueue) {
                        if (!queueThreads.isEmpty()) {
                            actionByApplication = queueThreads.peekHeadRunnable();
                            ((Queue)queueThreads).removeHeadElement();
                        } else if (!queueActions.isEmpty()) {
                            actionByUser = queueActions.peekHeadLong();
                            actionByApplication = queueActions.peekHeadRunnable();
                            ((Queue)queueActions).removeHeadElement();
                        } else {
                            empty = true;
                        }
                    }
                    if (empty) continue;
                    if (actionByApplication != null) {
                        actionByApplication.run();
                        continue;
                    }
                    if (this.handleActionMustTerminated(actionByUser)) break;
                }
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitAction() {
        RequestableQueue monitor;
        RequestableQueue requestableQueue = monitor = this.queueActions;
        synchronized (monitor) {
            while (true) {
                try {
                    monitor.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void registerInterruptHandlers() {
        PlayerInterruptHandler handler = new PlayerInterruptHandler();
        MalikInterrupt.register(16, new KeyboardInterruptHandler());
        MalikInterrupt.register(17, new PointerInterruptHandler());
        MalikInterrupt.register(18, new WindowShowHideInterruptHandler());
        MalikInterrupt.register(19, new WindowResizeInterruptHandler());
        MalikInterrupt.register(30, handler);
        MalikInterrupt.register(31, handler);
        Runtime.getRuntime().startInterruptHandling();
    }

    private void setPlayerListener(int playerHandle, Object listener) {
        Integer key = new Integer(playerHandle);
        if (listener == null) {
            this.playerListeners.remove(key);
            return;
        }
        this.playerListeners.put(key, listener);
    }

    private boolean findAppProxy() {
        AppProxy proxy = Run.getStartAppProxyInstance();
        if (proxy == null) {
            System.err.println("\u0420\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f AppProxy \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430: \u0437\u0430\u043f\u0443\u0441\u043a \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
            this.drawMessage(Run.getLocalizedApplicationError());
            return false;
        }
        this.proxyActions = proxy;
        this.request(16, 0, 0, 0);
        return true;
    }

    private boolean handleActionMustTerminated(long code) {
        AppProxy proxy = this.proxyActions;
        if (proxy == null) {
            return (char)code == '\u0011';
        }
        char action = (char)code;
        char param1 = (char)(code >> 16);
        char param2 = (char)(code >> 32);
        char param3 = (char)(code >> 48);
        PointerEvent ptrEvent = this.eventPointer;
        KeyboardEvent kbdEvent = this.eventKeyboard;
        ptrEvent.translateReset();
        switch (action) {
            default: {
                break;
            }
            case '\u0001': {
                proxy.windowSizeChanged(param2, param3);
                break;
            }
            case '\u0002': {
                proxy.windowShow();
                break;
            }
            case '\u0003': {
                proxy.windowHide();
                break;
            }
            case '\u0005': 
            case '\u0006': 
            case '\u0007': 
            case '%': 
            case '&': 
            case '\'': {
                InputDevice device = (action & 0x20) == 0 ? this.deviceKeyboardStandard : this.deviceKeyboardVirtual;
                kbdEvent.addStory(action & 0xF, param1, param2 | param3 << 16, device, 257, 0L);
                proxy.keyboardEvent(kbdEvent);
                break;
            }
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\u000e': 
            case '\u000f': {
                InputDevice device = this.devicePointingStandard;
                ptrEvent.addStory(action, param1, param2, param3, device, 8194, 0L);
                proxy.pointerEvent(ptrEvent);
                break;
            }
            case '\u0010': {
                proxy.appLaunch();
                break;
            }
            case '\u0011': {
                proxy.appTerminate();
                return true;
            }
        }
        return false;
    }
}

