/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.util;

import malik.emulator.util.Queue;

public class ObjectQueue
extends Queue {
    protected Object[] objects;

    public ObjectQueue() {
        this(16);
    }

    public ObjectQueue(int initialCapacity) {
        super(initialCapacity);
        initialCapacity = this.capacity;
        this.objects = new Object[initialCapacity];
    }

    public void clear() {
        Object[] q = this.objects;
        int c = this.capacity;
        int t = this.tail;
        int i = this.head;
        while (i != t) {
            q[i] = null;
            i = this.nextIndex(i, c);
        }
        super.clear();
    }

    public void removeHeadElement() {
        int h = this.head;
        if (h != this.tail) {
            this.objects[h] = null;
            this.advanceHead(h);
        }
    }

    public void addTailElement(Object objectElement) {
        Object[] q = this.objects;
        if (this.freeElements() == 0) {
            int c = (this.capacity << 1) - 1;
            this.objects = this.expand(q, c);
            q = this.objects;
            this.reset(c);
        }
        int t = this.tail;
        q[t] = objectElement;
        this.advanceTail(t);
    }

    public final Object peekHeadObject() {
        return this.objects[this.head];
    }
}

