/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayOutputStream
extends OutputStream {
    protected int count;
    protected byte[] buf;

    public ByteArrayOutputStream() {
        this.count = 0;
        this.buf = new byte[32];
    }

    public ByteArrayOutputStream(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("ByteArrayOutputStream: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 initialCapacity \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        this.count = 0;
        this.buf = new byte[initialCapacity];
    }

    public void close() throws IOException {
    }

    public void write(int src) {
        int count = this.count;
        int newCount = count + 1;
        byte[] buf = this.buf;
        if (newCount > this.buf.length) {
            byte[] byArray = buf;
            buf = this.buf = new byte[Math.max((count << 1) + 1, newCount)];
            Array.copy(byArray, 0, this.buf, 0, count);
        }
        buf[count] = (byte)src;
        this.count = newCount;
    }

    public void write(byte[] src) throws IOException {
        if (src == null) {
            throw new NullPointerException("ByteArrayOutputStream.write: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int length = src.length;
        if (length <= 0) {
            return;
        }
        int count = this.count;
        int newCount = count + length;
        byte[] buf = this.buf;
        if (newCount > this.buf.length) {
            byte[] byArray = buf;
            buf = this.buf = new byte[Math.max((count << 1) + 1, newCount)];
            Array.copy(byArray, 0, this.buf, 0, count);
        }
        Array.copy(src, 0, buf, count, length);
        this.count = newCount;
    }

    public void write(byte[] src, int offset, int length) {
        if (src == null) {
            throw new NullPointerException("ByteArrayOutputStream.write: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("ByteArrayOutputStream.write: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (length <= 0) {
            return;
        }
        int count = this.count;
        int newCount = count + length;
        byte[] buf = this.buf;
        if (newCount > this.buf.length) {
            byte[] byArray = buf;
            buf = this.buf = new byte[Math.max((count << 1) + 1, newCount)];
            Array.copy(byArray, 0, this.buf, 0, count);
        }
        Array.copy(src, offset, buf, count, length);
        this.count = newCount;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public byte[] toByteArray() {
        int len = this.count;
        byte[] result = new byte[len];
        Array.copy(this.buf, 0, result, 0, len);
        return result;
    }
}

