/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.time;

import java.util.TimeZone;
import malik.emulator.time.DateTimeFormat;
import malik.emulator.time.LocaleTimeZone;

public class DefaultFormat
implements DateTimeFormat {
    private static final String[] DAYS = new String[]{"\u0432\u043e\u0441\u043a\u0440\u0435\u0441\u0435\u043d\u044c\u0435", "\u043f\u043e\u043d\u0435\u0434\u0435\u043b\u044c\u043d\u0438\u043a", "\u0432\u0442\u043e\u0440\u043d\u0438\u043a", "\u0441\u0440\u0435\u0434\u0430", "\u0447\u0435\u0442\u0432\u0435\u0440\u0433", "\u043f\u044f\u0442\u043d\u0438\u0446\u0430", "\u0441\u0443\u0431\u0431\u043e\u0442\u0430"};
    private static final String[] MONTHS = new String[]{"\u044f\u043d\u0432\u0430\u0440\u044f", "\u0444\u0435\u0432\u0440\u0430\u043b\u044f", "\u043c\u0430\u0440\u0442\u0430", "\u0430\u043f\u0440\u0435\u043b\u044f", "\u043c\u0430\u044f", "\u0438\u044e\u043d\u044f", "\u0438\u044e\u043b\u044f", "\u0430\u0432\u0433\u0443\u0441\u0442\u0430", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044f", "\u043e\u043a\u0442\u044f\u0431\u0440\u044f", "\u043d\u043e\u044f\u0431\u0440\u044f", "\u0434\u0435\u043a\u0430\u0431\u0440\u044f"};

    public static char[] asTwoChars(int num) {
        if (num < 0 || num > 99) {
            throw new IllegalArgumentException("DefaultFormat.asTwoChars: \u0434\u0432\u0443\u0437\u043d\u0430\u0447\u043d\u0430\u044f \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0435 \u043e\u0442 0 \u0434\u043e 99.");
        }
        return new char[]{(char)(num / 10 + 48), (char)(num % 10 + 48)};
    }

    public static char[] asThreeChars(int num) {
        if (num < 0 || num > 999) {
            throw new IllegalArgumentException("DefaultFormat.asThreeChars: \u0442\u0440\u0451\u0445\u0437\u043d\u0430\u0447\u043d\u0430\u044f \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0435 \u043e\u0442 0 \u0434\u043e 999.");
        }
        return new char[]{(char)(num / 100 + 48), (char)(num % 100 / 10 + 48), (char)(num % 10 + 48)};
    }

    public String represent(int era, int year, int month, int day, int weekday, int hour, int minute, int second, int millis, TimeZone zone) {
        return String.valueOf(this.getWeekDayRepresentation(weekday)) + ", " + day + ' ' + this.getMonthRepresentation(month) + ' ' + year + (era == 0 ? " \u0434\u043e \u043d.\u044d., " : (era == 1 && year <= 1000 ? " \u043d.\u044d., " : ", ")) + String.valueOf(DefaultFormat.asTwoChars(hour)) + ':' + String.valueOf(DefaultFormat.asTwoChars(minute)) + ':' + String.valueOf(DefaultFormat.asTwoChars(second)) + ',' + String.valueOf(DefaultFormat.asThreeChars(millis)) + ' ' + (zone instanceof LocaleTimeZone ? ((LocaleTimeZone)zone).toString(era, year, month, day, weekday, 3600000 * hour + 60000 * minute + 1000 * second + millis) : zone.toString());
    }

    protected String getWeekDayRepresentation(int weekday) {
        return DAYS[weekday - 1];
    }

    protected String getMonthRepresentation(int month) {
        return MONTHS[month];
    }
}

