{
    InstallWindow используется для создания окна, в котором пользователь
    выполняет установку новой программы на Малик Эмулятор.
    Этот исходный текст является частью Малик Эмулятора.

    Следующие файлы используются этим исходным текстом:
        installwindow.lfm
    На них так же распространяются те же права, как и на этот исходный текст.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Малик Эмулятор – свободная программа: вы можете перераспространять её и/или
    изменять её на условиях Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Малик Эмулятор распространяется в надежде, что он может быть полезен,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЁННЫХ ЦЕЛЕЙ. Подробнее см. в Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <http://www.gnu.org/licenses/>.
}

unit InstallWindow;

{$MODE DELPHI}

interface

uses
    Classes,
    SysUtils,
    Controls,
    StdCtrls,
    Lang,
    StaticRecompilers,
    EmulatorInterfaces,
    FileBrowsingWindow,
    DirectoryBrowsingWindow;

{%region public }
type
    StaticRecompiler_Array1d = array of StaticRecompiler;

    TInstallForm = class(TEmulatorFormWithDialog)
        installButton: TButton;
        cancelButton: TButton;
        programmeBox: TGroupBox;
        archiveLabel: TLabel;
        archive: TEdit;
        archiveBrowse: TButton;
        platformLabel: TLabel;
        platformName: TComboBox;
        directoryBox: TGroupBox;
        directoryGames: TRadioButton;
        directoryApps: TRadioButton;
        directoryOther: TRadioButton;
        directory: TEdit;
        directorySelect: TButton;
        procedure archiveBrowseClick(sender: TObject);
        procedure directorySelectClick(sender: TObject);
        procedure radioButtonEnter(sender: TObject);
    private
        owner: MainWindowInterface;
        gamesDirectory: AnsiString;
        appsDirectory: AnsiString;
        platforms: StaticRecompiler_Array1d;
    public
        constructor create(theOwner: TComponent); override;
        procedure afterConstruction(); override;
        function getRecompiler(): StaticRecompiler;
        function getArchive(): AnsiString;
        function getDestinationDirectory(): AnsiString;
    end;
{%endregion}

implementation

{$R *.LFM}

{%region routine }
    function StaticRecompiler_Array1d_create(length: int): StaticRecompiler_Array1d;
    begin
        setLength(result, length);
    end;
{%endregion}

{%region TInstallForm }
    constructor TInstallForm.create(theOwner: TComponent);
    var
        s: AnsiString;
    begin
        inherited create(theOwner);
        theOwner.getInterface(stringToGUID(MAIN_WINDOW_INTERFACE_GUID), owner);
        s := getEmulatorDirectory();
        gamesDirectory := s + DIRECTORY_GAMES;
        appsDirectory := s + DIRECTORY_APPS;
        platforms := StaticRecompiler_Array1d_create(getRecompilersCount());
    end;

    procedure TInstallForm.archiveBrowseClick(sender: TObject);
    var
        i: int;
        j: int;
        r: StaticRecompiler;
        browser: TFileBrowser;
        fileName: AnsiString;
        extension: AnsiString;
        platforms: TStrings;
    begin
        browser := TFileBrowser.create(owner.asObject() as TComponent);
        try
            if openDialog(browser) <> mrOK then begin
                exit;
            end;
            fileName := browser.getFileName();
        finally
            browser.free();
        end;
        archive.text := fileName;
        extension := '';
        for i := length(fileName) downto 1 do begin
            if fileName[i] = '.' then begin
                extension := copy(fileName, i + 1, length(fileName) - i);
                break;
            end;
        end;
        j := 0;
        platforms := platformName.items;
        platforms.beginUpdate();
        try
            platforms.clear();
            for i := 0 to getRecompilersCount() - 1 do begin
                r := StaticRecompilers.getRecompiler(i);
                if r.getArchiveExtension() = extension then begin
                    platforms.add(r.getPlatformName());
                    self.platforms[j] := r;
                    inc(j);
                end;
            end;
        finally
            platforms.endUpdate();
        end;
        if platforms.count > 0 then begin
            platformName.itemIndex := 0;
            installButton.enabled := true;
        end else begin
            platformName.itemIndex := -1;
            installButton.enabled := false;
        end;
    end;

    procedure TInstallForm.directorySelectClick(sender: TObject);
    var
        browser: TDirectoryBrowser;
        directory: AnsiString;
    begin
        browser := TDirectoryBrowser.create(owner.asObject() as TComponent);
        try
            directory := self.directory.text;
            browser.setDirectory(copy(directory, 1, length(directory) - 1));
            if openDialog(browser) <> mrOK then begin
                exit;
            end;
            self.directory.text := browser.getDirectory() + DIRECTORY_SEPARATOR;
        finally
            browser.free();
        end;
    end;

    procedure TInstallForm.radioButtonEnter(sender: TObject);
    var
        f: boolean;
    begin
        (sender as TRadioButton).checked := true;
        f := sender = directoryOther;
        directory.enabled := f;
        directorySelect.enabled := f;
        if sender = directoryGames then begin
            directory.text := gamesDirectory;
            exit;
        end;
        if sender = directoryApps then begin
            directory.text := appsDirectory;
            exit;
        end;
    end;

    procedure TInstallForm.afterConstruction();
    begin
        inherited afterConstruction();
        directory.text := gamesDirectory;
    end;

    function TInstallForm.getRecompiler(): StaticRecompiler;
    begin
        result := platforms[platformName.itemIndex];
    end;

    function TInstallForm.getArchive(): AnsiString;
    begin
        result := archive.text;
    end;

    function TInstallForm.getDestinationDirectory(): AnsiString;
    begin
        result := directory.text;
    end;
{%endregion}

end.

