/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.io;

public class ByteArrayInputStream extends InputStream
{
	protected int pos;
	protected int mark;
	protected int count;
	protected byte[] buf;

	public ByteArrayInputStream(byte[] buffer)
	{
		this.pos = 0;
		this.mark = 0;
		this.count = (buffer == null) ? 0 : buffer.length;
		this.buf = buffer;
	}

	public ByteArrayInputStream(byte[] buffer, int offset, int length)
	{
		this.pos = offset;
		this.mark = offset;
		this.count = offset + length;
		this.buf = buffer;
	}

	public void close()
			throws IOException
	{
	}

	public void reset()
	{
		pos = mark;
	}

	public void mark(int readLimit)
	{
		mark = pos;
	}

	public boolean markSupported()
	{
		return true;
	}

	public int read()
	{
		int p;
		if((p = pos) < count)
		{
			pos = p + 1;
			return buf[p] & 0xff;
		}
		return -1;
	}

	public int read(byte[] dst)
			throws IOException
	{
		int length;
		int avail;
		int p;
		int c;
		if(dst == null)
		{
			throw new NullPointerException("ByteArrayInputStream.read: " +
					"параметр dst равен нулевой ссылке.");
		}
		if((length = dst.length) <= 0)
		{
			return 0;
		}
		if((p = pos) >= (c = count))
		{
			return -1;
		}
		if(length > (avail = c - p))
		{
			length = avail;
		}
		Array.copy(buf, p, dst, 0, length);
		pos = p + length;
		return length;
	}

	public int read(byte[] dst, int offset, int length)
	{
		int lim;
		int len;
		int avail;
		int p;
		int c;
		if(dst == null)
		{
			throw new NullPointerException("ByteArrayInputStream.read: " +
					"параметр dst равен нулевой ссылке.");
		}
		if((lim = offset + length) > (len = dst.length) ||
				lim < offset || offset > len || offset < 0)
		{
			throw new ArrayIndexOutOfBoundsException("ByteArrayInputStream.read: " +
					"индекс выходит из диапазона.");
		}
		if(length <= 0)
		{
			return 0;
		}
		if((p = pos) >= (c = count))
		{
			return -1;
		}
		if(length > (avail = c - p))
		{
			length = avail;
		}
		Array.copy(buf, p, dst, offset, length);
		pos = p + length;
		return length;
	}

	public int available()
	{
		return count - pos;
	}

	public long skip(long bytesCount)
	{
		int p;
		long avail;
		if(bytesCount <= 0L)
		{
			return 0L;
		}
		if(bytesCount > (avail = (long) (count - (p = pos))))
		{
			bytesCount = avail;
		}
		pos = (int) (((long) p) + bytesCount);
		return bytesCount;
	}
}
