/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.util;

public class Timer extends Object
{
	private TimerThread thread;

	public Timer()
	{
		TimerThread t;
		this.thread = t = new TimerThread();
		t.start();
	}

	public void schedule(TimerTask task, long delay)
	{
		long time;
		TimerThread thread;
		if(task == null)
		{
			throw new NullPointerException("Timer.schedule: " +
					"параметр task равен нулевой ссылке.");
		}
		if(delay < 0L || (time = System.currentTimeMillis() + delay) < 0L)
		{
			throw new IllegalArgumentException("Timer.schedule: " +
					"недопустимое значение параметра delay.");
		}
		if((thread = this.thread) == null)
		{
			throw new IllegalStateException("Timer.schedule: " +
					"планирование новых задач было отменено.");
		}
		thread.schedule(task, time);
	}

	public void schedule(TimerTask task, Date execTime)
	{
		long time;
		TimerThread thread;
		if(task == null)
		{
			throw new NullPointerException("Timer.schedule: " +
					"параметр task равен нулевой ссылке.");
		}
		if(execTime == null)
		{
			throw new NullPointerException("Timer.schedule: " +
					"параметр execTime равен нулевой ссылке.");
		}
		if((time = execTime.getTime()) < 0L)
		{
			throw new IllegalArgumentException("Timer.schedule: " +
					"недопустимое значение выражения execTime.getTime().");
		}
		if((thread = this.thread) == null)
		{
			throw new IllegalStateException("Timer.schedule: " +
					"планирование новых задач было отменено.");
		}
		thread.schedule(task, time);
	}

	public void schedule(TimerTask task, long delay, long period)
	{
		long time;
		TimerThread thread;
		if(task == null)
		{
			throw new NullPointerException("Timer.schedule: " +
					"параметр task равен нулевой ссылке.");
		}
		if(delay < 0L || (time = System.currentTimeMillis() + delay) < 0L)
		{
			throw new IllegalArgumentException("Timer.schedule: " +
					"недопустимое значение параметра delay.");
		}
		if((thread = this.thread) == null)
		{
			throw new IllegalStateException("Timer.schedule: " +
					"планирование новых задач было отменено.");
		}
		thread.schedule(task, time, period, false);
	}

	public void schedule(TimerTask task, Date firstTime, long period)
	{
		long time;
		TimerThread thread;
		if(task == null)
		{
			throw new NullPointerException("Timer.schedule: " +
					"параметр task равен нулевой ссылке.");
		}
		if(firstTime == null)
		{
			throw new NullPointerException("Timer.schedule: " +
					"параметр firstTime равен нулевой ссылке.");
		}
		if((time = firstTime.getTime()) < 0L)
		{
			throw new IllegalArgumentException("Timer.schedule: " +
					"недопустимое значение выражения firstTime.getTime().");
		}
		if((thread = this.thread) == null)
		{
			throw new IllegalStateException("Timer.schedule: " +
					"планирование новых задач было отменено.");
		}
		thread.schedule(task, time, period, false);
	}

	public void scheduleAtFixedRate(TimerTask task, long delay, long period)
	{
		long time;
		TimerThread thread;
		if(task == null)
		{
			throw new NullPointerException("Timer.scheduleAtFixedRate: " +
					"параметр task равен нулевой ссылке.");
		}
		if(delay < 0L || (time = System.currentTimeMillis() + delay) < 0L)
		{
			throw new IllegalArgumentException("Timer.scheduleAtFixedRate: " +
					"недопустимое значение параметра delay.");
		}
		if((thread = this.thread) == null)
		{
			throw new IllegalStateException("Timer.scheduleAtFixedRate: " +
					"планирование новых задач было отменено.");
		}
		thread.schedule(task, time, period, true);
	}

	public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period)
	{
		long time;
		TimerThread thread;
		if(task == null)
		{
			throw new NullPointerException("Timer.scheduleAtFixedRate: " +
					"параметр task равен нулевой ссылке.");
		}
		if(firstTime == null)
		{
			throw new NullPointerException("Timer.scheduleAtFixedRate: " +
					"параметр firstTime равен нулевой ссылке.");
		}
		if((time = firstTime.getTime()) < 0L)
		{
			throw new IllegalArgumentException("Timer.scheduleAtFixedRate: " +
					"недопустимое значение выражения firstTime.getTime().");
		}
		if((thread = this.thread) == null)
		{
			throw new IllegalStateException("Timer.scheduleAtFixedRate: " +
					"планирование новых задач было отменено.");
		}
		thread.schedule(task, time, period, true);
	}

	public void cancel()
	{
		TimerThread thread;
		if((thread = this.thread) == null)
		{
			return;
		}
		this.thread = null;
		thread.terminate();
	}
}
