/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.util;

public abstract class TimerTask extends Object
		implements Runnable
{
	static final int STATE_FREE = 0;
	static final int STATE_SCHEDULED = 1;
	static final int STATE_EXECUTING = 2;
	static final int STATE_CANCELLED = 3;


	boolean periodic;
	boolean fixedRate;
	int state;
	long period;
	long nextExecutionTime;
	long shedExecutionTime;
	TimerThread owner;

	protected TimerTask()
	{
	}

	public abstract void run();

	public boolean cancel()
	{
		TimerThread t;
		return (t = owner) != null && t.cancel(this);
	}

	public long scheduledExecutionTime()
	{
		return shedExecutionTime;
	}
}
