/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.application;

final class InterruptHandlerForPointer extends InterruptHandlerForApplication
{
	InterruptHandlerForPointer(Run owner)
	{
		super(owner);
	}

	public void interrupt(long parameter)
	{
		int btn = ((int) (parameter >> 32)) & 0x0f;
		long event = btn == 0x0f ? Run.EVENT_POINTER_DRAGGED :
				((btn & 0x08) == 0 ? Run.EVENT_POINTER_PRESSED : Run.EVENT_POINTER_RELEASED);
		long button = (long) (btn & 0x07);
		long coords = parameter & 0xffffffffL;
		owner.setEvent((event << 60) | (button << 32) | coords);
	}
}
