/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.media.graphics;

class StringDrawDescriptor extends GraphicBufferWithAlphaDescriptor
{
	/* унаследованные поля:
	public int base;
	public int scan;
	public int sizes;
	public int alpha; */
	public int handle;
	public int style;
	public int coords;
	public int color;
	public int length;
	public int chars;

	StringDrawDescriptor()
	{
	}

	public final void assignStringUTF16(int charsAddress, int length, int x, int y, int colorARGB,
			int fontHandle, boolean underline, boolean strikeout, boolean alpha)
	{
		this.handle = fontHandle;
		this.style = 0x80000000 | (underline ? 0x01 : 0) | (strikeout ? 0x02 : 0);
		this.coords = (x & 0xffff) | (y << 16);
		this.color = alpha ? colorARGB : colorARGB | 0xff000000;
		this.length = length;
		this.chars = charsAddress;
	}

	public final void assignStringUTF32(int charsAddress, int length, int x, int y, int colorARGB,
			int fontHandle, boolean underline, boolean strikeout, boolean alpha)
	{
		this.handle = fontHandle;
		this.style = (underline ? 0x01 : 0) | (strikeout ? 0x02 : 0);
		this.coords = (x & 0xffff) | (y << 16);
		this.color = alpha ? colorARGB : colorARGB | 0xff000000;
		this.length = length;
		this.chars = charsAddress;
	}
}
