/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.io;

import java.io.*;
import malik.emulator.io.j2me.*;

public class PushRegistry extends Object
{
	public static void registerConnection(String url, String midlet, String filter)
			throws IOException, ClassNotFoundException
	{
		ImplementationManager.getConnectionFactory().registerConnection(url, midlet, filter);
	}

	public static boolean unregisterConnection(String url)
	{
		return ImplementationManager.getConnectionFactory().unregisterConnection(url);
	}

	public static long registerAlarm(String midlet, long time)
			throws ConnectionNotFoundException, ClassNotFoundException
	{
		throw new ConnectionNotFoundException("PushRegistry.registerAlarm: " +
				"система не поддерживает запуск приложений «по будильнику».");
	}

	public static String[] listConnections(boolean available)
	{
		return ImplementationManager.getConnectionFactory().listConnections(available);
	}

	public static String getFilter(String url)
	{
		return ImplementationManager.getConnectionFactory().getFilter(url);
	}

	public static String getMIDlet(String url)
	{
		return ImplementationManager.getConnectionFactory().getMIDlet(url);
	}


	private PushRegistry()
	{
	}
}
