/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.lcdui;

public class Command extends Object
{
	public static final int SCREEN = 1;
	public static final int BACK = 2;
	public static final int CANCEL = 3;
	public static final int OK = 4;
	public static final int HELP = 5;
	public static final int STOP = 6;
	public static final int EXIT = 7;
	public static final int ITEM = 8;


	private int type;
	private int priority;
	private int truncatedWidth;
	private Font truncatedFont;
	private String label;
	private String longLabel;
	private String truncated;

	public Command(String label, int type, int priority)
	{
		this(label, null, type, priority);
	}

	public Command(String label, String longLabel, int type, int priority)
	{
		if(label == null)
		{
			throw new NullPointerException("Command: " +
					"параметр label равен нулевой ссылке.");
		}
		if(type < 1 || type > 8)
		{
			throw new IllegalArgumentException("Command: " +
					"недопустимое значение параметра type.");
		}
		this.type = type;
		this.priority = priority;
		this.label = label;
		this.longLabel = longLabel;
	}

	public int getCommandType()
	{
		return type;
	}

	public int getPriority()
	{
		return priority;
	}

	public String getLabel()
	{
		return label;
	}

	public String getLongLabel()
	{
		return longLabel;
	}

	public final int getRealType()
	{
		return type;
	}

	public final int getRealPriority()
	{
		return priority;
	}

	public final String getRealLabel()
	{
		return label;
	}

	public final String getTruncatedLabel(Font font, int width)
	{
		String result;
		if(font == truncatedFont && width == truncatedWidth)
		{
			return truncated;
		}
		truncatedWidth = width;
		truncatedFont = font;
		truncated = result = Displayable.truncate(label, font, width);
		return result;
	}
}
