/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.pki;

import java.io.*;

public class CertificateException extends IOException
{
	public static final byte BAD_EXTENSIONS = 1;
	public static final byte CERTIFICATE_CHAIN_TOO_LONG = 2;
	public static final byte EXPIRED = 3;
	public static final byte UNAUTHORIZED_INTERMEDIATE_CA = 4;
	public static final byte MISSING_SIGNATURE = 5;
	public static final byte NOT_YET_VALID = 6;
	public static final byte SITENAME_MISMATCH = 7;
	public static final byte UNRECOGNIZED_ISSUER = 8;
	public static final byte UNSUPPORTED_SIGALG = 9;
	public static final byte INAPPROPRIATE_KEY_USAGE = 10;
	public static final byte BROKEN_CHAIN = 11;
	public static final byte ROOT_CA_EXPIRED = 12;
	public static final byte UNSUPPORTED_PUBLIC_KEY_TYPE = 13;
	public static final byte VERIFICATION_FAILED = 14;

	private static String getStatusMessage(int status)
	{
		switch(status)
		{
		default:
			return "Причина неизвестна (" + status + ")";
		case BAD_EXTENSIONS:
			return "Сертификат имеет нераспознанные критические расширения.";
		case CERTIFICATE_CHAIN_TOO_LONG:
			return "Цепочка сертификатов сервера превышает максимально допустимую длину, " +
					"позволенную центром сертификации.";
		case EXPIRED:
			return "Срок действия сертификата истёк.";
		case UNAUTHORIZED_INTERMEDIATE_CA:
			return "Промежуточный сертификат в цепочке не имеет права быть промежуточным " +
					"согласно центру сертификации.";
		case MISSING_SIGNATURE:
			return "Сертификат не содержит подписи.";
		case NOT_YET_VALID:
			return "Сертификат не действителен.";
		case SITENAME_MISMATCH:
			return "Сертификат не содержит корректное имя сайта.";
		case UNRECOGNIZED_ISSUER:
			return "Сертификат был выдан нераспознанной организацией.";
		case UNSUPPORTED_SIGALG:
			return "Сертификат был подписан неподдерживаемым алгоритмом.";
		case INAPPROPRIATE_KEY_USAGE:
			return "Открытый ключ сертификата был использован таким образом, " +
					"который центр сертификации считает нецелесообразным.";
		case BROKEN_CHAIN:
			return "Сертификат в цепочке не был выдан следующим центром сертификации в цепочке.";
		case ROOT_CA_EXPIRED:
			return "Срок действия открытого ключа корневого центра сертификации истёк.";
		case UNSUPPORTED_PUBLIC_KEY_TYPE:
			return "Сертификат имеет открытый ключ неподдерживаемого типа.";
		case VERIFICATION_FAILED:
			return "Сертификат не прошёл проверку.";
		}
	}


	private byte status;
	private Certificate reference;

	public CertificateException(Certificate reference, byte status)
	{
		super(getStatusMessage(status));
		this.status = status;
		this.reference = reference;
	}

	public CertificateException(String message, Certificate reference, byte status)
	{
		super(message);
		this.status = status;
		this.reference = reference;
	}

	public byte getReason()
	{
		return status;
	}

	public Certificate getCertificate()
	{
		return reference;
	}
}
