/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp;

final class KeyCodeSet extends Object
{
	private int keyCodeForUp;
	private int keyCodeForDown;
	private int keyCodeForLeft;
	private int keyCodeForRight;
	private int keyCodeForSelect;
	private int keyCodeForSoft1;
	private int keyCodeForSoft2;
	private String name;

	KeyCodeSet(String name, int keyCodeForUp, int keyCodeForDown, int keyCodeForLeft,
			int keyCodeForRight, int keyCodeForSelect, int keyCodeForSoft1, int keyCodeForSoft2)
	{
		this.keyCodeForUp = keyCodeForUp;
		this.keyCodeForDown = keyCodeForDown;
		this.keyCodeForLeft = keyCodeForLeft;
		this.keyCodeForRight = keyCodeForRight;
		this.keyCodeForSelect = keyCodeForSelect;
		this.keyCodeForSoft1 = keyCodeForSoft1;
		this.keyCodeForSoft2 = keyCodeForSoft2;
		this.name = name;
	}

	public int[] getKeyCodesAsArray()
	{
		return new int[] {
				keyCodeForUp, keyCodeForDown, keyCodeForLeft, keyCodeForRight,
				keyCodeForSelect, keyCodeForSoft1, keyCodeForSoft2
		};
	}

	public String getName()
	{
		return name;
	}
}
