/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp.console;

import javax.microedition.rms.*;
import malik.emulator.midp.*;

public class ListRecordStoresCommand extends ConsoleCommand
{
	public ListRecordStoresCommand()
	{
		super("записи",
				"Использование:\n" +
				"  записи\n" +
				"Выводит на консоль список всех записей приложения. " +
				"В скобках указано текущее состояние записи.");
	}

	public void run(String[] arguments)
	{
		int i;
		int len;
		String[] list;
		String record;
		ConsoleScreen console;
		if((console = getConsoleScreen()) == null)
		{
			return;
		}
		for(len = (list = RecordStore.listRecordStores()).length, i = 0; i < len; i++)
		{
			console.print(record = list[i]);
			console.print(" (");
			switch(RecordStore.getState(record))
			{
			case RecordStore.STATE_RESERV:
				console.print("зарезервирована");
				break;
			case RecordStore.STATE_OPENED:
				console.print("открыта");
				break;
			case RecordStore.STATE_CLOSED:
				console.print("закрыта");
				break;
			default:
				console.print("ошибка");
				break;
			}
			console.print(")\n");
		}
	}
}
