/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp.console;

import javax.microedition.lcdui.*;
import malik.emulator.fileformats.text.mapped.*;
import malik.emulator.midp.*;

public class MIDletCommand extends ConsoleCommand
{
	public MIDletCommand()
	{
		super("мидлет",
				"Использование:\n" +
				"  мидлет\n" +
				"Выводит на консоль имя класса мидлета и название текущего выполняющегося " + 
				"приложения.");
	}

	public void run(String[] arguments)
	{
		int i;
		String[] parameterValue;
		String parameterKey;
		String name;
		MIDletProxy proxy;
		ConsoleScreen console;
		AttributableMappedTextDecoder descriptor;
		if((console = getConsoleScreen()) == null)
		{
			return;
		}
		descriptor = (proxy = MIDletProxy.getInstance()).getMIDletDescriptor();
		console.print("Название приложения: ");
		console.print(descriptor.get("MIDlet-Name"));
		console.println();
		name = proxy.getRegisteredMIDlet().getClass().getName();
		for(i = 1; true; i++)
		{
			parameterKey = "MIDlet-".concat(Integer.toString(i));
			if((parameterValue = descriptor.getAttributes(parameterKey)) == null)
			{
				break;
			}
			if(parameterValue.length >= 3 && name.equals(parameterValue[2]))
			{
				console.print("Название мидлета: ");
				console.print(parameterValue[0]);
				console.println();
				console.print("Класс мидлета: ");
				console.print(name);
				console.println();
				break;
			}
		}
	}
}
