/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp.protocol.file;

import java.io.*;
import javax.microedition.io.*;
import malik.emulator.io.cloud.*;
import malik.emulator.io.j2me.*;

public class ReadOnlyFileConnection extends CustomConnection
		implements InputConnection
{
	private boolean opened;
	private String fileName;

	public ReadOnlyFileConnection(String url, String fileName)
	{
		super(url);
		this.fileName = fileName;
	}

	public void close()
			throws IOException
	{
		this.fileName = null;
		super.close();
	}

	public InputStream openInputStream()
			throws IOException
	{
		FileInputStream result;
		if(closed)
		{
			throw new IOException("InputConnection.openInputStream: " +
					"соединение закрыто.");
		}
		if(opened)
		{
			throw new IOException("InputConnection.openInputStream: " +
					"поток ввода уже открывался раннее.");
		}
		opened = true;
		(result = new FileInputStream(fileName)).checkOpenError();
		return result;
	}

	public DataInputStream openDataInputStream()
			throws IOException
	{
		FileInputStream result;
		if(closed)
		{
			throw new IOException("InputConnection.openDataInputStream: " +
					"соединение закрыто.");
		}
		if(opened)
		{
			throw new IOException("InputConnection.openDataInputStream: " +
					"поток ввода уже открывался раннее.");
		}
		opened = true;
		(result = new FileInputStream(fileName)).checkOpenError();
		return new DataInputStream(result);
	}
}
