/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp.protocol.sms;

import java.io.*;
import java.util.*;
import javax.wireless.messaging.*;
import malik.emulator.io.j2me.*;

public class ServerMessageConnection extends ClientMessageConnection
		implements InboundConnection
{
	QueueOfObjects incomingMessages;
	MessageListener listener;
	private int localPort;

	public ServerMessageConnection(String url, int localPort)
	{
		super(url);
		this.incomingMessages = new QueueOfObjects(4);
		this.localPort = localPort;
	}

	public void close()
			throws IOException
	{
		boolean closed;
		Object monitor;
		this.listener = null;
		closed = this.closed;
		super.close();
		if(closed)
		{
			return;
		}
		synchronized(monitor = incomingMessages)
		{
			monitor.notifyAll();
		}
		ImplementationManager.getConnectionFactory().closeConnection(this);
	}

	public void setMessageListener(MessageListener listener)
			throws IOException
	{
		if(closed)
		{
			throw new IOException("MessageConnection.setMessageListener: " +
					"соединение закрыто.");
		}
		this.listener = listener;
	}

	public Message receive()
			throws IOException, InterruptedIOException
	{
		boolean interrupted;
		Message result;
		QueueOfObjects messagesQueue;
		if(closed)
		{
			throw new IOException("MessageConnection.receive: " +
					"соединение закрыто.");
		}
		synchronized(messagesQueue = incomingMessages)
		{
			label0:
			{
				while(messagesQueue.isEmpty())
				{
					try
					{
						messagesQueue.wait();
					}
					catch(InterruptedException e)
					{
						e.printRealStackTrace();
					}
					if(closed)
					{
						interrupted = true;
						result = null;
						break label0;
					}
				}
				interrupted = false;
				result = (Message) messagesQueue.peek();
				messagesQueue.removeTailElement();
			}
		}
		if(interrupted)
		{
			throw new InterruptedIOException("MessageConnection.receive: " +
					"соединение было закрыто во время ожидания сообщения.");
		}
		return result;
	}

	public int getLocalPort()
			throws IOException
	{
		if(closed)
		{
			throw new IOException("InboundConnection.getLocalPort: " +
					"соединение закрыто.");
		}
		return localPort;
	}

	public String getProtocol()
			throws IOException
	{
		if(closed)
		{
			throw new IOException("InboundConnection.getProtocol: " +
					"соединение закрыто.");
		}
		return "sms";
	}
}
