/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package com.nokia.mid.ui;

import java.io.*;
import javax.microedition.lcdui.*;
import malik.emulator.fileformats.graphics.*;
import malik.emulator.io.j2me.*;

public class DirectUtils extends Object
{
	private static final Class DIRECT_GRAPHICS_IMPLEMENTATION;

	static
	{
		DIRECT_GRAPHICS_IMPLEMENTATION = DirectGraphicsExtension.class;
	}

	public static Image createImage(int width, int height, int colorARGB)
	{
		int i;
		int[] pixels;
		Image result;
		i = (pixels = (result = Image.createImage(width, height)).getBuffer().getPixels()).length;
		for(; i-- > 0; pixels[i] = colorARGB);
		return result;
	}

	public static Image createImage(byte[] src, int offset, int length)
	{
		int i;
		int lim;
		int len;
		int[] pixels;
		Image result;
		InputStream stream;
		ImageDecoder decoder;
		if(src == null)
		{
			throw new NullPointerException("DirectUtils.createImage: " +
					"параметр src равен нулевой ссылке.");
		}
		if((lim = offset + length) > (len = src.length) ||
				lim < offset || offset > len || offset < 0)
		{
			throw new ArrayIndexOutOfBoundsException("DirectUtils.createImage: " +
					"индекс выходит из диапазона.");
		}
		try
		{
			if((decoder = ImplementationManager.getImageDecoder(stream =
					new ByteArrayInputStream(src, offset, length))) == null)
			{
				throw new IllegalArgumentException("DirectUtils.createImage: " +
						"ошибка декодирования изображения.");
			}
			decoder.loadFromInputStream(stream);
		}
		catch(IOException e)
		{
			throw new IllegalArgumentException("DirectUtils.createImage: " +
					"ошибка декодирования изображения.");
		}
		if(decoder.isEmpty())
		{
			throw new IllegalArgumentException("DirectUtils.createImage: " +
					"ошибка декодирования изображения.");
		}
		result = Image.createImage(decoder.getWidth(), decoder.getHeight());
		Array.copy(decoder.getPixels(), 0, pixels = result.getBuffer().getPixels(), 0,
				len = pixels.length);
		if(!decoder.isAlphaSupported())
		{
			for(i = len; i-- > 0; pixels[i] |= 0xff000000);
		}
		return result;
	}

	public static DirectGraphics getDirectGraphics(Graphics render)
	{
		DirectGraphics result;
		Object graphicsExtension;
		if(render == null)
		{
			throw new NullPointerException("DirectUtils.getDirectGraphics: " +
					"параметр render равен нулевой ссылке.");
		}
		if((graphicsExtension = render.getExtension(DIRECT_GRAPHICS_IMPLEMENTATION)) != null)
		{
			return (DirectGraphics) graphicsExtension;
		}
		render.addExtension(result = new DirectGraphicsExtension(render));
		return result;
	}


	private DirectUtils()
	{
	}
}
