/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package java.io;

import malik.emulator.i18n.*;

public class OutputStreamWriter extends Writer
{
    private final Writer out;

    public OutputStreamWriter(OutputStream stream) {
        Writer writer;
        this.out = writer = Helper.createWriter(stream);
        this.lock = writer.lock;
    }

    public OutputStreamWriter(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        Writer writer;
        this.out = writer = Helper.createWriter(stream, encoding);
        this.lock = writer.lock;
    }

    public void close() throws IOException {
        out.close();
    }

    public void flush() throws IOException {
        out.flush();
    }

    public void write(int charData) throws IOException {
        out.write(charData);
    }

    public void write(char[] src, int offset, int length) throws IOException {
        long bounds;
        offset = (int) (bounds = Array.intersectBound(src == null ? 0 : src.length, offset, length));
        length = (int) (bounds >> 32);
        out.write(src, offset, length);
    }

    public void write(String string, int offset, int length) throws IOException {
        long bounds;
        offset = (int) (bounds = Array.intersectBound(string == null ? 0 : string.length(), offset, length));
        length = (int) (bounds >> 32);
        out.write(string, offset, length);
    }
}
