/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package java.lang;

import malik.emulator.util.*;

public final class Float extends Object
{
    public static final float NaN = 0.f / 0.f;
    public static final float POSITIVE_INFINITY = +1.f / 0.f;
    public static final float NEGATIVE_INFINITY = -1.f / 0.f;
    public static final float MAX_VALUE = 3.40282346638528860e+38f;
    public static final float MIN_VALUE = 1.40129846432481707e-45f;

    private static final RealValueRepresenter representer;

    static {
        representer = new RealValueRepresenter(RealValueRepresenter.FLOAT_SIGNIFICAND_DIGITS, RealValueRepresenter.FLOAT_ORDER_DIGITS);
    }

    public static boolean isNaN(float value) {
        return value != value;
    }

    public static boolean isInfinite(float value) {
        return value == POSITIVE_INFINITY || value == NEGATIVE_INFINITY;
    }

    public static float parseFloat(String string) throws NumberFormatException {
        return representer.parseFloat(string);
    }

    public static strictfp float intBitsToFloat(int bits) {
        return MalikSystem.getFloatAt(MalikSystem.getLocalVariableAddress(bits));
    }

    public static strictfp int floatToIntBits(float value) {
        return MalikSystem.getIntAt(MalikSystem.getLocalVariableAddress(value));
    }

    public static Float valueOf(String string) throws NumberFormatException {
        float value = representer.parseFloat(string);
        return new Float(value);
    }

    public static String toString(float value) {
        return representer.toString(value);
    }

    private final float value;

    public Float(float value) {
        this.value = value;
    }

    public Float(double value) {
        this.value = (float) value;
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof Float && floatToIntBits(value) == floatToIntBits(((Float) anot).value);
    }

    public int hashCode() {
        return floatToIntBits(value);
    }

    public String toString() {
        return representer.toString(value);
    }

    public boolean isNaN() {
        float value;
        return (value = this.value) != value;
    }

    public boolean isInfinite() {
        float value;
        return (value = this.value) == POSITIVE_INFINITY || value == NEGATIVE_INFINITY;
    }

    public float floatValue() {
        return value;
    }

    public double doubleValue() {
        return (double) value;
    }

    public byte byteValue() {
        return (byte) value;
    }

    public short shortValue() {
        return (short) value;
    }

    public int intValue() {
        return (int) value;
    }

    public long longValue() {
        return (long) value;
    }
}
