/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.fileformats.text.mapped;

import java.io.*;
import java.util.*;
import malik.emulator.fileformats.*;

public abstract class CustomKeyValueList extends Object implements MappedTextDecoder
{
    private final Hashtable list;

    public CustomKeyValueList() {
        this.list = new Hashtable();
    }

    public abstract void loadFromInputStream(InputStream stream) throws IOException;

    public abstract void loadFromInputStream(InputStream stream, String encoding) throws IOException;

    public abstract void loadFromDataStream(ExtendedDataInputStream stream) throws IOException;

    public abstract void loadFromDataStream(ExtendedDataInputStream stream, String encoding) throws IOException;

    public void set(String key, String value) {
        if(key == null)
        {
            throw new NullPointerException("CustomKeyValueList.set: аргумент key равен нулевой ссылке.");
        }
        if(value == null)
        {
            list.remove(key);
            return;
        }
        list.put(key, value);
    }

    public void clear() {
        list.clear();
    }

    public boolean isEmpty() {
        return list.isEmpty();
    }

    public String[] keys() {
        int i = 0;
        int len;
        String[] result;
        Hashtable list;
        result = new String[len = (list = this.list).size()];
        for(Enumeration e = list.keys(); i < len && e.hasMoreElements(); i++) result[i] = (String) e.nextElement();
        if(i < len) Array.copy(result, 0, result = new String[i], 0, i);
        return result;
    }

    public String get(String key) {
        if(key == null)
        {
            throw new NullPointerException("CustomKeyValueList.get: аргумент key равен нулевой ссылке.");
        }
        return (String) list.get(key);
    }
}
