/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.util;

public class RunnableQueue extends Queue
{
    protected Runnable[] runnables;

    public RunnableQueue() {
        this(0x10);
    }

    public RunnableQueue(int initialCapacity) {
        super(initialCapacity);
        initialCapacity = capacity;
        this.runnables = new Runnable[initialCapacity];
    }

    public void clear() {
        Runnable[] q = runnables;
        for(int c = capacity, t = tail, i = head; i != t; i = nextIndex(i, c)) q[i] = null;
        super.clear();
    }

    public void removeHeadElement() {
        int h;
        if((h = head) != tail)
        {
            runnables[h] = null;
            advanceHead(h);
        }
    }

    public void addTailElement(Runnable runnableElement) {
        int t;
        Runnable[] q = runnables;
        if(freeElements() == 0)
        {
            int c = (capacity << 1) - 1;
            q = runnables = (Runnable[]) expand(q, c);
            reset(c);
        }
        t = tail;
        q[t] = runnableElement;
        advanceTail(t);
    }

    public final Runnable peekHeadRunnable() {
        return runnables[head];
    }
}
