/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.util;

public final class StackTraceElement extends Object
{
    private final int lineNumber;
    private final String className;
    private final String methodName;
    private final String sourceName;
    private final String representation;

    public StackTraceElement(String className, String methodName, String sourceName, int lineNumber) {
        StringBuilder representation = (new StringBuilder()).append(className).append('.').append(methodName).append('(').append(sourceName);
        if(lineNumber > 0) representation.append(':').append(lineNumber);
        this.lineNumber = lineNumber;
        this.className = className;
        this.methodName = methodName;
        this.sourceName = sourceName;
        this.representation = representation.append(')').toString();
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof StackTraceElement && ((StackTraceElement) anot).representation.equals(representation);
    }

    public int hashCode() {
        return representation.hashCode();
    }

    public String toString() {
        return representation;
    }

    public int getLineNumber() {
        return lineNumber;
    }

    public String getClassName() {
        return className;
    }

    public String getMethodName() {
        return methodName;
    }

    public String getSourceName() {
        return sourceName;
    }
}
