/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.lcdui;

import java.io.*;
import javax.microedition.media.*;
import malik.emulator.io.cloud.*;

public class AlertType extends Object
{
    public static final AlertType ALARM;
    public static final AlertType CONFIRMATION;
    public static final AlertType ERROR;
    public static final AlertType INFO;
    public static final AlertType WARNING;

    static {
        ALARM = new AlertData("/ui/alarm.png", "/ui/alarm.mid", "audio/midi");
        CONFIRMATION = new AlertData("/ui/confirm.png", "/ui/confirm.mid", "audio/midi");
        ERROR = new AlertData("/ui/error.png", "/ui/error.mid", "audio/midi");
        INFO = new AlertData("/ui/info.png", "/ui/info.mid", "audio/midi");
        WARNING = new AlertData("/ui/warn.png", "/ui/warn.mid", "audio/midi");
    }

    protected AlertType() {
    }

    public boolean playSound(Display display) {
        if(display == null)
        {
            throw new NullPointerException("AlertType.playSound: аргумент display равен нулевой ссылке.");
        }
        return display.isVisible();
    }

    Image getIcon() {
        return null;
    }
}

final class AlertData extends AlertType
{
    private Image icon;
    private final String iconFileName;
    private Player sound;
    private final String soundFileName;
    private final String soundContentType;

    public AlertData(String iconFileName, String soundFileName, String soundContentType) {
        this.iconFileName = iconFileName;
        this.soundFileName = soundFileName;
        this.soundContentType = soundContentType;
    }

    public boolean playSound(Display display) {
        boolean result;
        if(result = super.playSound(display))
        {
            Player sound;
            if((sound = this.sound) == null)
            {
                try
                {
                    InputStream soundFileStream = CloudFileSystem.instance.openFileForRead(soundFileName);
                    try
                    {
                        (sound = this.sound = Manager.createPlayer(soundFileStream, soundContentType)).realize();
                    }
                    finally
                    {
                        soundFileStream.close();
                    }
                    sound.prefetch();
                }
                catch(Exception e)
                {
                    e.printRealStackTrace();
                    return true;
                }
            }
            try
            {
                sound.start();
            }
            catch(MediaException e)
            {
                e.printRealStackTrace();
            }
        }
        return result;
    }

    Image getIcon() {
        Image result;
        if((result = icon) == null)
        {
            try
            {
                InputStream iconFileStream = CloudFileSystem.instance.openFileForRead(iconFileName);
                try
                {
                    result = icon = Image.createImage(iconFileStream);
                }
                finally
                {
                    iconFileStream.close();
                }
            }
            catch(Exception e)
            {
                e.printRealStackTrace();
            }
        }
        return result;
    }
}
