/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.lcdui;

public interface Choice
{
    public static final int EXCLUSIVE = 1;
    public static final int MULTIPLE  = 2;
    public static final int IMPLICIT  = 3;
    public static final int POPUP     = 4;
    public static final int TEXT_WRAP_DEFAULT = 0;
    public static final int TEXT_WRAP_ON      = 1;
    public static final int TEXT_WRAP_OFF     = 2;

    public void insert(int elementIndex, String text, Image icon);

    public void delete(int elementIndex);

    public void deleteAll();

    public void setFitPolicy(int fitPolicy);

    public void setSelectedIndex(int elementIndex, boolean selected);

    public void setSelectedFlags(boolean[] src);

    public void setFont(int elementIndex, Font font);

    public void set(int elementIndex, String text, Image icon);

    public boolean isSelected(int elementIndex);

    public int append(String text, Image icon);

    public int size();

    public int getFitPolicy();

    public int getSelectedIndex();

    public int getSelectedFlags(boolean[] dst);

    public Font getFont(int elementIndex);

    public Image getImage(int elementIndex);

    public String getString(int elementIndex);
}

class ChoiceElement extends Object
{
    public boolean selected;
    public Font font;
    public Image icon;
    public String text;

    public ChoiceElement(boolean selected, String text, Image icon) {
        this.selected = selected;
        this.font = Font.getDefaultFont();
        this.icon = icon;
        this.text = text;
    }
}
