/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.media;

import java.io.*;
import javax.microedition.media.protocol.*;
import malik.emulator.microedition.*;

public final class Manager extends Object
{
    public static final String TONE_DEVICE_LOCATOR = "device://tone";
    public static final String MIDI_DEVICE_LOCATOR = "device://midi";

    public static void playTone(int note, int duration, int volume) throws MediaException {
        DeviceManager.getInstance().playTone(note, duration, volume);
    }

    public static String[] getSupportedContentTypes(String protocol) {
        return DeviceManager.getInstance().getSupportedContentTypes(protocol);
    }

    public static String[] getSupportedProtocols(String contentType) {
        return DeviceManager.getInstance().getSupportedProtocols(contentType);
    }

    public static Player createPlayer(String locator) throws IOException, MediaException {
        if(locator == null)
        {
            throw new IllegalArgumentException("Manager.createPlayer: аргумент locator равен нулевой ссылке.");
        }
        return DeviceManager.getInstance().createPlayer(locator);
    }

    public static Player createPlayer(DataSource source) throws IOException, MediaException {
        if(source == null)
        {
            throw new IllegalArgumentException("Manager.createPlayer: аргумент source равен нулевой ссылке.");
        }
        return DeviceManager.getInstance().createPlayer(source);
    }

    public static Player createPlayer(InputStream stream, String contentType) throws IOException, MediaException {
        if(stream == null)
        {
            throw new IllegalArgumentException("Manager.createPlayer: аргумент stream равен нулевой ссылке.");
        }
        return DeviceManager.getInstance().createPlayer(stream, contentType);
    }

    public static TimeBase getSystemTimeBase() {
        return DeviceManager.getInstance().getSystemTimeBase();
    }

    private Manager() {
    }
}
